/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementCompressionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.TimingVoodoo;

public class DataPurgeJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(DataPurgeJob.class);
    private static long HOUR = 3600000L;
    private static long DAY = 24L * HOUR;

    public static void purgeNow() throws Exception {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        SimpleTrigger trigger = new SimpleTrigger("DataPurgeJobNow", DataPurgeJob.class.getName());
        trigger.setJobName(DataPurgeJob.class.getName());
        trigger.setJobGroup(DataPurgeJob.class.getName());
        scheduler.scheduleJob((Trigger)trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)"Data Purge Job STARTING");
        try {
            try {
                Properties systemConfig = LookupUtil.getSystemManager().getSystemConfiguration();
                this.compressMeasurementData(LookupUtil.getMeasurementCompressionManager());
                this.purgeEverything(systemConfig);
                this.performDatabaseMaintenance(LookupUtil.getSystemManager(), systemConfig);
                this.calculateAutoBaselines(LookupUtil.getMeasurementBaselineManager());
                this.calculateOOBs();
            }
            catch (Exception e) {
                LOG.error((Object)("Data Purge Job FAILED TO COMPLETE. Cause: " + e));
                Object var6_6 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Data Purge Job FINISHED [" + duration + "]ms"));
                return;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Data Purge Job FINISHED [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Data Purge Job FINISHED [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compressMeasurementData(MeasurementCompressionManagerLocal compressionManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Measurement data compression starting at " + new Date(timeStart)));
        try {
            try {
                compressionManager.compressPurgeAndTruncate();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to compress measurement data. Cause: " + e), (Throwable)e);
                Object var6_4 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Measurement data compression completed in [" + duration + "]ms"));
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Measurement data compression completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Measurement data compression completed in [" + duration + "]ms"));
    }

    private void purgeEverything(Properties systemConfig) {
        this.purgeCallTimeData(LookupUtil.getCallTimeDataManager(), systemConfig);
        this.purgeEventData(LookupUtil.getEventManager(), systemConfig);
        this.purgeAlertData(LookupUtil.getAlertManager(), systemConfig);
        this.purgeUnusedAlertDefinitions(LookupUtil.getAlertDefinitionManager());
        this.purgeOrphanedAlertNotifications(LookupUtil.getAlertNotificationManager());
        this.purgeMeasurementTraitData(LookupUtil.getMeasurementDataManager(), systemConfig);
        this.purgeAvailabilityData(LookupUtil.getAvailabilityManager(), systemConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeMeasurementTraitData(MeasurementDataManagerLocal measurementDataManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Trait data purge starting at " + new Date(timeStart)));
        int traitsPurged = 0;
        try {
            try {
                long threshold;
                String traitPurgeThresholdStr = systemConfig.getProperty("TRAIT_PURGE");
                if (traitPurgeThresholdStr == null) {
                    threshold = timeStart - 31536000000L;
                    LOG.debug((Object)"No purge traits threshold found - will purge traits older than one year");
                } else {
                    threshold = timeStart - Long.parseLong(traitPurgeThresholdStr);
                }
                LOG.info((Object)("Purging traits that are older than " + new Date(threshold)));
                traitsPurged = measurementDataManager.purgeTraits(threshold);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge trait data. Cause: " + e), (Throwable)e);
                Object var10_9 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Traits data purged [" + traitsPurged + "] - completed in [" + duration + "]ms"));
                return;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Traits data purged [" + traitsPurged + "] - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Traits data purged [" + traitsPurged + "] - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeAvailabilityData(AvailabilityManagerLocal availabilityManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Availability data purge starting at " + new Date(timeStart)));
        int availsPurged = 0;
        try {
            try {
                long threshold;
                String availPurgeThresholdStr = systemConfig.getProperty("AVAILABILITY_PURGE");
                if (availPurgeThresholdStr == null) {
                    threshold = timeStart - 31536000000L;
                    LOG.debug((Object)"No purge avails threshold found - will purge availabilities older than one year");
                } else {
                    threshold = timeStart - Long.parseLong(availPurgeThresholdStr);
                }
                LOG.info((Object)("Purging availablities that are older than " + new Date(threshold)));
                availsPurged = availabilityManager.purgeAvailabilities(threshold);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge availability data. Cause: " + e), (Throwable)e);
                Object var10_9 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Availability data purged [" + availsPurged + "] - completed in [" + duration + "]ms"));
                return;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Availability data purged [" + availsPurged + "] - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Availability data purged [" + availsPurged + "] - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeCallTimeData(CallTimeDataManagerLocal callTimeDataManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Measurement calltime data purge starting at " + new Date(timeStart)));
        int calltimePurged = 0;
        try {
            try {
                long threshold = timeStart - Long.parseLong(systemConfig.getProperty("RT_DATA_PURGE"));
                LOG.info((Object)("Purging calltime data that is older than " + new Date(threshold)));
                calltimePurged = callTimeDataManager.purgeCallTimeData(new Date(threshold));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge calltime data. Cause: " + e), (Throwable)e);
                Object var9_8 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Calltime purged [" + calltimePurged + "] - completed in [" + duration + "]ms"));
                return;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Calltime purged [" + calltimePurged + "] - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Calltime purged [" + calltimePurged + "] - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeEventData(EventManagerLocal eventManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Event data purge starting at " + new Date(timeStart)));
        int eventsPurged = 0;
        try {
            try {
                long threshold = timeStart - Long.parseLong(systemConfig.getProperty("EVENT_PURGE"));
                LOG.info((Object)("Purging event data older than " + new Date(threshold)));
                eventsPurged = eventManager.purgeEventData(new Date(threshold));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge event data. Cause: " + e), (Throwable)e);
                Object var9_8 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Event data purged [" + eventsPurged + "] - completed in [" + duration + "]ms"));
                return;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Event data purged [" + eventsPurged + "] - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Event data purged [" + eventsPurged + "] - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeAlertData(AlertManagerLocal alertManager, Properties systemConfig) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert data purge starting at " + new Date(timeStart)));
        int alertsPurged = 0;
        try {
            try {
                long threshold = timeStart - Long.parseLong(systemConfig.getProperty("ALERT_PURGE"));
                LOG.info((Object)("Purging alert data older than " + new Date(threshold)));
                alertsPurged = alertManager.deleteAlerts(0L, threshold);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge alert data. Cause: " + e), (Throwable)e);
                Object var9_8 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Alert data purged [" + alertsPurged + "] - completed in [" + duration + "]ms"));
                return;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Alert data purged [" + alertsPurged + "] - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Alert data purged [" + alertsPurged + "] - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeUnusedAlertDefinitions(AlertDefinitionManagerLocal alertDefinitionManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert definition unused purge starting at " + new Date(timeStart)));
        int alertDefinitionsPurged = 0;
        try {
            try {
                alertDefinitionsPurged = alertDefinitionManager.purgeUnusedAlertDefinition();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge alert definition data. Cause: " + e), (Throwable)e);
                Object var7_5 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Alert definitions purged [" + alertDefinitionsPurged + "] - completed in [" + duration + "]ms"));
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Alert definitions purged [" + alertDefinitionsPurged + "] - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Alert definitions purged [" + alertDefinitionsPurged + "] - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void purgeOrphanedAlertNotifications(AlertNotificationManagerLocal alertNotificationManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Alert notification orphan purge starting at " + new Date(timeStart)));
        int orphansPurged = 0;
        try {
            try {
                orphansPurged = alertNotificationManager.purgeOrphanedAlertNotifications();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to purge alert notification data. Cause: " + e), (Throwable)e);
                Object var7_5 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert notifications - completed in [" + duration + "]ms"));
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert notifications - completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Purged [" + orphansPurged + "] orphan alert notifications - completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performDatabaseMaintenance(SystemManagerLocal systemManager, Properties systemConfig) {
        long timeStart;
        block12: {
            block11: {
                timeStart = System.currentTimeMillis();
                LOG.info((Object)("Database maintenance starting at " + new Date(timeStart)));
                try {
                    try {
                        String dataMaintenance = systemConfig.getProperty("CAM_DATA_MAINTENANCE");
                        if (dataMaintenance == null) {
                            LOG.error((Object)"No data maintenance interval found - will not perform db maintenance");
                            Object var12_6 = null;
                            break block11;
                        }
                        long maintInterval = Long.parseLong(dataMaintenance);
                        Calendar cal = Calendar.getInstance();
                        if (cal.get(11) == 0) {
                            LOG.info((Object)"Performing daily database maintenance");
                            systemManager.vacuum(LookupUtil.getSubjectManager().getOverlord());
                            String reindexStr = systemConfig.getProperty("DATA_REINDEX_NIGHTLY");
                            boolean reindexNightly = Boolean.valueOf(reindexStr);
                            if (reindexNightly) {
                                LOG.info((Object)"Re-indexing data tables");
                                systemManager.reindex(LookupUtil.getSubjectManager().getOverlord());
                                break block12;
                            } else {
                                LOG.info((Object)"Skipping re-indexing of data tables");
                            }
                            break block12;
                        }
                        if (TimingVoodoo.roundDownTime(timeStart, HOUR) == TimingVoodoo.roundDownTime(timeStart, maintInterval)) {
                            LOG.info((Object)"Performing hourly database maintenance");
                            systemManager.analyze(LookupUtil.getSubjectManager().getOverlord());
                            break block12;
                        } else {
                            LOG.debug((Object)"Not performing any database maintenance now");
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to perform database maintenance. Cause: " + e), (Throwable)e);
                        Object var12_8 = null;
                        long duration = System.currentTimeMillis() - timeStart;
                        LOG.info((Object)("Database maintenance completed in [" + duration + "]ms"));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_9 = null;
                    long duration = System.currentTimeMillis() - timeStart;
                    LOG.info((Object)("Database maintenance completed in [" + duration + "]ms"));
                    throw throwable;
                }
            }
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Database maintenance completed in [" + duration + "]ms"));
            return;
        }
        Object var12_7 = null;
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Database maintenance completed in [" + duration + "]ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void calculateAutoBaselines(MeasurementBaselineManagerLocal measurementBaselineManager) {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)("Auto-calculation of baselines starting at " + new Date(timeStart)));
        try {
            try {
                measurementBaselineManager.calculateAutoBaselines();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to auto-calculate baselines. Cause: " + e), (Throwable)e);
                Object var6_4 = null;
                long duration = System.currentTimeMillis() - timeStart;
                LOG.info((Object)("Auto-calculation of baselines completed in [" + duration + "]ms"));
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            long duration = System.currentTimeMillis() - timeStart;
            LOG.info((Object)("Auto-calculation of baselines completed in [" + duration + "]ms"));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Auto-calculation of baselines completed in [" + duration + "]ms"));
    }

    public void calculateOOBs() {
        long timeStart = System.currentTimeMillis();
        LOG.info((Object)"Auto-calculation of OOBs starting");
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        MeasurementOOBManagerLocal manager = LookupUtil.getOOBManager();
        long cutOff = System.currentTimeMillis() - 1800000L;
        manager.removeOutdatedOOBs(overlord, cutOff);
        LookupUtil.getSystemManager().vacuum(overlord, new String[]{"RHQ_MEASUREMENT_OOB"});
        manager.computeOOBsFromLastHour(overlord);
        long duration = System.currentTimeMillis() - timeStart;
        LOG.info((Object)("Auto-calculation of OOBs completed in [" + duration + "]ms"));
    }
}

