/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content.sync;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.RepoImportReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoSource;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoSourceSynchronizer {
    private final Log log = LogFactory.getLog(this.getClass());
    private RepoManagerLocal repoManager;
    private SubjectManagerLocal subjectManager;
    private ContentSource source;
    private ContentProvider provider;

    public RepoSourceSynchronizer(ContentSource source, ContentProvider provider) {
        this.source = source;
        this.provider = provider;
        this.repoManager = LookupUtil.getRepoManagerLocal();
        this.subjectManager = LookupUtil.getSubjectManager();
    }

    public void synchronizeCandidateRepos(StringBuilder progress) throws Exception {
        if (!(this.provider instanceof RepoSource)) {
            return;
        }
        progress.append(new Date()).append(": ");
        progress.append("Asking content source for new repositories to import...\n");
        RepoSource repoSource = (RepoSource)((Object)this.provider);
        long start = System.currentTimeMillis();
        RepoImportReport report = repoSource.importRepos();
        Subject overlord = this.subjectManager.getOverlord();
        this.repoManager.processRepoImportReport(overlord, report, this.source.getId(), progress);
        this.log.info((Object)("importRepos: [" + this.source.getName() + "]: report has been merged (" + (System.currentTimeMillis() - start) + ")ms"));
    }
}

