/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.ejb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.jboss.test.cts.ejb.SessionRef;
import org.jboss.test.cts.interfaces.BeanContextInfo;
import org.jboss.test.cts.interfaces.CtsCmpLocal;
import org.jboss.test.cts.interfaces.CtsCmpLocalHome;
import org.jboss.test.cts.interfaces.StatefulSession;
import org.jboss.test.cts.interfaces.StatefulSessionHome;
import org.jboss.test.cts.interfaces.StatelessSession;
import org.jboss.test.cts.interfaces.StatelessSessionHome;
import org.jboss.test.cts.keys.AccountPK;
import org.jboss.test.util.ejb.SessionSupport;

public class BMTStatefulSessionBean
extends SessionSupport {
    private static final long serialVersionUID = 1L;
    private Logger log;
    private String testName;
    private int counter;
    private CtsCmpLocal entityBean;
    private Context enc;
    private Handle sessionHandle;
    private SessionRef sessionRef;
    private byte[] statefulHandle;
    private boolean wasActivated;
    private boolean wasPassivated;

    public void ejbCreate(String testName) {
        this.testName = testName;
        this.log = Logger.getLogger((String)(BMTStatefulSessionBean.class.getName() + "#" + testName));
        this.log.debug((Object)("ejbCreate(" + testName + "), ctx=" + this.sessionCtx));
    }

    public void ejbCreateAlt(String testName) {
        this.testName = testName + "Alt";
        this.log = Logger.getLogger((String)(BMTStatefulSessionBean.class.getName() + "#" + testName));
        this.log.debug((Object)("ejbCreateAlt(" + testName + "), ctx=" + this.sessionCtx));
    }

    public void ejbActivate() {
        this.log = Logger.getLogger((String)(BMTStatefulSessionBean.class.getName() + "#" + this.testName));
        this.log.debug((Object)"ejbActivate( )...");
        this.wasActivated = true;
    }

    public void ejbPassivate() {
        this.log.debug((Object)"ejbPassivate( )...");
        this.wasPassivated = true;
    }

    public String getTestName() {
        return this.testName;
    }

    public String method1(String msg) {
        this.log.debug((Object)("method1( ), msg=" + msg));
        return msg;
    }

    public void incCounter() {
        ++this.counter;
    }

    public void decCounter() {
        --this.counter;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int value) {
        this.counter = value;
    }

    public BeanContextInfo getBeanContextInfo() throws RemoteException {
        BeanContextInfo ctx = new BeanContextInfo();
        this.log.debug((Object)"Getting EJBObject..");
        Class<?> remoteInterface = this.sessionCtx.getEJBObject().getClass();
        ctx.remoteInterface = remoteInterface.getName();
        this.log.debug((Object)"Getting EJBHome...");
        Class<?> homeInterface = this.sessionCtx.getEJBHome().getClass();
        ctx.homeInterface = homeInterface.getName();
        this.log.debug((Object)"calling setRollbackOnly( ) on context");
        this.sessionCtx.setRollbackOnly();
        ctx.isRollbackOnly = new Boolean(this.sessionCtx.getRollbackOnly());
        return ctx;
    }

    public void loopbackTest() throws RemoteException {
        try {
            StatefulSession sessionBean;
            InitialContext ctx = new InitialContext();
            StatefulSessionHome home = (StatefulSessionHome)ctx.lookup("ejbcts/StatefulSessionBean");
            try {
                sessionBean = home.create(this.testName);
            }
            catch (CreateException crex) {
                this.log.debug((Object)("Loopback CreateException: " + (Object)((Object)crex)));
                throw new EJBException((Exception)((Object)crex));
            }
            sessionBean.loopbackTest(this.sessionCtx.getEJBObject());
        }
        catch (NamingException nex) {
            this.log.debug((Object)"Could not locate bean instance");
            throw new EJBException((Exception)nex);
        }
    }

    public void loopbackTest(EJBObject obj) throws RemoteException {
        StatefulSession bean = (StatefulSession)obj;
        bean.method1("Hello");
    }

    public void ping() {
    }

    public void sleep(long wait) {
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException e) {
            throw new EJBException("Interrupted", (Exception)e);
        }
    }

    public boolean getWasActivated() {
        this.log.debug((Object)("getWasActivated( ), wasActivated=" + this.wasActivated));
        return this.wasActivated;
    }

    public boolean getWasPassivated() {
        this.log.debug((Object)("getWasPassivated( ), wasPassivated=" + this.wasPassivated));
        return this.wasPassivated;
    }

    public void createLocalEntity(AccountPK pk, String personsName) throws CreateException {
        try {
            InitialContext ctx = new InitialContext();
            this.enc = (Context)ctx.lookup("java:comp/env");
            CtsCmpLocalHome home = (CtsCmpLocalHome)this.enc.lookup("ejb/CMPBeanLocalHome");
            this.entityBean = home.create(pk, personsName);
        }
        catch (Exception e) {
            this.log.error((Object)"CtsCmpLocal create failed", (Throwable)e);
            throw new EJBException("CtsCmpLocal create failed", e);
        }
    }

    public String readAndRemoveEntity() throws RemoveException {
        String name = this.entityBean.getPersonsName();
        this.entityBean.remove();
        return name;
    }

    public void createSessionHandle() {
        this.log.info((Object)"createSessionHandle");
        try {
            InitialContext ctx = new InitialContext();
            this.enc = (Context)ctx.lookup("java:comp/env");
            StatelessSessionHome home = (StatelessSessionHome)this.enc.lookup("ejb/StatelessSessionHome");
            StatelessSession bean = home.create();
            this.sessionHandle = bean.getHandle();
        }
        catch (Exception e) {
            this.log.error((Object)"StatelessSessionHome create failed", (Throwable)e);
            throw new EJBException("StatelessSessionHome create failed", e);
        }
    }

    public String useSessionHandle(String arg) {
        this.log.info((Object)"useSessionHandle");
        try {
            StatelessSession bean = (StatelessSession)this.sessionHandle.getEJBObject();
            arg = bean.method1(arg);
        }
        catch (Exception e) {
            this.log.error((Object)"StatelessSession handle failed", (Throwable)e);
            throw new EJBException("StatelessSession handle failed", e);
        }
        return arg;
    }

    public void createStatefulSessionHandle(String testName) {
        this.log.info((Object)"createStatefulSessionHandle");
        try {
            StatefulSessionHome home = (StatefulSessionHome)this.sessionCtx.getEJBHome();
            StatefulSession bean = home.create(testName);
            bean.incCounter();
            Handle handle = bean.getHandle();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(handle);
            this.statefulHandle = baos.toByteArray();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to serialize session handle", (Throwable)e);
            throw new EJBException("Failed to serialize session handle", e);
        }
    }

    public void useStatefulSessionHandle() {
        this.log.info((Object)"useStatefulSessionHandle");
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.statefulHandle);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Handle handle = (Handle)ois.readObject();
            StatefulSession bean = (StatefulSession)handle.getEJBObject();
            bean.incCounter();
            int count = bean.getCounter();
            this.log.info((Object)("useStatefulSessionHandle, count=" + count));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to read session from handle", (Throwable)e);
            throw new EJBException("SFailed to read session from handle", e);
        }
    }

    public void createSessionRef() throws RemoteException {
        this.log.info((Object)"createSessionRef");
        Handle handle = this.sessionCtx.getEJBObject().getHandle();
        this.sessionRef = new SessionRef(handle);
    }

    public String useSessionRef() throws RemoteException {
        this.log.info((Object)"useSessionRef");
        Handle handle = this.sessionRef.getHandle();
        return handle.toString();
    }

    public Handle getHandle() {
        try {
            return this.sessionCtx.getEJBObject().getHandle();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void testBadUserTx() {
        UserTransaction tx = this.sessionCtx.getUserTransaction();
        try {
            tx.begin();
        }
        catch (Exception e) {
            this.log.error((Object)"This should work", (Throwable)e);
        }
        throw new Error("Force a rollback without committing/rollingback");
    }
}

