package jboss.test;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;

import jboss.test.TestCacheBean.MyListener;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ha.framework.server.CacheManagerLocator;

@Stateless
@Remote(TestOperation.class)
@RemoteBinding(jndiBinding = "TestOperationBean/remote")
public class TestOperationBean implements TestOperation, Serializable {

	@PersistenceContext
	private EntityManager manager;

	private String cacheConfigName;

	private transient Cache<Object, Object> cache;

	private transient MyListener listener;

	private void createContacts() {
		for (int i = 0; i < 100; i++)
			createCustomer(i);
	}

	private int deleteContacts() {
		String deleteHQL = "delete from Contact";

		int rowsAffected = manager.createQuery(deleteHQL).setFlushMode(
				FlushModeType.AUTO).executeUpdate();

		rowsAffected += manager.createQuery("delete from Customer")
				.setFlushMode(FlushModeType.AUTO).executeUpdate();
		return rowsAffected;
	}

	private Customer createCustomer(int id) {
		System.out.println("CREATE CUSTOMER " + id);
		try {
			Customer customer = new Customer();
			customer.setId(id);
			customer.setName((id % 2 == 0) ? "JBoss" : "Red Hat");
			Set<Contact> contacts = new HashSet<Contact>();

			Contact kabir = new Contact();
			kabir.setId(1000 + id);
			kabir.setCustomer(customer);
			kabir.setName("Kabir");
			kabir.setTlf("1111");
			contacts.add(kabir);

			Contact bill = new Contact();
			bill.setId(2000 + id);
			bill.setCustomer(customer);
			bill.setName("Bill");
			bill.setTlf("2222");
			contacts.add(bill);

			customer.setContacts(contacts);

			manager.persist(customer);
			return customer;
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		} finally {
			System.out.println("CREATE CUSTOMER " + id + " -  END");
		}
	}

	public void remove() {
		// TODO Auto-generated method stub

	}

	public void create() {
		createContacts();
	}

	@PostConstruct
	public void test() {
		getCache("mvcc-entity");

		javax.persistence.Query q = manager
				.createQuery("select p from Customer p");
		q.getResultList();

		q = manager
				.createQuery("select p from Customer p left join p.contacts con where con.id >10");
		q.getResultList();

		q = manager.createQuery("select p from Contact p where p.id>1000");
		q.getResultList();

		q = manager.createQuery("select p from Customer p");
		q.getResultList();
	}

	public void getCache(String cacheConfigName) {
		this.cacheConfigName = cacheConfigName;

		try {
			if (cache == null && cacheConfigName != null) {
				CacheManager cm = CacheManagerLocator.getCacheManagerLocator()
						.getCacheManager(null);
				cache = cm.getCache(cacheConfigName, true);
				cache.start();
			}

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@PreDestroy
	@Remove
	public void cleanup() {
		try {
			if (cache != null && listener != null) {
				cache.removeCacheListener(listener);

				deleteContacts();
			}
		} catch (Exception e) {

		}
	}

}
