/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.io.Serializable;
import java.util.Date;
import org.rhq.core.domain.measurement.AvailabilityType;

public class AvailabilityPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int value;
    private final long timestamp;
    private final boolean known;

    public AvailabilityPoint(AvailabilityType value, long timestamp) {
        if (value != null) {
            this.value = value.ordinal();
            this.timestamp = timestamp;
            this.known = true;
        } else {
            this.value = AvailabilityType.DOWN.ordinal();
            this.timestamp = timestamp;
            this.known = false;
        }
    }

    public AvailabilityPoint(long timestamp) {
        this.value = AvailabilityType.DOWN.ordinal();
        this.timestamp = timestamp;
        this.known = false;
    }

    public boolean isKnown() {
        return this.known;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AvailabilityType getAvailabilityType() {
        return AvailabilityType.values()[this.value];
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AvailabilityPoint ");
        str.append("value=[" + this.value);
        if (!this.known) {
            str.append('?');
        }
        str.append("], timestamp=[" + this.timestamp);
        str.append("(" + new Date(this.timestamp) + ")]");
        return str.toString();
    }
}

