/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ClassLoaderManager;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.RootServerPluginClassLoader;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.alert.AlertServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.entitlement.EntitlementServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.generic.GenericServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.perspective.PerspectiveServerPluginContainer;
import org.rhq.enterprise.server.scheduler.EnhancedScheduler;
import org.rhq.enterprise.server.scheduler.EnhancedSchedulerImpl;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterServerPluginContainer {
    private static final Log log = LogFactory.getLog(MasterServerPluginContainer.class);
    private MasterServerPluginContainerConfiguration configuration;
    private Map<ServerPluginType, AbstractTypeServerPluginContainer> pluginContainers = new HashMap<ServerPluginType, AbstractTypeServerPluginContainer>();
    private ClassLoaderManager classLoaderManager;
    private SchedulerFactory nonClusteredSchedulerFactory;
    private Map<ServerPluginType, List<PluginKey>> disabledPlugins = new HashMap<ServerPluginType, List<PluginKey>>();

    public synchronized void initialize(MasterServerPluginContainerConfiguration config) {
        try {
            log.debug((Object)("Master server plugin container is being initialized with config: " + config));
            this.configuration = config;
            this.initializeNonClusteredScheduler();
            Map<URL, ? extends ServerPluginDescriptorType> plugins = this.preloadAllPlugins();
            ClassLoader rootClassLoader = this.createRootServerPluginClassLoader();
            File tmpDir = this.configuration.getTemporaryDirectory();
            this.classLoaderManager = this.createClassLoaderManager(plugins, rootClassLoader, tmpDir);
            log.debug((Object)("Created classloader manager: " + this.classLoaderManager));
            List<AbstractTypeServerPluginContainer> pcs = this.createPluginContainers();
            for (AbstractTypeServerPluginContainer pc : pcs) {
                this.pluginContainers.put(pc.getSupportedServerPluginType(), pc);
            }
            log.debug((Object)("Created server plugin containers: " + this.pluginContainers.keySet()));
            Iterator<Map.Entry<ServerPluginType, AbstractTypeServerPluginContainer>> iterator = this.pluginContainers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ServerPluginType, AbstractTypeServerPluginContainer> entry = iterator.next();
                ServerPluginType pluginType = entry.getKey();
                AbstractTypeServerPluginContainer pc = entry.getValue();
                log.debug((Object)("Master PC is initializing server plugin container for plugin type [" + pluginType + "]"));
                try {
                    pc.initialize();
                    log.debug((Object)("Master PC initialized server plugin container for plugin type [" + pluginType + "]"));
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to initialize server plugin container for plugin type [" + pluginType + "]"), (Throwable)e);
                    iterator.remove();
                }
            }
            List<PluginKey> allDisabledPlugins = this.getDisabledPluginKeys();
            for (Map.Entry<URL, ? extends ServerPluginDescriptorType> entry : plugins.entrySet()) {
                URL pluginUrl = entry.getKey();
                ServerPluginDescriptorType descriptor = entry.getValue();
                AbstractTypeServerPluginContainer pc = this.getPluginContainerByDescriptor(descriptor);
                if (pc != null) {
                    String pluginName = descriptor.getName();
                    ServerPluginType pluginType = new ServerPluginType(descriptor);
                    PluginKey pluginKey = PluginKey.createServerPluginKey((String)pluginType.stringify(), (String)pluginName);
                    try {
                        ClassLoader classLoader = this.classLoaderManager.obtainServerPluginClassLoader(pluginKey);
                        log.debug((Object)("Pre-loading server plugin [" + pluginKey + "] from [" + pluginUrl + "] into its plugin container"));
                        try {
                            ServerPluginEnvironment env = new ServerPluginEnvironment(pluginUrl, classLoader, descriptor);
                            boolean enabled = !allDisabledPlugins.contains(pluginKey);
                            pc.loadPlugin(env, enabled);
                            log.info((Object)("Preloaded server plugin [" + pluginName + "]"));
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to preload server plugin [" + pluginName + "] from URL [" + pluginUrl + "]"), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to preload server plugin [" + pluginName + "]; cannot get its classloader from URL [ " + pluginUrl + "]"), (Throwable)e);
                    }
                    continue;
                }
                log.warn((Object)("There is no server plugin container to support plugin: " + pluginUrl));
            }
            for (Map.Entry<ServerPluginType, AbstractTypeServerPluginContainer> entry : this.pluginContainers.entrySet()) {
                ServerPluginType pluginType = entry.getKey();
                AbstractTypeServerPluginContainer pc = entry.getValue();
                log.debug((Object)("Master PC is starting server plugin container for plugin type [" + pluginType + "]"));
                try {
                    pc.start();
                    log.info((Object)("Master PC started server plugin container for plugin type [" + pluginType + "]"));
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to start server plugin container for plugin type [" + pluginType + "]"), (Throwable)e);
                }
            }
            log.info((Object)"Master server plugin container has been initialized");
        }
        catch (Throwable t) {
            this.shutdown();
            log.error((Object)"Failed to initialize master plugin container! Server side plugins will not start.", t);
            throw new RuntimeException(t);
        }
    }

    public synchronized void shutdown() {
        AbstractTypeServerPluginContainer pc;
        ServerPluginType pluginType;
        log.debug((Object)"Master server plugin container is being shutdown");
        for (Map.Entry<ServerPluginType, AbstractTypeServerPluginContainer> entry : this.pluginContainers.entrySet()) {
            pluginType = entry.getKey();
            pc = entry.getValue();
            log.debug((Object)("Master PC is stopping server plugin container for plugin type [" + pluginType + "]"));
            try {
                pc.stop();
                log.debug((Object)("Master PC stopped server plugin container for plugin type [" + pluginType + "]"));
            }
            catch (Exception e) {
                log.error((Object)("Failed to stop server plugin container for plugin type [" + pluginType + "]"), (Throwable)e);
            }
        }
        for (Map.Entry<ServerPluginType, AbstractTypeServerPluginContainer> entry : this.pluginContainers.entrySet()) {
            pluginType = entry.getKey();
            pc = entry.getValue();
            log.debug((Object)("Master PC is shutting down server plugin container for plugin type [" + pluginType + "]"));
            try {
                pc.shutdown();
                log.info((Object)("Master PC shutdown server plugin container for plugin type [" + pluginType + "]"));
            }
            catch (Exception e) {
                log.error((Object)("Failed to shutdown server plugin container for plugin type [" + pluginType + "]"), (Throwable)e);
            }
        }
        this.shutdownNonClusteredScheduler();
        if (this.classLoaderManager != null) {
            this.classLoaderManager.shutdown();
            log.debug((Object)("Shutdown classloader manager: " + this.classLoaderManager));
        }
        this.pluginContainers.clear();
        this.disabledPlugins.clear();
        this.classLoaderManager = null;
        this.configuration = null;
        log.info((Object)"Master server plugin container has been shutdown");
    }

    public synchronized void loadPlugin(URL pluginUrl, boolean enabled) throws Exception {
        ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)pluginUrl);
        ServerPluginType pluginType = new ServerPluginType(descriptor);
        PluginKey pluginKey = PluginKey.createServerPluginKey((String)pluginType.stringify(), (String)descriptor.getName());
        this.classLoaderManager.loadPlugin(pluginUrl, descriptor);
        ClassLoader classLoader = this.classLoaderManager.obtainServerPluginClassLoader(pluginKey);
        log.debug((Object)("Loading server plugin [" + pluginKey + "] from [" + pluginUrl + "] into its plugin container"));
        try {
            ServerPluginEnvironment env = new ServerPluginEnvironment(pluginUrl, classLoader, descriptor);
            AbstractTypeServerPluginContainer pc = this.getPluginContainerByDescriptor(descriptor);
            if (pc == null) {
                throw new Exception("No plugin container can load server plugin [" + pluginKey + "]");
            }
            pc.loadPlugin(env, enabled);
            log.info((Object)("Loaded server plugin [" + pluginKey.getPluginName() + "]"));
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load server plugin file [" + pluginUrl + "]"), (Throwable)e);
        }
    }

    public synchronized void scheduleAllPluginJobs() {
        log.debug((Object)"Master server plugin container will schedule all jobs now");
        for (AbstractTypeServerPluginContainer pc : this.pluginContainers.values()) {
            try {
                pc.scheduleAllPluginJobs();
            }
            catch (Exception e) {
                log.error((Object)("Server plugin container for plugin type [" + pc.getSupportedServerPluginType() + "] failed to scheduled some or all of its jobs"), (Throwable)e);
            }
        }
        log.info((Object)"Master server plugin container scheduled all jobs");
    }

    public MasterServerPluginContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    public ClassLoaderManager getClassLoaderManager() {
        return this.classLoaderManager;
    }

    public synchronized List<ServerPluginType> getServerPluginTypes() {
        return new ArrayList<ServerPluginType>(this.pluginContainers.keySet());
    }

    public synchronized <T extends AbstractTypeServerPluginContainer> T getPluginContainerByClass(Class<T> clazz) {
        for (AbstractTypeServerPluginContainer pc : this.pluginContainers.values()) {
            if (!clazz.isInstance(pc)) continue;
            return (T)pc;
        }
        return null;
    }

    public synchronized <T extends AbstractTypeServerPluginContainer> T getPluginContainerByPlugin(PluginKey pluginKey) {
        for (AbstractTypeServerPluginContainer pc : this.pluginContainers.values()) {
            try {
                if (!pc.getSupportedServerPluginType().equals(new ServerPluginType(pluginKey.getPluginType())) || null == pc.getPluginManager().getPluginEnvironment(pluginKey.getPluginName())) continue;
                return (T)pc;
            }
            catch (Exception skip) {
                log.error((Object)("Bad plugin key: " + pluginKey));
            }
        }
        return null;
    }

    public synchronized AbstractTypeServerPluginContainer getPluginContainerByPluginType(ServerPluginType pluginType) {
        AbstractTypeServerPluginContainer pc = this.pluginContainers.get(pluginType);
        return pc;
    }

    protected synchronized AbstractTypeServerPluginContainer getPluginContainerByDescriptor(ServerPluginDescriptorType descriptor) {
        ServerPluginType pluginType = new ServerPluginType(descriptor.getClass());
        AbstractTypeServerPluginContainer pc = this.getPluginContainerByPluginType(pluginType);
        return pc;
    }

    protected Map<URL, ? extends ServerPluginDescriptorType> preloadAllPlugins() throws Exception {
        File[] pluginFiles;
        HashMap<URL, ServerPluginDescriptorType> plugins = new HashMap<URL, ServerPluginDescriptorType>();
        File pluginDirectory = this.configuration.getPluginDirectory();
        if (pluginDirectory != null && (pluginFiles = pluginDirectory.listFiles()) != null) {
            for (File pluginFile : pluginFiles) {
                if (!pluginFile.getName().endsWith(".jar")) continue;
                URL pluginUrl = pluginFile.toURI().toURL();
                try {
                    ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)pluginUrl);
                    if (descriptor == null) continue;
                    log.debug((Object)("pre-loaded server plugin from URL: " + pluginUrl));
                    plugins.put(pluginUrl, descriptor);
                }
                catch (Throwable t) {
                    log.error((Object)("Plugin at [" + pluginUrl + "] could not be pre-loaded. Ignoring it."), t);
                }
            }
        }
        return plugins;
    }

    protected List<PluginKey> getDisabledPluginKeys() {
        List<PluginKey> disabledPlugins = LookupUtil.getServerPlugins().getServerPluginKeysByEnabled(false);
        return disabledPlugins;
    }

    protected List<AbstractTypeServerPluginContainer> createPluginContainers() {
        ArrayList<AbstractTypeServerPluginContainer> pcs = new ArrayList<AbstractTypeServerPluginContainer>(5);
        pcs.add(new GenericServerPluginContainer(this));
        pcs.add(new ContentServerPluginContainer(this));
        pcs.add(new PerspectiveServerPluginContainer(this));
        pcs.add(new AlertServerPluginContainer(this));
        pcs.add(new EntitlementServerPluginContainer(this));
        pcs.add(new BundleServerPluginContainer(this));
        return pcs;
    }

    protected ClassLoader createRootServerPluginClassLoader() {
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        String classesToHideRegexStr = this.configuration.getRootServerPluginClassLoaderRegex();
        RootServerPluginClassLoader root = new RootServerPluginClassLoader(null, thisClassLoader, classesToHideRegexStr);
        return root;
    }

    protected ClassLoaderManager createClassLoaderManager(Map<URL, ? extends ServerPluginDescriptorType> plugins, ClassLoader rootClassLoader, File tmpDir) {
        return new ClassLoaderManager(plugins, rootClassLoader, tmpDir);
    }

    protected void initializeNonClusteredScheduler() throws Exception {
        Properties schedulerConfig = new Properties();
        schedulerConfig.setProperty("org.quartz.jobStore.class", RAMJobStore.class.getName());
        schedulerConfig.setProperty("org.quartz.scheduler.instanceName", "RHQServerPluginsJobs");
        schedulerConfig.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        schedulerConfig.setProperty("org.quartz.threadPool.threadCount", "5");
        schedulerConfig.setProperty("org.quartz.threadPool.threadNamePrefix", "RHQServerPluginsJob");
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(schedulerConfig);
        Scheduler scheduler = factory.getScheduler();
        scheduler.start();
        this.nonClusteredSchedulerFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownNonClusteredScheduler() {
        if (this.nonClusteredSchedulerFactory != null) {
            try {
                Scheduler scheduler = this.nonClusteredSchedulerFactory.getScheduler();
                if (scheduler != null) {
                    scheduler.shutdown(false);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Failed to shutdown master plugin container nonclustered scheduler", (Throwable)e);
            }
            finally {
                this.nonClusteredSchedulerFactory = null;
            }
        }
    }

    protected EnhancedScheduler getNonClusteredScheduler() throws Exception {
        if (this.nonClusteredSchedulerFactory == null) {
            throw new NullPointerException("The non-clustered scheduler has not be initialized");
        }
        return new EnhancedSchedulerImpl(this.nonClusteredSchedulerFactory.getScheduler());
    }

    protected EnhancedScheduler getClusteredScheduler() {
        return LookupUtil.getSchedulerBean();
    }
}

