/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMUserImpl
extends AMObjectImpl
implements AMUser {
    static String roleDNsAN = "nsroledn";
    static String statusAN = "inetUserStatus";
    static String nsroleAN = "nsrole";
    static RDN ContainerDefaultTemplateRoleRDN = new RDN(AMNamingAttrManager.getNamingAttr(8) + "=" + "ContainerDefaultTemplateRole");
    private static AMStoreConnection amsc = null;

    public AMUserImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 1);
    }

    public String rename(String newName, boolean deleteOldName) throws AMException, SSOException {
        this.entryDN = this.dsServices.renameEntry(this.token, this.profileType, this.entryDN, newName, deleteOldName);
        return this.entryDN;
    }

    public Set getFilteredRoleDNs() throws AMException, SSOException {
        HashSet<String> nsroleANSet = new HashSet<String>(1);
        nsroleANSet.add(nsroleAN);
        Map nsrolesMap = this.getAttributesFromDataStore(nsroleANSet);
        Set nsroles = (Set)nsrolesMap.get(nsroleAN);
        Set nsroledns = this.getRoleDNs();
        Iterator iter = nsroledns.iterator();
        HashSet<String> normdns = new HashSet<String>();
        while (iter.hasNext()) {
            normdns.add(new DN((String)iter.next()).toRFCString().toLowerCase());
        }
        HashSet<String> result = new HashSet<String>();
        if (nsroles == null) {
            return result;
        }
        iter = nsroles.iterator();
        AMUserImpl.getAMStoreConnection();
        while (iter.hasNext()) {
            DN nsroleDN;
            RDN rdn;
            String nsrole = (String)iter.next();
            if (normdns.contains(new DN(nsrole).toRFCString().toLowerCase()) || (rdn = (RDN)(nsroleDN = new DN(nsrole)).getRDNs().firstElement()).equals(ContainerDefaultTemplateRoleRDN) || !this.isAMManagedRole(nsrole)) continue;
            result.add(nsroleDN.toString());
        }
        return result;
    }

    public Set getRoleDNs() throws AMException, SSOException {
        return this.getAttribute(roleDNsAN);
    }

    private static void getAMStoreConnection() throws SSOException {
        if (amsc == null) {
            SSOToken internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            amsc = new AMStoreConnection(internalToken);
        }
    }

    private boolean isAMManagedRole(String nsrole) throws SSOException {
        try {
            int type = amsc.getAMObjectType(nsrole);
            return type == 6 || type == 8;
        }
        catch (AMException e) {
            debug.message(nsrole + " is not an AM managed role");
            return false;
        }
    }

    public Set getAllRoleDNs() throws AMException, SSOException {
        HashSet<String> nsroleANSet = new HashSet<String>(1);
        nsroleANSet.add(nsroleAN);
        Map nsrolesMap = this.getAttributesFromDataStore(nsroleANSet);
        Set nsroles = (Set)nsrolesMap.get(nsroleAN);
        HashSet<String> result = new HashSet<String>();
        Iterator iter = nsroles.iterator();
        AMUserImpl.getAMStoreConnection();
        while (iter.hasNext()) {
            String nsrole = (String)iter.next();
            DN nsroleDN = new DN(nsrole);
            RDN rdn = (RDN)nsroleDN.getRDNs().firstElement();
            if (rdn.equals(ContainerDefaultTemplateRoleRDN) || !this.isAMManagedRole(nsrole)) continue;
            result.add(nsroleDN.toString());
        }
        return result;
    }

    public void assignRole(AMRole role) throws AMException, SSOException {
        this.assignRole(role.getDN());
    }

    public void assignRole(String roleDN) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> userDNs = new HashSet<String>();
        userDNs.add(this.entryDN);
        this.dsServices.modifyMemberShip(this.token, userDNs, roleDN, 6, 1);
    }

    public void removeRole(AMRole role) throws AMException, SSOException {
        this.removeRole(role.getDN());
    }

    public void removeRole(String roleDN) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> userDNs = new HashSet<String>();
        userDNs.add(this.entryDN);
        this.dsServices.modifyMemberShip(this.token, userDNs, roleDN, 6, 2);
    }

    public Set getStaticGroupDNs() throws AMException, SSOException {
        return this.getAttribute("iplanet-am-static-group-dn");
    }

    public void assignStaticGroup(AMStaticGroup group) throws AMException, SSOException {
        this.assignStaticGroup(group.getDN());
    }

    public void assignStaticGroup(String groupDN) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> userDNs = new HashSet<String>();
        userDNs.add(this.entryDN);
        this.dsServices.modifyMemberShip(this.token, userDNs, groupDN, 9, 1);
    }

    public void removeStaticGroup(AMStaticGroup group) throws AMException, SSOException {
        this.removeStaticGroup(group.getDN());
    }

    public void removeStaticGroup(String groupDN) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> userDNs = new HashSet<String>();
        userDNs.add(this.entryDN);
        this.dsServices.modifyMemberShip(this.token, userDNs, groupDN, 9, 2);
    }

    public Set getAssignableDynamicGroupDNs() throws AMException, SSOException {
        return this.getAttribute("memberof");
    }

    public void assignAssignableDynamicGroup(AMAssignableDynamicGroup assignableDynamicGroup) throws AMException, SSOException {
        this.assignAssignableDynamicGroup(assignableDynamicGroup.getDN());
    }

    public void assignAssignableDynamicGroup(String assignableDynamicGroupDN) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> userDNs = new HashSet<String>();
        userDNs.add(this.entryDN);
        this.dsServices.modifyMemberShip(this.token, userDNs, assignableDynamicGroupDN, 12, 1);
    }

    public void removeAssignableDynamicGroup(AMAssignableDynamicGroup assignableDynamicGroup) throws AMException, SSOException {
        this.removeAssignableDynamicGroup(assignableDynamicGroup.getDN());
    }

    public void removeAssignableDynamicGroup(String assignableDynamicGroupDN) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> userDNs = new HashSet<String>();
        userDNs.add(this.entryDN);
        this.dsServices.modifyMemberShip(this.token, userDNs, assignableDynamicGroupDN, 12, 2);
    }

    public void activate() throws AMException, SSOException {
        this.setStringAttribute(statusAN, "active");
        this.store();
    }

    public void deactivate() throws AMException, SSOException {
        this.setStringAttribute(statusAN, "inactive");
        this.store();
    }

    public boolean isActivated() throws AMException, SSOException {
        return this.getStringAttribute(statusAN).equalsIgnoreCase("active");
    }

    public void assignServices(Set serviceNames) throws AMException, SSOException {
        if (serviceNames == null || serviceNames.isEmpty()) {
            return;
        }
        Set assignedSerivces = this.getAssignedServices();
        Set newOCs = new HashSet();
        HashSet<String> canAssign = new HashSet<String>();
        for (String serviceName : serviceNames) {
            if (assignedSerivces.contains(serviceName)) {
                debug.error(AMSDKBundle.getString("125"));
                throw new AMException(AMSDKBundle.getString("125", this.locale), "125");
            }
            canAssign.add(serviceName);
            Set serviceOCs = AMServiceUtils.getServiceObjectClasses(this.token, canAssign);
            newOCs.addAll(serviceOCs);
        }
        Set oldOCs = this.getAttribute("objectclass");
        newOCs = AMCommonUtils.combineOCs(newOCs, oldOCs);
        this.setAttribute("objectclass", newOCs);
        this.store();
        for (String thisService : canAssign) {
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(thisService, this.token);
                ServiceSchema ss = null;
                Object[] args = new Object[]{thisService};
                ss = ssm.getSchema(SchemaType.USER);
                if (ss == null) {
                    ss = ssm.getSchema(SchemaType.DYNAMIC);
                }
                if (ss != null) continue;
                debug.error(AMSDKBundle.getString("1001"));
                throw new AMException(AMSDKBundle.getString("1001", args, this.locale), "1001", args);
            }
            catch (SMSException se) {
                debug.error("AMUserImpl: schema type validation failed-> " + thisService, (Throwable)se);
            }
        }
    }
}

