/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.validation;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.validation.DataConstraintException;
import com.iplanet.ums.validation.IValidator;
import com.iplanet.ums.validation.ValidationElement;
import com.sun.identity.shared.ldap.LDAPModification;
import java.util.Enumeration;

public class Validation {
    private static I18n i18n = I18n.getInstance("amSDK");

    public static void validateAttribute(Attr attr, String validatorClass, String rule) throws UMSException, DataConstraintException {
        if (attr != null) {
            String[] values = attr.getStringValues();
            for (int i = 0; i < values.length; ++i) {
                String aValue = values[i];
                if (aValue == null || aValue.equalsIgnoreCase("") || validatorClass == null) continue;
                IValidator validator = null;
                try {
                    Class<?> theClass = Class.forName(validatorClass);
                    validator = (IValidator)theClass.newInstance();
                }
                catch (Exception e) {
                    throw new UMSException(i18n.getString("ums-instancefailed"), e);
                }
                if (validator.validate(aValue, rule)) continue;
                String msg = i18n.getString("validation-dataconstraint");
                throw new DataConstraintException(msg + ": " + "{ type=" + attr.getName() + ", value=" + aValue + " }");
            }
        }
    }

    public static void validateAttribute(Attr attr, Class cls, Guid guid) throws UMSException, DataConstraintException {
        if (attr == null) {
            return;
        }
        String validatorClass = null;
        String rule = null;
        String attrName = attr.getName();
        CreationTemplate ct = TemplateManager.getTemplateManager().getCreationTemplate(cls, guid);
        if (ct != null) {
            Enumeration en = ct.getValidation(attrName);
            while (en.hasMoreElements()) {
                ValidationElement vElement = (ValidationElement)en.nextElement();
                validatorClass = vElement.getValidator();
                rule = vElement.getRule();
                if (validatorClass == null) continue;
                Validation.validateAttribute(attr, validatorClass, rule);
            }
        }
    }

    public static void validateAttributes(AttrSet attrSet, Class cls, Guid guid) throws UMSException, DataConstraintException {
        if (attrSet == null) {
            return;
        }
        String[] attrNames = attrSet.getAttributeNames();
        for (int i = 0; i < attrNames.length; ++i) {
            Attr attr = attrSet.getAttribute(attrNames[i]);
            Validation.validateAttribute(attr, cls, guid);
        }
    }

    public static void validateAttributes(ModSet modSet, Class cls, Guid guid) throws UMSException, DataConstraintException {
        if (modSet == null) {
            return;
        }
        for (int i = 0; i < modSet.size(); ++i) {
            LDAPModification ldapMod = modSet.elementAt(i);
            if (ldapMod.getOp() == 1) continue;
            Attr attr = new Attr(ldapMod.getAttribute());
            Validation.validateAttribute(attr, cls, guid);
        }
    }
}

