/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ModifyAttributeSchemaI18nKey
extends SchemaCommand {
    static final String ARGUMENT_I18N_KEY = "i18nkey";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeSchemaName = this.getStringOptionValue("attributeschema");
        String i18nkey = this.getStringOptionValue(ARGUMENT_I18N_KEY);
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, i18nkey};
            this.writeLog(0, Level.INFO, "ATTEMPT_MODIFY_ATTRIBUTE_SCHEMA_I18N_KEY", params);
            AttributeSchema attrSchema = ss.getAttributeSchema(attributeSchemaName);
            if (attrSchema == null) {
                String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, i18nkey, "attribute schema does not exist"};
                this.attributeSchemaNoExist(attributeSchemaName, "FAILED_MODIFY_ATTRIBUTE_SCHEMA_I18N_KEY", args);
            }
            attrSchema.setI18NKey(i18nkey);
            this.writeLog(0, Level.INFO, "SUCCEED_MODIFY_ATTRIBUTE_SCHEMA_I18N_KEY", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-modify-i18n-key-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, i18nkey, e.getMessage()};
            this.debugError("ModifyAttributeSchemaI18nKey.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_ATTRIBUTE_SCHEMA_I18N_KEY", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, i18nkey, e.getMessage()};
            this.debugError("ModifyAttributeSchemaI18nKey.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_ATTRIBUTE_SCHEMA_I18N_KEY", args);
            throw new CLIException(e, 127);
        }
    }
}

