/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceNotFoundException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

public class AdministrationServiceListener
implements AMConstants,
ServiceListener {
    static Debug debug = Debug.getInstance((String)"amProfile_ldap");
    private static String globalInvalidChars = null;
    private static String globalPluginName = null;
    private static Map invalidCharCache = new HashMap();
    private static Map pluginNameCache = new HashMap();
    private static AdministrationServiceListener serviceListener = new AdministrationServiceListener();

    private AdministrationServiceListener() {
    }

    public static String getOrgInvalidCharsFromCache(String orgDN) {
        String retVal = (String)invalidCharCache.get(orgDN);
        if (debug.messageEnabled()) {
            debug.message("AdministrationServiceListener.getOrgInvalidCharsFromCache: Returning from cache = " + retVal);
        }
        return retVal;
    }

    public static void setOrgInvalidCharsInCache(String orgDN, String invalidChars) {
        invalidCharCache.put(orgDN, invalidChars);
    }

    public static String getGlobalInvalidCharsFromCache() {
        return globalInvalidChars;
    }

    public static void setGlobalInvalidCharsInCache(String invalidChars) {
        globalInvalidChars = invalidChars;
    }

    public static String getOrgPluginNameFromCache(String orgDN) {
        String retVal = (String)pluginNameCache.get(orgDN);
        if (debug.messageEnabled()) {
            debug.message("AdministrationServiceListener.getOrgPluginNameFromCache: Returning from cache = " + retVal);
        }
        return retVal;
    }

    public static void setOrgPluginNameInCache(String orgDN, String pluginName) {
        pluginNameCache.put(orgDN, pluginName);
    }

    public static String getGlobalPluginNameFromCache() {
        return globalPluginName;
    }

    public static void setGlobalPluginNameInCache(String pluginName) {
        globalPluginName = pluginName;
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AdministrationServiceListener.globalConfigChanged : Global Config changed for Service = " + serviceName + " Change type = " + type);
        }
        globalInvalidChars = null;
        globalPluginName = null;
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String goupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AdministrationServiceListener.organizationConfigChanged : Config changed for Org=" + orgName + "Service = " + serviceName + " Change type = " + type);
        }
        if (type != 1) {
            invalidCharCache.remove(orgName);
            pluginNameCache.remove(orgName);
        }
    }

    static {
        SSOToken ssot = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMAdminConsoleService", ssot);
            scm.addListener(serviceListener);
            debug.message("AdministrationServiceListener: Listener added.");
        }
        catch (ServiceNotFoundException exp) {
            debug.error("AdministrationServiceListener: Can not register Listener", (Throwable)exp);
        }
        catch (SMSException smsExp) {
            debug.error("AdministrationServiceListener: Can not register Listener", (Throwable)smsExp);
        }
        catch (SSOException ssoExp) {
            debug.error("AdministrationServiceListener: Can not register Listener", (Throwable)((Object)ssoExp));
        }
    }
}

