/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.plugins.URLResourceName;
import com.sun.identity.shared.debug.Debug;

public class HttpURLResourceName
extends URLResourceName {
    private Debug debug = Debug.getInstance((String)"amPolicy");

    public ResourceMatch compare(String requestResource, String targetResource, boolean wildcardCompare) {
        if (requestResource == null || targetResource == null) {
            return ResourceMatch.NO_MATCH;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("HttpURLResourceName.compare: request resource=" + requestResource + "; policy resource=" + targetResource);
        }
        int requestIndex = requestResource.indexOf("?");
        int targetIndex = targetResource.indexOf("?");
        if (requestIndex >= 0 || targetIndex >= 0) {
            ResourceMatch substring1Res;
            ResourceMatch result = ResourceMatch.NO_MATCH;
            String requestSubstring1 = requestResource;
            String requestSubstring2 = null;
            if (requestIndex >= 0) {
                requestSubstring1 = requestResource.substring(0, requestIndex);
                if (requestResource.length() > requestIndex + 1) {
                    requestSubstring2 = requestResource.substring(requestIndex + 1);
                }
            }
            String targetSubstring1 = targetResource;
            String targetSubstring2 = null;
            if (targetIndex >= 0) {
                targetSubstring1 = targetResource.substring(0, targetIndex);
                if (targetResource.length() > targetIndex + 1) {
                    targetSubstring2 = targetResource.substring(targetIndex + 1);
                }
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("HttpURLResourceName.compare: request resource substring1=" + requestSubstring1 + "; request resource substring2=" + requestSubstring2 + "; policy resource substring1=" + targetSubstring1 + "; policy resource substring2=" + targetSubstring2);
            }
            if ((substring1Res = this.compare(requestSubstring1, targetSubstring1, wildcardCompare)) == ResourceMatch.EXACT_MATCH || substring1Res == ResourceMatch.WILDCARD_MATCH) {
                if (requestSubstring2 == null || requestSubstring2.trim().length() == 0) {
                    return ResourceMatch.SUB_RESOURCE_MATCH;
                }
                if (targetSubstring2 == null || targetSubstring2.trim().length() == 0) {
                    return ResourceMatch.SUPER_RESOURCE_MATCH;
                }
                ResourceMatch substring2Res = this.compare(requestSubstring2, targetSubstring2, wildcardCompare);
                if (substring2Res == ResourceMatch.EXACT_MATCH || substring2Res == ResourceMatch.WILDCARD_MATCH) {
                    result = substring1Res == substring2Res ? substring2Res : ResourceMatch.WILDCARD_MATCH;
                }
            } else {
                result = substring1Res;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("HttpURLResourceName.compare: with query string ; result=" + result);
            }
            return result;
        }
        if (!wildcardCompare || !targetResource.endsWith(this.delimiter + this.wildcard)) {
            return super.compare(requestResource, targetResource, wildcardCompare);
        }
        int strlen = targetResource.length();
        String substr = targetResource.substring(0, strlen - 2);
        ResourceMatch res = super.compare(requestResource, substr, wildcardCompare);
        res = res == ResourceMatch.EXACT_MATCH || res == ResourceMatch.WILDCARD_MATCH || res == ResourceMatch.SUPER_RESOURCE_MATCH ? ResourceMatch.WILDCARD_MATCH : (res == ResourceMatch.SUB_RESOURCE_MATCH ? ResourceMatch.SUB_RESOURCE_MATCH : ResourceMatch.NO_MATCH);
        if (this.debug.messageEnabled()) {
            this.debug.message("HttpURLResourceName.compare: result=" + res);
        }
        return res;
    }
}

