/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GetHostedIDPs
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        String realm = this.getString(params, "realm");
        String cot = this.getString(params, "cot");
        try {
            CircleOfTrustManager cotMgr = new CircleOfTrustManager();
            Set entities = cotMgr.listCircleOfTrustMember(realm, cot, "saml2");
            SAML2MetaManager mgr = new SAML2MetaManager();
            StringBuffer buff = new StringBuffer();
            boolean first = true;
            for (String entityId : entities) {
                EntityDescriptorElement desc;
                EntityConfigElement elm = mgr.getEntityConfig(realm, entityId);
                if (!elm.isHosted() || SAML2MetaUtils.getIDPSSODescriptor((EntityDescriptorElement)(desc = mgr.getEntityDescriptor(realm, entityId))) == null) continue;
                if (first) {
                    first = false;
                } else {
                    buff.append("|");
                }
                buff.append(entityId);
            }
            return buff.toString();
        }
        catch (COTException e) {
            throw new WorkflowException(e.getMessage(), null);
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage(), null);
        }
    }
}

