/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.field.AddressListField;
import org.apache.james.mime4j.field.DateTimeField;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.field.MailboxField;
import org.apache.james.mime4j.field.MailboxListField;
import org.apache.james.mime4j.field.UnstructuredField;
import org.apache.james.mime4j.field.address.Address;
import org.apache.james.mime4j.field.address.AddressList;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.MessageBuilder;
import org.apache.james.mime4j.message.MessageWriter;
import org.apache.james.mime4j.parser.MimeEntityConfig;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;

public class Message
extends Entity
implements Body {
    public Message() {
    }

    public Message(Message other) {
        super(other);
    }

    public Message(InputStream is) throws IOException, MimeIOException {
        this(is, null, DefaultStorageProvider.getInstance());
    }

    public Message(InputStream is, MimeEntityConfig config) throws IOException, MimeIOException {
        this(is, config, DefaultStorageProvider.getInstance());
    }

    public Message(InputStream is, MimeEntityConfig config, StorageProvider storageProvider) throws IOException, MimeIOException {
        try {
            MimeStreamParser parser = new MimeStreamParser(config);
            parser.setContentHandler(new MessageBuilder(this, storageProvider));
            parser.parse(is);
        }
        catch (MimeException e) {
            throw new MimeIOException(e);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        MessageWriter.DEFAULT.writeEntity(this, out);
    }

    public String getMessageId() {
        Object field = this.obtainField("Message-ID");
        if (field == null) {
            return null;
        }
        return field.getBody();
    }

    public void createMessageId(String hostname) {
        Header header = this.obtainHeader();
        header.setField(Fields.messageId(hostname));
    }

    public String getSubject() {
        UnstructuredField field = (UnstructuredField)this.obtainField("Subject");
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public void setSubject(String subject) {
        Header header = this.obtainHeader();
        if (subject == null) {
            header.removeFields("Subject");
        } else {
            header.setField(Fields.subject(subject));
        }
    }

    public Date getDate() {
        DateTimeField dateField = (DateTimeField)this.obtainField("Date");
        if (dateField == null) {
            return null;
        }
        return dateField.getDate();
    }

    public void setDate(Date date) {
        this.setDate(date, null);
    }

    public void setDate(Date date, TimeZone zone) {
        Header header = this.obtainHeader();
        if (date == null) {
            header.removeFields("Date");
        } else {
            header.setField(Fields.date("Date", date, zone));
        }
    }

    public Mailbox getSender() {
        return this.getMailbox("Sender");
    }

    public void setSender(Mailbox sender) {
        this.setMailbox("Sender", sender);
    }

    public MailboxList getFrom() {
        return this.getMailboxList("From");
    }

    public void setFrom(Mailbox from) {
        this.setMailboxList("From", from);
    }

    public void setFrom(Mailbox ... from) {
        this.setMailboxList("From", from);
    }

    public void setFrom(Collection<Mailbox> from) {
        this.setMailboxList("From", from);
    }

    public AddressList getTo() {
        return this.getAddressList("To");
    }

    public void setTo(Address to) {
        this.setAddressList("To", to);
    }

    public void setTo(Address ... to) {
        this.setAddressList("To", to);
    }

    public void setTo(Collection<Address> to) {
        this.setAddressList("To", to);
    }

    public AddressList getCc() {
        return this.getAddressList("Cc");
    }

    public void setCc(Address cc) {
        this.setAddressList("Cc", cc);
    }

    public void setCc(Address ... cc) {
        this.setAddressList("Cc", cc);
    }

    public void setCc(Collection<Address> cc) {
        this.setAddressList("Cc", cc);
    }

    public AddressList getBcc() {
        return this.getAddressList("Bcc");
    }

    public void setBcc(Address bcc) {
        this.setAddressList("Bcc", bcc);
    }

    public void setBcc(Address ... bcc) {
        this.setAddressList("Bcc", bcc);
    }

    public void setBcc(Collection<Address> bcc) {
        this.setAddressList("Bcc", bcc);
    }

    public AddressList getReplyTo() {
        return this.getAddressList("Reply-To");
    }

    public void setReplyTo(Address replyTo) {
        this.setAddressList("Reply-To", replyTo);
    }

    public void setReplyTo(Address ... replyTo) {
        this.setAddressList("Reply-To", replyTo);
    }

    public void setReplyTo(Collection<Address> replyTo) {
        this.setAddressList("Reply-To", replyTo);
    }

    private Mailbox getMailbox(String fieldName) {
        MailboxField field = (MailboxField)this.obtainField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getMailbox();
    }

    private void setMailbox(String fieldName, Mailbox mailbox) {
        Header header = this.obtainHeader();
        if (mailbox == null) {
            header.removeFields(fieldName);
        } else {
            header.setField(Fields.mailbox(fieldName, mailbox));
        }
    }

    private MailboxList getMailboxList(String fieldName) {
        MailboxListField field = (MailboxListField)this.obtainField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getMailboxList();
    }

    private void setMailboxList(String fieldName, Mailbox mailbox) {
        this.setMailboxList(fieldName, mailbox == null ? null : Collections.singleton(mailbox));
    }

    private void setMailboxList(String fieldName, Mailbox ... mailboxes) {
        this.setMailboxList(fieldName, mailboxes == null ? null : Arrays.asList(mailboxes));
    }

    private void setMailboxList(String fieldName, Collection<Mailbox> mailboxes) {
        Header header = this.obtainHeader();
        if (mailboxes == null || mailboxes.isEmpty()) {
            header.removeFields(fieldName);
        } else {
            header.setField(Fields.mailboxList(fieldName, mailboxes));
        }
    }

    private AddressList getAddressList(String fieldName) {
        AddressListField field = (AddressListField)this.obtainField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getAddressList();
    }

    private void setAddressList(String fieldName, Address address) {
        this.setAddressList(fieldName, address == null ? null : Collections.singleton(address));
    }

    private void setAddressList(String fieldName, Address ... addresses) {
        this.setAddressList(fieldName, addresses == null ? null : Arrays.asList(addresses));
    }

    private void setAddressList(String fieldName, Collection<Address> addresses) {
        Header header = this.obtainHeader();
        if (addresses == null || addresses.isEmpty()) {
            header.removeFields(fieldName);
        } else {
            header.setField(Fields.addressList(fieldName, addresses));
        }
    }
}

