/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api.invocation.response;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;

public class ContentResponse
extends PortletInvocationResponse {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int TYPE_EMPTY = 0;
    public static final int TYPE_CHARS = 1;
    public static final int TYPE_BYTES = 2;
    private final ResponseProperties properties;
    private final Map<String, Object> attributes;
    private String contentType;
    private final String encoding;
    private final byte[] bytes;
    private final String chars;
    private final CacheControl cacheControl;

    public ContentResponse(ResponseProperties properties, Map<String, Object> attributes, String contentType, String encoding, byte[] bytes, CacheControl cacheControl) {
        this.properties = properties;
        this.attributes = attributes;
        this.contentType = contentType;
        this.encoding = encoding;
        this.bytes = bytes;
        this.chars = null;
        this.cacheControl = cacheControl;
    }

    public ContentResponse(ResponseProperties properties, Map<String, Object> attributes, String contentType, String encoding, String chars, CacheControl cacheControl) {
        this.properties = properties;
        this.attributes = attributes;
        this.contentType = contentType;
        this.encoding = encoding;
        this.bytes = null;
        this.chars = chars;
        this.cacheControl = cacheControl;
    }

    public ContentResponse(ResponseProperties properties, Map<String, Object> attributes, String contentType, CacheControl cacheControl) {
        this.properties = properties;
        this.attributes = attributes;
        this.contentType = contentType;
        this.encoding = null;
        this.bytes = null;
        this.chars = null;
        this.cacheControl = cacheControl;
    }

    public ContentResponse(ContentResponse that, CacheControl cacheControl) {
        if (that == null) {
            throw new IllegalArgumentException("No null content response can be provided for copy");
        }
        this.properties = that.properties;
        this.attributes = that.attributes;
        this.contentType = that.contentType;
        this.encoding = that.encoding;
        this.bytes = that.bytes;
        this.chars = that.chars;
        this.cacheControl = cacheControl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ResponseProperties getProperties() {
        return this.properties;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public int getType() {
        if (this.bytes == null) {
            if (this.chars == null) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public String getContent() throws UnsupportedCharsetException {
        Charset charset = UTF_8;
        if (this.encoding != null) {
            charset = Charset.forName(this.encoding);
        }
        return this.getContent(charset);
    }

    public String getContent(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("No null charset accepted");
        }
        switch (this.getType()) {
            case 1: {
                return this.getChars();
            }
            case 2: {
                return new String(this.bytes, charset);
            }
            case 0: {
                return "";
            }
        }
        throw new AssertionError();
    }

    public byte[] getBytes() throws IllegalArgumentException {
        return this.bytes;
    }

    public String getChars() throws IllegalArgumentException {
        return this.chars;
    }

    public String getContentType() {
        return this.contentType;
    }
}

