/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PropertyChange {
    public static final int PREF_UPDATE = 0;
    public static final int PREF_RESET = 1;
    private final String key;
    private final List<String> value;

    public static PropertyChange newUpdate(String key, String value) {
        return new PropertyChange(key, Collections.singletonList(value));
    }

    public static PropertyChange newUpdate(String key, String[] value) {
        if (value == null) {
            throw new IllegalArgumentException("No value provided");
        }
        return new PropertyChange(key, Collections.unmodifiableList(Arrays.asList((Object[])value.clone())));
    }

    public static PropertyChange newUpdate(String key, List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("No value provided");
        }
        return new PropertyChange(key, Collections.unmodifiableList(new ArrayList<String>(value)));
    }

    public static PropertyChange newReset(String key) {
        return new PropertyChange(key, null);
    }

    private PropertyChange(String key, List<String> value) {
        if (key == null) {
            throw new IllegalArgumentException("No key provided");
        }
        this.key = key;
        this.value = value;
    }

    public int getType() {
        return this.value == null ? 1 : 0;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getValue() {
        return this.value;
    }
}

