/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.osgi.resolver.XWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

public class AbstractWiring
implements XWiring {
    private final Resource resource;
    private final List<Wire> required;
    private List<Wire> provided;

    public AbstractWiring(Resource resource, List<Wire> wires) {
        this.resource = resource;
        this.required = wires;
    }

    protected void addProvidedWire(Wire wire) {
        if (this.provided == null) {
            this.provided = new ArrayList<Wire>();
        }
        this.provided.add(wire);
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        return this.resource.getCapabilities(namespace);
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        return this.resource.getRequirements(namespace);
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        if (this.provided != null) {
            for (Wire wire : this.provided) {
                Capability cap = wire.getCapability();
                if (namespace != null && !namespace.equals(cap.getNamespace())) continue;
                result.add(wire);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        if (this.required != null) {
            for (Wire wire : this.required) {
                Requirement req = wire.getRequirement();
                if (namespace != null && !namespace.equals(req.getNamespace())) continue;
                result.add(wire);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        return "Wiring[" + this.resource + "]";
    }
}

