/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Marshaller;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractMarshaller
implements Marshaller {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected String version = "1.0";
    protected String encoding = "UTF-8";
    protected List<QName> rootQNames = new ArrayList<QName>();
    protected NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private Map<Class<?>, ClassMapping> classMappings = Collections.emptyMap();
    protected Map<Class<?>, FieldToWildcardMapping> field2WildcardMap = Collections.emptyMap();
    protected Map<Class<?>, QName> cls2TypeMap = Collections.emptyMap();
    protected Content content = new Content();
    private Properties props;

    @Override
    public void mapClassToGlobalElement(Class<?> cls, String localName, String namespaceUri, String schemaUrl, ObjectModelProvider provider) {
        GenericObjectModelProvider delProv = null;
        if (provider != null) {
            delProv = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        }
        ClassMapping mapping = new ClassMapping(cls, localName, null, namespaceUri, schemaUrl, delProv);
        this.addClassMapping(mapping);
    }

    @Override
    public void mapClassToGlobalType(Class<?> cls, String localName, String nsUri, String schemaUrl, ObjectModelProvider provider) {
        ClassMapping mapping = new ClassMapping(cls, null, localName, nsUri, schemaUrl, provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
        this.addClassMapping(mapping);
    }

    public void mapFieldToWildcard(Class<?> cls, String field, ObjectLocalMarshaller marshaller) {
        FieldToWildcardMapping mapping = new FieldToWildcardMapping(cls, field, marshaller);
        if (this.field2WildcardMap.isEmpty()) {
            this.field2WildcardMap = new HashMap(this.field2WildcardMap);
        }
        this.field2WildcardMap.put(cls, mapping);
    }

    public void mapClassToXsiType(Class<?> cls, String typeNs, String typeLocalPart) {
        QName typeQName = new QName(typeNs, typeLocalPart);
        if (this.cls2TypeMap.isEmpty()) {
            this.cls2TypeMap = new HashMap(this.cls2TypeMap);
        }
        this.cls2TypeMap.put(cls, typeQName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("mapped " + cls + " to xsi:type " + typeQName));
        }
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void mapPublicIdToSystemId(String publicId, String systemId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addRootElement(String namespaceUri, String prefix, String name) {
        this.addRootElement(new QName(namespaceUri, name, prefix));
    }

    public void addRootElement(QName qName) {
        this.rootQNames.add(qName);
    }

    @Override
    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.props == null ? null : this.props.getProperty(name);
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            return;
        }
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void removePrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public String getPrefix(String ns) {
        String prefix = this.nsRegistry.getPrefix(ns);
        if (prefix == null && "http://www.w3.org/XML/1998/namespace".equals(ns)) {
            prefix = "xml";
        }
        return prefix;
    }

    protected void declareNs(AttributesImpl attrs) {
        Iterator<String> i = this.nsRegistry.getRegisteredURIs();
        while (i.hasNext()) {
            String uri = i.next();
            String prefix = this.nsRegistry.getPrefix(uri);
            AbstractMarshaller.declareNs(attrs, prefix, uri);
        }
    }

    protected static void declareNs(AttributesImpl attrs, String prefix, String ns) {
        attrs.add(null, prefix, prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, "CDATA", ns);
    }

    protected String declareXsiType(QName typeQName, AttributesImpl attrs) {
        String pref;
        String result = null;
        String xsiPrefix = this.nsRegistry.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            AbstractMarshaller.declareNs(attrs, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xsiPrefix = "xsi";
        }
        if ((pref = this.getPrefix(typeQName.getNamespaceURI())) == null) {
            result = pref = typeQName.getLocalPart() + "_ns";
        }
        String qName = AbstractMarshaller.prefixLocalName(pref, typeQName.getLocalPart());
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ":type", "CDATA", qName);
        return result;
    }

    protected static String prefixLocalName(String prefix, String local) {
        return prefix == null || prefix.length() == 0 ? local : prefix + ':' + local;
    }

    public abstract void addAttribute(String var1, String var2, String var3, String var4);

    protected boolean propertyIsTrueOrNotSet(String name) {
        String value = this.getProperty(name);
        return value == null || "true".equalsIgnoreCase(value);
    }

    protected void writeXmlVersion(Writer writer) throws IOException {
        String xmlVersion = this.getProperty("org.jboss.xml.binding.marshalling.version");
        if (xmlVersion == null || "true".equalsIgnoreCase(xmlVersion)) {
            writer.write("<?xml version=\"");
            writer.write(this.version);
            writer.write("\" encoding=\"");
            writer.write(this.encoding);
            writer.write("\"?>\n");
        }
    }

    protected ClassMapping getClassMapping(Class<?> cls) {
        return this.classMappings.get(cls);
    }

    private void addClassMapping(ClassMapping mapping) {
        if (this.classMappings.isEmpty()) {
            this.classMappings = new HashMap();
        }
        this.classMappings.put(mapping.cls, mapping);
    }

    public class ContentHandlerAdaptor
    implements ContentHandler {
        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            AbstractMarshaller.this.content.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            AbstractMarshaller.this.content.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AbstractMarshaller.this.content.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            AbstractMarshaller.this.content.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            AbstractMarshaller.this.content.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    public static class StackImpl
    implements Stack {
        private List<Object> list = new ArrayList<Object>();

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public void push(Object o) {
            this.list.add(o);
        }

        @Override
        public Object pop() {
            return this.list.remove(this.list.size() - 1);
        }

        @Override
        public Object peek() {
            return this.list.get(this.list.size() - 1);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    protected static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }

    protected class FieldToWildcardMapping {
        public final Class<?> cls;
        public final ObjectLocalMarshaller marshaller;
        public final FieldInfo fieldInfo;

        public FieldToWildcardMapping(Class<?> cls, String field, ObjectLocalMarshaller marshaller) {
            if (AbstractMarshaller.this.log.isTraceEnabled()) {
                AbstractMarshaller.this.log.trace((Object)("new FieldToWildcardMapping: [cls=" + cls.getName() + ",field=" + field + "]"));
            }
            this.cls = cls;
            this.marshaller = marshaller;
            this.fieldInfo = FieldInfo.getFieldInfo(cls, field, true);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldToWildcardMapping)) {
                return false;
            }
            FieldToWildcardMapping fieldToWildcardMapping = (FieldToWildcardMapping)o;
            if (!this.cls.equals(fieldToWildcardMapping.cls)) {
                return false;
            }
            return this.fieldInfo.getName().equals(fieldToWildcardMapping.fieldInfo.getName());
        }

        public int hashCode() {
            int result = this.cls.hashCode();
            result = 29 * result + this.fieldInfo.getName().hashCode();
            return result;
        }
    }

    protected class ClassMapping {
        public final Class<?> cls;
        public final QName elementName;
        public final QName typeName;
        public final String schemaUrl;
        public final GenericObjectModelProvider provider;

        public ClassMapping(Class<?> cls, String elementName, String typeName, String nsUri, String schemaUrl, GenericObjectModelProvider provider) {
            this.cls = cls;
            if (elementName != null) {
                this.elementName = nsUri == null ? new QName(elementName) : new QName(nsUri, elementName);
                this.typeName = null;
            } else if (typeName != null) {
                this.elementName = null;
                this.typeName = nsUri == null ? new QName(typeName) : new QName(nsUri, typeName);
            } else {
                throw new JBossXBRuntimeException("Element or type name must not null for " + cls);
            }
            this.schemaUrl = schemaUrl;
            this.provider = provider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassMapping that = (ClassMapping)o;
            if (this.cls != null ? !this.cls.equals(that.cls) : that.cls != null) {
                return false;
            }
            if (this.elementName != null ? !this.elementName.equals(that.elementName) : that.elementName != null) {
                return false;
            }
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) {
                return false;
            }
            if (this.schemaUrl != null ? !this.schemaUrl.equals(that.schemaUrl) : that.schemaUrl != null) {
                return false;
            }
            return !(this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.elementName != null ? this.elementName.hashCode() : 0);
            result = 29 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            result = 29 * result + (this.schemaUrl != null ? this.schemaUrl.hashCode() : 0);
            result = 29 * result + (this.provider != null ? this.provider.hashCode() : 0);
            return result;
        }
    }
}

