/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RegisteredAttributesHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;
import org.xml.sax.Attributes;

public class BeanHandler
implements ParticleHandler {
    protected static final Logger log = Logger.getLogger((String)"org.jboss.xb.builder.runtime.BeanHandler");
    protected boolean trace = log.isTraceEnabled();
    protected String name;
    protected BeanAdapterFactory beanAdapterFactory;
    protected TypeBinding elementType;
    private RegisteredAttributesHandler attrsHandler = new RegisteredAttributesHandler();

    public BeanHandler(String name, BeanAdapterFactory beanAdapterFactory, TypeBinding elementType) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (beanAdapterFactory == null) {
            throw new IllegalArgumentException("Null bean adapter factory");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Null element type");
        }
        this.name = name;
        this.beanAdapterFactory = beanAdapterFactory;
        this.elementType = elementType;
    }

    public BeanAdapterFactory getBeanAdapterFactory() {
        return this.beanAdapterFactory;
    }

    @Override
    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        if (this.trace) {
            log.trace((Object)(" startElement " + elementName + " bean=" + this.name + " parent=" + BuilderUtil.toDebugString(parent)));
        }
        BeanAdapter o = null;
        try {
            o = this.beanAdapterFactory.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + elementName + " error invoking beanAdapterFactory.newInstance() for bean=" + this.name, t);
        }
        if (o != null) {
            this.attrsHandler.attributes(o, elementName, this.elementType, attrs, nsCtx);
        }
        return o;
    }

    @Override
    public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle) {
        BeanAdapter beanAdapter;
        AbstractPropertyHandler propertyHandler;
        if (this.trace) {
            log.trace((Object)("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
        }
        if ((propertyHandler = (beanAdapter = (BeanAdapter)parent).getPropertyHandler(qName)) == null) {
            if (this.elementType.getSchemaBinding().isStrictSchema()) {
                throw new RuntimeException("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o) + " available=" + beanAdapter.getAvailable());
            }
            if (this.trace) {
                log.trace((Object)("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
            }
            return;
        }
        propertyHandler.doHandle(beanAdapter, o, qName);
    }

    @Override
    public Object endParticle(Object o, QName qName, ParticleBinding particle) {
        ValueAdapter valueAdapter;
        if (this.trace) {
            log.trace((Object)("endElement " + qName + " o=" + BuilderUtil.toDebugString(o)));
        }
        BeanAdapter beanAdapter = (BeanAdapter)o;
        Object value = beanAdapter.getValue();
        if (!particle.isRepeatable() && (valueAdapter = particle.getTerm().getValueAdapter()) != null) {
            value = valueAdapter.cast(value, null);
        }
        return value;
    }

    public RegisteredAttributesHandler getAttributesHandler() {
        return this.attrsHandler;
    }
}

