/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.xml.sax.Attributes;

public class BuilderParticleHandler
implements ParticleHandler {
    public static final BuilderParticleHandler INSTANCE = new BuilderParticleHandler();

    @Override
    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        return parent;
    }

    @Override
    public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (!particle.getTerm().isModelGroup()) {
            ParticleHandler particleHandler = null;
            TermBinding parentTerm = parentParticle.getTerm();
            if (!parentTerm.isSkip()) {
                particleHandler = parentTerm.getHandler();
            }
            if (particleHandler != null) {
                particleHandler.setParent(parent, o, elementName, particle, parentParticle);
            }
        }
    }

    @Override
    public Object endParticle(Object o, QName elementName, ParticleBinding particle) {
        ValueAdapter valueAdapter = particle.getTerm().getValueAdapter();
        if (valueAdapter != null) {
            o = valueAdapter.cast(o, null);
        }
        return o;
    }

    public static ParticleHandler setParentDelegate(final ParticleHandler typeHandler) {
        return new ParticleHandler(){
            private final ParticleHandler delegate;
            {
                this.delegate = typeHandler;
            }

            @Override
            public Object endParticle(Object o, QName elementName, ParticleBinding particle) {
                return o;
            }

            @Override
            public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
                if (particle.getTerm().isElement()) {
                    this.delegate.setParent(parent, o, elementName, particle, parentParticle);
                }
            }

            @Override
            public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
                return parent;
            }
        };
    }

    public static ParticleHandler parentGroup(ModelGroupBinding group) {
        if (group.isSkip()) {
            return DefaultHandlers.NOOP_PARTICLE_HANDLER;
        }
        ParticleHandler handler = group.getHandler();
        if (handler == null) {
            throw new JBossXBRuntimeException("The group is expected to have a non-null handler: " + group);
        }
        return BuilderParticleHandler.setParentDelegate(handler);
    }
}

