/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.binding;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.common.utils.HashCodeUtil;
import org.jboss.ws.core.jaxrpc.binding.Base64DeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.Base64SerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.CalendarDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.CalendarSerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.DateDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.DateSerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.HexDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.HexSerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.QNameDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.QNameSerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SimpleDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SimpleSerializerFactory;

public abstract class TypeMappingImpl
implements TypeMapping {
    private static final ResourceBundle bundle = BundleUtils.getBundle(TypeMappingImpl.class);
    private static final Logger log = Logger.getLogger(TypeMappingImpl.class);
    private Map<KeyPair, FactoryPair> tupleMap = new LinkedHashMap<KeyPair, FactoryPair>();
    private Map<Integer, List<KeyPair>> keyPairCache = new ConcurrentHashMap<Integer, List<KeyPair>>();

    public DeserializerFactory getDeserializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(new IQName(xmlType), javaType);
        return fPair != null ? fPair.getDeserializerFactory() : null;
    }

    public SerializerFactory getSerializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(new IQName(xmlType), javaType);
        return fPair != null ? fPair.getSerializerFactory() : null;
    }

    public abstract String[] getSupportedEncodings();

    public abstract void setSupportedEncodings(String[] var1);

    public boolean isRegistered(Class javaType, QName xmlType) {
        return this.getFactoryPair(new IQName(xmlType), javaType) != null;
    }

    public void register(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("register: TypeMappingImpl@" + this.hashCode() + " [xmlType=" + xmlType + ",javaType=" + javaType.getName() + ",sf=" + sf + ",df=" + df + "]"));
        }
        this.registerInternal(javaType, new IQName(xmlType), sf, df);
        this.keyPairCache.clear();
    }

    private void registerInternal(Class javaType, IQName xmlType, SerializerFactory sf, DeserializerFactory df) {
        if (javaType == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"JAVATYPE_CANNOT_BE_NULL", (Object[])new Object[]{xmlType}));
        }
        if (xmlType == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLTYPE_CANNOT_BE_NULL", (Object[])new Object[]{javaType}));
        }
        KeyPair kPair = new KeyPair(xmlType, javaType);
        FactoryPair fPair = new FactoryPair(sf, df);
        this.tupleMap.put(kPair, fPair);
    }

    public void removeDeserializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(new IQName(xmlType), javaType);
        if (fPair != null) {
            fPair.setDeserializerFactory(null);
        }
    }

    public void removeSerializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(new IQName(xmlType), javaType);
        if (fPair != null) {
            fPair.setSerializerFactory(null);
        }
    }

    public List<QName> getRegisteredXmlTypes() {
        ArrayList<QName> types = new ArrayList<QName>();
        for (KeyPair keyPair : this.getKeyPairs(null, null)) {
            types.add(keyPair.getXmlType().toQName());
        }
        return types;
    }

    public List<Class> getRegisteredJavaTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (KeyPair keyPair : this.getKeyPairs(null, null)) {
            types.add(keyPair.getJavaType());
        }
        return types;
    }

    public Class getJavaType(QName xmlType) {
        Class javaType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(new IQName(xmlType), null);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            javaType = kPair.getJavaType();
        }
        return javaType;
    }

    public List<Class> getJavaTypes(QName xmlType) {
        List<KeyPair> keyPairList = this.getKeyPairs(new IQName(xmlType), null);
        ArrayList<Class> classes = new ArrayList<Class>(keyPairList.size());
        for (KeyPair current : keyPairList) {
            classes.add(current.getJavaType());
        }
        return classes;
    }

    public Class getJavaType(QName xmlType, boolean getPrimitive) {
        Class javaType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(new IQName(xmlType), null);
        int size = keyPairList.size();
        if (size == 2 && getPrimitive) {
            KeyPair kPair1 = keyPairList.get(0);
            Class javaType1 = kPair1.getJavaType();
            KeyPair kPair2 = keyPairList.get(1);
            Class javaType2 = kPair2.getJavaType();
            javaType = javaType2.isPrimitive() && !javaType1.isPrimitive() ? javaType2 : (javaType1.isPrimitive() && !javaType2.isPrimitive() ? javaType1 : javaType2);
        } else {
            return this.getJavaType(xmlType);
        }
        return javaType;
    }

    public String getJavaTypeName(QName xmlType) {
        Class javaType = this.getJavaType(xmlType);
        return javaType != null ? javaType.getName() : null;
    }

    public QName getXMLType(Class javaType) {
        QName xmlType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(null, javaType);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            xmlType = kPair.getXmlType().toQName();
        }
        return xmlType;
    }

    public List<QName> getXMLTypes(Class javaType) {
        ArrayList<QName> xmlTypes = new ArrayList<QName>();
        for (KeyPair kPair : this.getKeyPairs(null, javaType)) {
            xmlTypes.add(kPair.getXmlType().toQName());
        }
        return xmlTypes;
    }

    public QName getXMLType(Class javaType, boolean tryAssignable) {
        if (tryAssignable) {
            return this.getXMLType(javaType);
        }
        QName xmlType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(null, javaType, tryAssignable);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            xmlType = kPair.getXmlType().toQName();
        }
        return xmlType;
    }

    private List<KeyPair> getKeyPairs(IQName xmlType, Class javaType) {
        Integer cacheId = this.cacheIdFor(javaType, xmlType);
        List<KeyPair> keyPairList = this.keyPairCache.get(cacheId);
        if (null == keyPairList) {
            keyPairList = this.getKeyPairsInternal(xmlType, javaType);
            this.keyPairCache.put(cacheId, keyPairList);
        }
        return keyPairList;
    }

    private Integer cacheIdFor(Class javaType, IQName xmlType) {
        int result = 23;
        int nullHash = HashCodeUtil.hash((int)result, (Object)"null");
        result = javaType != null ? HashCodeUtil.hash((int)result, (Object)javaType.getName()) : HashCodeUtil.hash((int)result, (int)nullHash);
        result = xmlType != null ? HashCodeUtil.hash((int)result, (int)xmlType.hashCode()) : HashCodeUtil.hash((int)result, (int)nullHash);
        return result;
    }

    private List<KeyPair> getKeyPairsInternal(IQName xmlType, Class javaType) {
        ArrayList<KeyPair> keyPairList = new ArrayList<KeyPair>();
        if (xmlType != null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType()) || entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
            if (keyPairList.size() == 0) {
                for (KeyPair entry : this.tupleMap.keySet()) {
                    if (!xmlType.equals(entry.getXmlType()) || !JavaUtils.isAssignableFrom((Class)entry.getJavaType(), (Class)javaType)) continue;
                    keyPairList.add(entry);
                }
            }
        } else if (xmlType != null && javaType == null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType())) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType == null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
            if (keyPairList.size() == 0) {
                for (KeyPair entry : this.tupleMap.keySet()) {
                    if (!JavaUtils.isAssignableFrom((Class)entry.getJavaType(), (Class)javaType)) continue;
                    keyPairList.add(entry);
                }
            }
        } else if (xmlType == null && javaType == null) {
            keyPairList.addAll(this.tupleMap.keySet());
        }
        return keyPairList;
    }

    private List<KeyPair> getKeyPairs(IQName xmlType, Class javaType, boolean tryAssignable) {
        Integer cacheId = this.cacheIdFor(javaType, xmlType);
        List<KeyPair> keyPairList = this.keyPairCache.get(cacheId);
        if (null == keyPairList) {
            keyPairList = this.getKeyPairsInternal(xmlType, javaType, tryAssignable);
            this.keyPairCache.put(cacheId, keyPairList);
        }
        return keyPairList;
    }

    private List<KeyPair> getKeyPairsInternal(IQName xmlType, Class javaType, boolean tryAssignable) {
        if (tryAssignable) {
            return this.getKeyPairs(xmlType, javaType);
        }
        ArrayList<KeyPair> keyPairList = new ArrayList<KeyPair>();
        if (xmlType != null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType()) || entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType != null && javaType == null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType())) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType == null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType == null && javaType == null) {
            keyPairList.addAll(this.tupleMap.keySet());
        }
        return keyPairList;
    }

    private FactoryPair getFactoryPair(IQName xmlType, Class javaType) {
        FactoryPair fPair = null;
        List<KeyPair> keyPairList = this.getKeyPairs(xmlType, javaType);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            fPair = this.tupleMap.get(kPair);
        }
        return fPair;
    }

    protected void registerStandardLiteralTypes() {
        this.register(BigDecimal.class, Constants.TYPE_LITERAL_DECIMAL, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(BigInteger.class, Constants.TYPE_LITERAL_POSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(BigInteger.class, Constants.TYPE_LITERAL_NEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(BigInteger.class, Constants.TYPE_LITERAL_NONPOSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(BigInteger.class, Constants.TYPE_LITERAL_NONNEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(BigInteger.class, Constants.TYPE_LITERAL_UNSIGNEDLONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(BigInteger.class, Constants.TYPE_LITERAL_INTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Date.class, Constants.TYPE_LITERAL_DATETIME, new DateSerializerFactory(), new DateDeserializerFactory());
        this.register(Calendar.class, Constants.TYPE_LITERAL_DATE, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
        this.register(Calendar.class, Constants.TYPE_LITERAL_TIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
        this.register(Calendar.class, Constants.TYPE_LITERAL_DATETIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
        this.register(QName.class, Constants.TYPE_LITERAL_QNAME, new QNameSerializerFactory(), new QNameDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_ANYSIMPLETYPE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_DURATION, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_GDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_GMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_GMONTHDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_GYEAR, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_GYEARMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_ID, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_LANGUAGE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_NAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_NCNAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_NMTOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_NORMALIZEDSTRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_TOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String.class, Constants.TYPE_LITERAL_STRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(String[].class, Constants.TYPE_LITERAL_NMTOKENS, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(URI.class, Constants.TYPE_LITERAL_ANYURI, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Boolean.TYPE, Constants.TYPE_LITERAL_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Boolean.class, Constants.TYPE_LITERAL_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Byte.TYPE, Constants.TYPE_LITERAL_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Byte.class, Constants.TYPE_LITERAL_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Byte[].class, Constants.TYPE_LITERAL_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
        this.register(byte[].class, Constants.TYPE_LITERAL_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
        this.register(Byte[].class, Constants.TYPE_LITERAL_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
        this.register(byte[].class, Constants.TYPE_LITERAL_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
        this.register(Double.TYPE, Constants.TYPE_LITERAL_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Double.class, Constants.TYPE_LITERAL_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Float.TYPE, Constants.TYPE_LITERAL_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Float.class, Constants.TYPE_LITERAL_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Integer.TYPE, Constants.TYPE_LITERAL_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Integer.class, Constants.TYPE_LITERAL_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Integer.TYPE, Constants.TYPE_LITERAL_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Integer.class, Constants.TYPE_LITERAL_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Long.TYPE, Constants.TYPE_LITERAL_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Long.class, Constants.TYPE_LITERAL_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Long.TYPE, Constants.TYPE_LITERAL_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Long.class, Constants.TYPE_LITERAL_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Short.TYPE, Constants.TYPE_LITERAL_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Short.class, Constants.TYPE_LITERAL_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Short.TYPE, Constants.TYPE_LITERAL_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.register(Short.class, Constants.TYPE_LITERAL_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
    }

    private final class IQName {
        public String namespace;
        public String localPart;
        public String prefix;
        public int hash;

        public IQName(QName name) {
            this.namespace = name.getNamespaceURI() != null ? name.getNamespaceURI().intern() : "".intern();
            this.localPart = name.getLocalPart() != null ? name.getLocalPart().intern() : "".intern();
            this.prefix = name.getPrefix() != null ? name.getPrefix().intern() : "".intern();
            this.hash = name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof IQName)) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_COMPARE_IQNAME", (Object[])new Object[]{object}));
            }
            IQName iqn = (IQName)object;
            return iqn.namespace == this.namespace && iqn.localPart == this.localPart;
        }

        public QName toQName() {
            QName qname = null == this.namespace ? new QName(this.localPart) : (null == this.prefix ? new QName(this.namespace, this.localPart) : new QName(this.namespace, this.localPart, this.prefix));
            return qname;
        }

        public String toString() {
            String ns = "".equals(this.namespace) ? this.namespace : "{" + this.namespace + "}";
            return ns + this.localPart;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class FactoryPair {
        private SerializerFactory serializerFactory;
        private DeserializerFactory deserializerFactory;

        FactoryPair(SerializerFactory sf, DeserializerFactory df) {
            this.deserializerFactory = df;
            this.serializerFactory = sf;
        }

        public DeserializerFactory getDeserializerFactory() {
            return this.deserializerFactory;
        }

        public SerializerFactory getSerializerFactory() {
            return this.serializerFactory;
        }

        public void setDeserializerFactory(DeserializerFactory df) {
            this.deserializerFactory = df;
        }

        public void setSerializerFactory(SerializerFactory sf) {
            this.serializerFactory = sf;
        }
    }

    private static class KeyPair {
        private IQName xmlType;
        private Class javaType;

        public KeyPair(IQName xmlType, Class javaType) {
            this.javaType = javaType;
            this.xmlType = xmlType;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public IQName getXmlType() {
            return this.xmlType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyPair)) {
                return false;
            }
            KeyPair keyPair = (KeyPair)o;
            if (!this.javaType.equals(keyPair.javaType)) {
                return false;
            }
            return this.xmlType.equals(keyPair.xmlType);
        }

        public int hashCode() {
            int result = this.xmlType.hashCode();
            result = 29 * result + this.javaType.hashCode();
            return result;
        }

        public String toString() {
            return "[xmlType=" + this.xmlType + ",javaType=" + this.javaType.getName() + "]";
        }
    }
}

