/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding.jbossxb;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBMarshaller;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBSupport;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.MarshalException;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.SecurityActions;
import org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.xb.binding.sunday.marshalling.MarshallerImpl;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JBossXBMarshallerImpl
implements JBossXBMarshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JBossXBMarshallerImpl.class);
    private static final Logger log = Logger.getLogger(JBossXBMarshallerImpl.class);
    private HashMap properties = new HashMap();
    private MarshallerImpl delegate = new MarshallerImpl();

    public JBossXBMarshallerImpl() {
        this.delegate.setProperty("org.jboss.xml.binding.marshalling.version", "false");
        this.delegate.setProperty("org.jboss.xml.binding.marshalling.indent", "false");
        this.delegate.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.delegate.setSupportNil(true);
    }

    @Override
    public void marshal(Object obj, Writer writer) throws MarshalException {
        this.assertRequiredProperties();
        try {
            JavaXmlTypeMapping[] javaXmlMappings;
            JavaWsdlMapping wsdlMapping;
            boolean isAnonymousType;
            QName xmlName = (QName)this.getProperty("org.jboss.xb.root.qname");
            this.delegate.addRootElement(xmlName);
            QName xmlType = (QName)this.getProperty("org.jboss.xb.type.qname");
            boolean bl = isAnonymousType = xmlType != null && xmlType.getLocalPart().startsWith(">");
            if (xmlType != null && !isAnonymousType) {
                this.delegate.setRootTypeQName(xmlType);
            }
            if (xmlName.getNamespaceURI().length() > 0) {
                String prefix = xmlName.getPrefix();
                String nsURI = xmlName.getNamespaceURI();
                this.delegate.declareNamespace(prefix, nsURI);
            }
            if ((wsdlMapping = (JavaWsdlMapping)this.getProperty("org.jboss.xb.java.mapping")) != null && (javaXmlMappings = wsdlMapping.getJavaXmlTypeMappings()) != null) {
                for (int i = 0; i < javaXmlMappings.length; ++i) {
                    JavaXmlTypeMapping javaXmlMapping = javaXmlMappings[i];
                    VariableMapping[] variableMappings = javaXmlMapping.getVariableMappings();
                    if (variableMappings == null) continue;
                    String clsName = javaXmlMapping.getJavaType();
                    Class cls = JavaUtils.loadJavaType((String)clsName, (ClassLoader)SecurityActions.getContextClassLoader());
                    QName clsQName = javaXmlMapping.getRootTypeQName();
                    if (clsQName != null && "complexType".equalsIgnoreCase(javaXmlMapping.getQnameScope())) {
                        this.delegate.mapClassToXsiType(cls, clsQName.getNamespaceURI(), clsQName.getLocalPart());
                    }
                    for (int j = 0; j < variableMappings.length; ++j) {
                        VariableMapping variableMapping = variableMappings[j];
                        if (!variableMapping.getXmlWildcard()) continue;
                        this.delegate.mapFieldToWildcard(cls, "_any", JBossXBSupport.getWildcardMarshaller());
                    }
                }
            }
            SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
            schemaBinding.setXopMarshaller((XOPMarshaller)new XOPMarshallerImpl());
            this.delegate.marshal(schemaBinding, null, obj, writer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    @Override
    public void marshal(Object obj, ContentHandler handler) {
        throw new NotImplementedException();
    }

    @Override
    public void marshal(Object obj, Node node) {
        throw new NotImplementedException();
    }

    @Override
    public void marshal(Object obj, OutputStream os) throws MarshalException {
        this.marshal(obj, new OutputStreamWriter(os));
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NAME_PARAMETER_IS_NULL", (Object[])new Object[0]));
        }
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NAME_PARAMETER_IS_NULL", (Object[])new Object[0]));
        }
        this.properties.put(name, value);
    }

    public Node getNode(Object contentTree) {
        throw new NotImplementedException();
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.xb.xsd.reader") == null && this.getProperty("org.jboss.xb.xsd.xsmodel") == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_REQUIRED_PROPERTY", (Object[])new Object[]{"org.jboss.xb.xsd.xsmodel"}));
        }
        if (this.getProperty("org.jboss.xb.java.mapping") == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_REQUIRED_PROPERTY", (Object[])new Object[]{"org.jboss.xb.java.mapping"}));
        }
        QName xmlName = (QName)this.getProperty("org.jboss.xb.root.qname");
        if (xmlName == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_REQUIRED_PROPERTY", (Object[])new Object[]{"org.jboss.xb.root.qname"}));
        }
        if (xmlName.getNamespaceURI().length() > 0 && xmlName.getPrefix().length() == 0) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MUST_BE_PREFIX_QUALIFIED", (Object[])new Object[]{xmlName}));
        }
    }
}

