/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.lang.reflect.Method;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.api.binding.JAXBBindingCustomization;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.ComplexTypeDeserializer;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxws.JAXBContextCache;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.xop.jaxws.AttachmentUnmarshallerImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class JAXBDeserializer
extends ComplexTypeDeserializer {
    private static final Logger log = Logger.getLogger(JAXBDeserializer.class);

    @Override
    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        Object value = null;
        try {
            Class[] javaTypes = (Class[])serContext.getProperty("org.jboss.ws.jaxb.context.types");
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            Class javaType = typeMapping.getJavaType(xmlType);
            JAXBContext jaxbContext = this.getJAXBContext(javaTypes);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl());
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    int severity = event.getSeverity();
                    return severity != 2 && severity != 1;
                }
            });
            JAXBElement jbe = unmarshaller.unmarshal(xmlFragment, javaType);
            value = jbe.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("deserialized: " + (value != null ? value.getClass().getName() : null)));
            }
        }
        catch (Exception ex) {
            this.handleUnmarshallException(ex);
        }
        return value;
    }

    private JAXBContext getJAXBContext(Class[] types) {
        JAXBContextCache cache = JAXBContextCache.getContextCache();
        JAXBContext context = cache.get(types);
        if (null == context) {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
            String defaultNS = epMetaData.getPortTypeName().getNamespaceURI();
            BindingCustomization bindingCustomization = this.getBindingCustomization();
            for (Class clz : types) {
                if (!clz.getName().endsWith("ObjectFactory")) continue;
                for (Method meth : clz.getMethods()) {
                    XmlElementDecl elementDecl = meth.getAnnotation(XmlElementDecl.class);
                    if (elementDecl == null || !XmlElementDecl.GLOBAL.class.equals((Object)elementDecl.scope()) || elementDecl.namespace() == null || elementDecl.namespace().length() <= 0) continue;
                    defaultNS = null;
                }
            }
            if (defaultNS != null) {
                if (bindingCustomization == null) {
                    bindingCustomization = new JAXBBindingCustomization();
                }
                bindingCustomization.put((Object)"com.sun.xml.bind.defaultNamespaceRemap", (Object)defaultNS);
            }
            context = JAXBContextFactory.newInstance().createContext(types, bindingCustomization);
            cache.add(types, context);
        }
        return context;
    }

    private void handleUnmarshallException(Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)((Object)ex);
        }
        throw new WebServiceException((Throwable)ex);
    }
}

