/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.json.BadgerFishDOMDocumentSerializer;
import org.w3c.dom.Element;

public class JsonMessageMarshaller
implements Marshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JsonMessageMarshaller.class);

    @Override
    public void write(Object dataObject, OutputStream output) throws IOException {
        if (!(dataObject instanceof SOAPMessageImpl)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_A_SOAPMESSAGEIMPL", (Object[])new Object[]{dataObject}));
        }
        try {
            SOAPMessage soapMessage = (SOAPMessage)dataObject;
            SOAPBodyImpl soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
            SOAPBodyElement payload = soapBody.getBodyElement();
            new BadgerFishDOMDocumentSerializer(output).serialize((Element)payload);
        }
        catch (SOAPException ex) {
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SERIALIZE", (Object[])new Object[]{dataObject}));
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

