/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxws.SerializationContextJAXWS;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.xb.binding.NamespaceRegistry;

public abstract class MessageContextJAXWS
extends CommonMessageContext
implements MessageContext {
    private static final ResourceBundle bundle = BundleUtils.getBundle(MessageContextJAXWS.class);
    private static Logger log = Logger.getLogger(MessageContextJAXWS.class);

    public MessageContextJAXWS() {
    }

    public MessageContextJAXWS(CommonMessageContext msgContext) {
        super(msgContext);
    }

    @Override
    public SerializationContext createSerializationContext() {
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        SerializationContextJAXWS jaxwsContext = new SerializationContextJAXWS();
        jaxwsContext.setTypeMapping(serviceMetaData.getTypeMapping());
        return jaxwsContext;
    }

    @Override
    public NamespaceRegistry getNamespaceRegistry() {
        return this.getSerializationContext().getNamespaceRegistry();
    }

    public void setScope(String key, MessageContext.Scope scope) {
        CommonMessageContext.ScopedProperty prop = (CommonMessageContext.ScopedProperty)this.scopedProps.get(key);
        if (prop == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_SCOPED_PROPERTY", (Object[])new Object[]{key}));
        }
        this.scopedProps.put(key, new CommonMessageContext.ScopedProperty(key, prop.getValue(), scope));
    }

    public MessageContext.Scope getScope(String key) {
        CommonMessageContext.ScopedProperty prop = (CommonMessageContext.ScopedProperty)this.scopedProps.get(key);
        if (prop == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_SCOPED_PROPERTY", (Object[])new Object[]{key}));
        }
        return prop.getScope();
    }

    public static MessageContextJAXWS processPivot(CommonMessageContext reqContext) {
        log.debug((Object)"Begin response processing");
        Boolean outbound = (Boolean)reqContext.get("javax.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_PROPERTY", (Object[])new Object[]{"javax.xml.ws.handler.message.outbound"}));
        }
        MessageContextAssociation.popMessageContext(false);
        SOAPMessageContextJAXWS resContext = new SOAPMessageContextJAXWS(reqContext);
        resContext.setSOAPMessage(null);
        resContext.put("javax.xml.ws.handler.message.outbound", (Object)(outbound == false ? 1 : 0));
        MessageContextAssociation.pushMessageContext(resContext);
        return resContext;
    }

    @Override
    public void setOperationMetaData(OperationMetaData opMetaData) {
        super.setOperationMetaData(opMetaData);
        if (opMetaData != null) {
            EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
            ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
            URL wsdlURL = serviceMetaData.getWsdlFileOrLocation();
            if (wsdlURL != null) {
                try {
                    this.put("javax.xml.ws.wsdl.description", (Object)wsdlURL.toURI());
                }
                catch (URISyntaxException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Cannot convert the WSDL URL to a URI", (Throwable)e);
                    }
                    log.debug((Object)"Cannot convert the WSDL URL to a URI");
                }
            }
            this.put("javax.xml.ws.wsdl.service", (Object)serviceMetaData.getServiceName());
            this.put("javax.xml.ws.wsdl.port", (Object)epMetaData.getPortName());
            this.put("javax.xml.ws.wsdl.interface", (Object)epMetaData.getPortTypeName());
            this.put("javax.xml.ws.wsdl.operation", (Object)opMetaData.getQName());
        }
    }
}

