/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.attachment.CIDGenerator;

public abstract class MultipartRelatedEncoder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(MultipartRelatedEncoder.class);
    protected SOAPMessageImpl soapMessage;
    protected MimeMultipart multipart;

    public MultipartRelatedEncoder(SOAPMessageImpl soapMessage) throws SOAPException {
        this.soapMessage = soapMessage;
    }

    public abstract void encodeMultipartRelatedMessage() throws SOAPException, MessagingException;

    protected void addAttachmentParts(MimeMultipart multipart) throws SOAPException, MessagingException {
        Iterator attachmentParts = this.soapMessage.getAttachments();
        while (attachmentParts.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)attachmentParts.next();
            DataHandler handler = attachmentPart.getDataHandler();
            MimeBodyPart mimePart = new MimeBodyPart();
            mimePart.setDataHandler(handler);
            Iterator mimeHeaders = attachmentPart.getAllMimeHeaders();
            while (mimeHeaders.hasNext()) {
                MimeHeader soapHeader = (MimeHeader)mimeHeaders.next();
                mimePart.addHeader(soapHeader.getName(), soapHeader.getValue());
            }
            if (mimePart.getHeader("Content-Type") == null) {
                String type = handler.getContentType();
                mimePart.setHeader("Content-Type", type != null ? type : "application/octet-stream");
            }
            if (mimePart.getHeader("Content-Id") == null) {
                CIDGenerator cidGenerator = this.soapMessage.getCidGenerator();
                mimePart.setHeader("Content-Id", cidGenerator.generateFromCount());
            }
            mimePart.setHeader("Content-Transfer-Encoding", "binary");
            multipart.addBodyPart((BodyPart)mimePart);
        }
    }

    public String getContentType() {
        String contentType = this.multipart.getContentType();
        return contentType;
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.multipart == null) {
            throw new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NO_DATA_TO_WRITE", (Object[])new Object[0]));
        }
        try {
            os.write(13);
            os.write(10);
            this.multipart.writeTo(os);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }
}

