/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.Metadata;
import javax.xml.ws.addressing.ReferenceParameters;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.AttributeElementExtensibleImpl;
import org.jboss.ws.extensions.addressing.AttributedURIImpl;
import org.jboss.ws.extensions.addressing.MetadataImpl;
import org.jboss.ws.extensions.addressing.ReferenceParametersImpl;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointReferenceImpl
extends AttributeElementExtensibleImpl
implements EndpointReference {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointReferenceImpl.class);
    private static AddressingConstants ADDR = new AddressingConstantsImpl();
    private QName rootQName = new QName(ADDR.getNamespaceURI(), "EndpointReference", ADDR.getNamespacePrefix());
    private AttributedURIImpl address = new AttributedURIImpl(ADDR.getAnonymousURI());
    private ReferenceParametersImpl refParams = new ReferenceParametersImpl();
    private MetadataImpl metadata = new MetadataImpl();

    public EndpointReferenceImpl(URI uri) {
        this.address = new AttributedURIImpl(uri);
    }

    public EndpointReferenceImpl(Element elRoot) {
        this.initFromElement(elRoot);
    }

    public QName getRootQName() {
        return this.rootQName;
    }

    public void setRootQName(QName rootElementName) {
        this.rootQName = rootElementName;
    }

    @Override
    public AttributedURI getAddress() {
        return this.address;
    }

    @Override
    public ReferenceParameters getReferenceParameters() {
        return this.refParams;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    private void initFromElement(Element elRoot) {
        if (elRoot == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_INITIALIZE_FROM_NULL_ELEMENT", (Object[])new Object[0]));
        }
        try {
            Map attributes = DOMUtils.getAttributes((Element)elRoot);
            for (QName attqname : attributes.keySet()) {
                String value = (String)attributes.get(attqname);
                this.addAttribute(attqname, value);
            }
            Iterator it = DOMUtils.getChildElements((Node)elRoot);
            while (it.hasNext()) {
                Element child;
                Iterator itel;
                String value;
                Element el = (Element)it.next();
                QName qname = DOMUtils.getElementQName((Element)el);
                if (qname.equals(ADDR.getAddressQName())) {
                    this.address = new AttributedURIImpl(DOMUtils.getTextContent((Node)el));
                    attributes = DOMUtils.getAttributes((Element)el);
                    for (QName attqname : attributes.keySet()) {
                        value = (String)attributes.get(attqname);
                        this.address.addAttribute(attqname, value);
                    }
                    continue;
                }
                if (qname.equals(ADDR.getReferenceParametersQName())) {
                    attributes = DOMUtils.getAttributes((Element)el);
                    for (QName attqname : attributes.keySet()) {
                        value = (String)attributes.get(attqname);
                        this.refParams.addAttribute(attqname, value);
                    }
                    itel = DOMUtils.getChildElements((Node)el);
                    while (itel.hasNext()) {
                        child = (Element)itel.next();
                        this.refParams.addElement(child);
                    }
                    continue;
                }
                if (qname.equals(ADDR.getMetadataQName())) {
                    attributes = DOMUtils.getAttributes((Element)el);
                    for (QName attqname : attributes.keySet()) {
                        value = (String)attributes.get(attqname);
                        this.metadata.addAttribute(attqname, value);
                    }
                    itel = DOMUtils.getChildElements((Node)el);
                    while (itel.hasNext()) {
                        child = (Element)itel.next();
                        this.metadata.addElement(child);
                    }
                    continue;
                }
                this.addElement(el);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new AddressingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_INIT_EPR_FROM_ELEMENT", (Object[])new Object[0]), ex);
        }
    }

    public Element toElement() {
        String xmlString = this.toXMLString(false);
        try {
            return DOMUtils.parse((String)xmlString);
        }
        catch (IOException ex) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE", (Object[])new Object[]{xmlString}), ex);
        }
    }

    public String toXMLString(boolean pretty) {
        if (pretty) {
            Element epRef = this.toElement();
            return DOMWriter.printNode((Node)epRef, (boolean)true);
        }
        SOAPAddressingBuilderImpl builder = new SOAPAddressingBuilderImpl();
        AddressingConstants ADDR = ((AddressingBuilder)builder).newAddressingConstants();
        String rootname = this.getPrefixedName(this.rootQName);
        StringBuilder xmlBuffer = new StringBuilder("<" + rootname);
        this.appendAttributes(xmlBuffer, this.getAttributes());
        xmlBuffer.append(">");
        String wsaURI = ADDR.getNamespaceURI();
        String wsaPrefix = ADDR.getNamespacePrefix();
        String wsaDeclaration = " xmlns:" + wsaPrefix + "='" + wsaURI + "'";
        if (xmlBuffer.indexOf(wsaDeclaration) < 0) {
            xmlBuffer.insert(rootname.length() + 1, wsaDeclaration);
        }
        xmlBuffer.append("<" + this.getPrefixedName(ADDR.getAddressQName()));
        this.appendAttributes(xmlBuffer, this.address.getAttributes());
        xmlBuffer.append(">");
        xmlBuffer.append(this.address.getURI() + "</" + this.getPrefixedName(ADDR.getAddressQName()) + ">");
        if (this.refParams.getElements().size() > 0 || this.refParams.getAttributes().size() > 0) {
            xmlBuffer.append("<" + this.getPrefixedName(ADDR.getReferenceParametersQName()));
            this.appendAttributes(xmlBuffer, this.refParams.getAttributes());
            xmlBuffer.append(">");
            this.appendElements(xmlBuffer, this.refParams.getElements());
            xmlBuffer.append("</" + this.getPrefixedName(ADDR.getReferenceParametersQName()) + ">");
        }
        if (this.metadata.getElements().size() > 0 || this.metadata.getAttributes().size() > 0) {
            xmlBuffer.append("<" + this.getPrefixedName(ADDR.getMetadataQName()));
            this.appendAttributes(xmlBuffer, this.metadata.getAttributes());
            xmlBuffer.append(">");
            this.appendElements(xmlBuffer, this.metadata.getElements());
            xmlBuffer.append("</" + this.getPrefixedName(ADDR.getMetadataQName()) + ">");
        }
        this.appendElements(xmlBuffer, this.getElements());
        xmlBuffer.append("</" + rootname + ">");
        String xmlString = xmlBuffer.toString();
        return xmlString;
    }

    private void appendAttributes(StringBuilder xmlBuffer, Map<QName, String> attributes) {
        for (QName qname : attributes.keySet()) {
            String qualname = this.getPrefixedName(qname);
            String value = attributes.get(qname);
            xmlBuffer.append(" " + qualname + "='" + value + "'");
        }
    }

    private void appendElements(StringBuilder xmlBuffer, List<Object> elements) {
        for (Object obj : elements) {
            if (obj instanceof Element) {
                StringWriter strwr = new StringWriter();
                DOMWriter domWriter = new DOMWriter((Writer)strwr).setCompleteNamespaces(false);
                domWriter.print((Node)((Element)obj));
                String xmlFragment = strwr.toString();
                xmlBuffer.append(xmlFragment);
                continue;
            }
            if (obj instanceof String) {
                xmlBuffer.append(obj);
                continue;
            }
            throw new AddressingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_ELEMENT", (Object[])new Object[]{obj.getClass().getName()}));
        }
    }

    private String getPrefixedName(QName qname) {
        String prefix = qname.getPrefix();
        String localPart = qname.getLocalPart();
        String qualname = prefix != null && prefix.length() > 0 ? prefix + ":" + localPart : localPart;
        return qualname;
    }

    public String toString() {
        return this.toXMLString(true);
    }
}

