/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.BindingType;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.jboss.ws.WSException;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.core.jaxws.client.serviceref.NativeServiceObjectFactoryJAXWS;
import org.jboss.ws.core.jaxws.wsaddressing.NativeEndpointReference;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.w3c.dom.Element;

public class JAXWSClientMetaDataBuilder
extends JAXWSMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSClientMetaDataBuilder.class);

    public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL, UnifiedVirtualFile vfsRoot) {
        return this.buildMetaData(serviceName, wsdlURL, vfsRoot, null);
    }

    public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL, UnifiedVirtualFile vfsRoot, ClassLoader classLoader) {
        if (wsdlURL == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_WSDLURL", (Object[])new Object[]{wsdlURL}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("START buildMetaData: [service=" + serviceName + "]"));
        }
        try {
            UnifiedMetaData wsMetaData = classLoader != null ? new UnifiedMetaData(vfsRoot, classLoader) : new UnifiedMetaData(vfsRoot);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
            wsMetaData.addService(serviceMetaData);
            serviceMetaData.setWsdlLocation(wsdlURL);
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            this.buildMetaDataInternal(serviceMetaData, wsdlDefinitions);
            for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getClientSidePolicyMetaDataBuilder();
                policyBuilder.processPolicyExtensions(epMetaData, wsdlDefinitions);
                this.processEPRs(epMetaData, wsdlDefinitions);
            }
            JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
            serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return serviceMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_BUILD_META_DATA", (Object[])new Object[]{ex.getMessage()}), ex);
        }
    }

    private void processEPRs(EndpointMetaData endpointMD, WSDLDefinitions wsdlDefinitions) {
        List<WSDLExtensibilityElement> portEPRs;
        WSDLEndpoint wsdlEndpoint;
        WSDLService wsdlService = wsdlDefinitions.getService(endpointMD.getServiceMetaData().getServiceName());
        if (wsdlService != null && (wsdlEndpoint = wsdlService.getEndpoint(endpointMD.getPortName())) != null && (portEPRs = wsdlEndpoint.getExtensibilityElements("http://www.jboss.org/jbossws/epr")) != null && portEPRs.size() != 0) {
            if (portEPRs.size() > 1) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONLY_ONE_EPR_ALLOWED", (Object[])new Object[0]));
            }
            Element eprElement = portEPRs.get(0).getElement();
            DOMSource eprInfoset = new DOMSource(eprElement);
            NativeEndpointReference nativeEPR = (NativeEndpointReference)NativeEndpointReference.readFrom(eprInfoset);
            nativeEPR.setAddress(endpointMD.getEndpointAddress());
            endpointMD.setEndpointReference(nativeEPR);
        }
    }

    public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL) {
        return this.buildMetaData(serviceName, wsdlURL, (UnifiedVirtualFile)new ResourceLoaderAdapter());
    }

    private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions) throws IOException {
        QName serviceName = serviceMetaData.getServiceName();
        WSDLService wsdlService = null;
        if (serviceName == null) {
            if (wsdlDefinitions.getServices().length != 1) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXPECTED_A_SINGLE_SERVICE_ELEMENT", (Object[])new Object[0]));
            }
            wsdlService = wsdlDefinitions.getServices()[0];
            serviceMetaData.setServiceName(wsdlService.getName());
        } else {
            wsdlService = wsdlDefinitions.getService(serviceName);
        }
        if (wsdlService == null) {
            ArrayList<QName> serviceNames = new ArrayList<QName>();
            for (WSDLService wsdls : wsdlDefinitions.getServices()) {
                serviceNames.add(wsdls.getName());
            }
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_WSDL_SERVICE", (Object[])new Object[]{serviceName, serviceNames}));
        }
        for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
            QName bindingName = wsdlEndpoint.getBinding();
            WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
            String bindingType = wsdlBinding.getType();
            if (!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) continue;
            QName portName = wsdlEndpoint.getName();
            QName interfaceQName = wsdlEndpoint.getInterface().getName();
            ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, portName, interfaceQName, EndpointMetaData.Type.JAXWS);
            epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
            serviceMetaData.addEndpoint(epMetaData);
            this.initEndpointBinding(wsdlBinding, (EndpointMetaData)epMetaData);
            this.initEndpointEncodingStyle(epMetaData);
            this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint);
            this.bufferServiceRefContributions(epMetaData);
        }
    }

    private void bufferServiceRefContributions(EndpointMetaData epMetaData) {
        UnifiedServiceRefMetaData serviceRefMetaData = NativeServiceObjectFactoryJAXWS.getServiceRefAssociation();
        if (serviceRefMetaData != null) {
            for (UnifiedPortComponentRefMetaData portComp : serviceRefMetaData.getPortComponentRefs()) {
                epMetaData.getServiceRefContrib().add(portComp);
            }
        }
    }

    private void processServiceRefContributions(EndpointMetaData epMetaData) {
        for (UnifiedPortComponentRefMetaData portComp : epMetaData.getServiceRefContrib()) {
            if (!epMetaData.matches(portComp)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing service-ref contribution on portType: " + epMetaData.getPortTypeName()));
            }
            if (portComp.isMtomEnabled()) {
                epMetaData.addFeature((WebServiceFeature)new MTOMFeature(true, portComp.getMtomThreshold()));
            }
            if (portComp.isAddressingEnabled()) {
                AddressingFeature.Responses response = this.getAddressFeatureResponses(portComp.getAddressingResponses());
                epMetaData.addFeature((WebServiceFeature)new AddressingFeature(true, portComp.isAddressingRequired(), response));
            }
            if (portComp.isRespectBindingEnabled()) {
                epMetaData.addFeature((WebServiceFeature)new RespectBindingFeature(true));
            }
            for (UnifiedStubPropertyMetaData stubProp : portComp.getStubProperties()) {
                epMetaData.getProperties().put(stubProp.getPropName(), stubProp.getPropValue());
            }
            for (UnifiedCallPropertyMetaData callProp : portComp.getCallProperties()) {
                epMetaData.getProperties().put(callProp.getPropName(), callProp.getPropValue());
            }
        }
    }

    public void rebuildEndpointMetaData(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"START: rebuildMetaData");
        }
        this.resetMetaDataBuilder(epMetaData.getClassLoader());
        epMetaData.setParameterStyle(null);
        if (wsClass.isAnnotationPresent(BindingType.class)) {
            this.processBindingType(epMetaData, wsClass);
        }
        if (wsClass.isAnnotationPresent(SOAPBinding.class)) {
            this.processSOAPBinding(epMetaData, wsClass);
        }
        this.processEndpointConfig(epMetaData, wsClass);
        epMetaData.initEndpointConfig();
        this.processWebMethods(epMetaData, wsClass);
        this.processXmlSeeAlso(wsClass);
        this.createJAXBContext(epMetaData);
        this.populateXmlTypes(epMetaData);
        epMetaData.setServiceEndpointInterfaceName(wsClass.getName());
        this.processServiceRefContributions(epMetaData);
        epMetaData.eagerInitialize();
        if (log.isDebugEnabled()) {
            log.debug((Object)("END: rebuildMetaData\n" + epMetaData.getServiceMetaData()));
        }
    }

    private void processEndpointConfig(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (wsClass.isAnnotationPresent(EndpointConfig.class)) {
            EndpointConfig anConfig = wsClass.getAnnotation(EndpointConfig.class);
            epMetaData.setConfigName(anConfig.configName(), anConfig.configFile());
        }
    }
}

