/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.metadata.builder.MetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class JAXWSProviderMetaDataBuilder
extends JAXWSServerMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSProviderMetaDataBuilder.class);

    public ServerEndpointMetaData buildProviderMetaData(ArchiveDeployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName) throws IOException {
        String portName;
        String targetNS;
        if (!JavaUtils.isAssignableFrom(Provider.class, sepClass)) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_IMPLEMENT_PROVIDER", (Object[])new Object[]{sepClass.getName()}));
        }
        WebServiceProvider anWebServiceProvider = sepClass.getAnnotation(WebServiceProvider.class);
        if (anWebServiceProvider == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_PROVIDER", (Object[])new Object[]{sepClass.getName()}));
        }
        if (sepClass.isAnnotationPresent(WebService.class)) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CARRY_WEBSERVICE_ANNOTATION", (Object[])new Object[]{sepClass.getName()}));
        }
        WSDLUtils wsdlUtils = WSDLUtils.getInstance();
        String name = WSDLUtils.getJustClassName(sepClass);
        String serviceName = anWebServiceProvider.serviceName();
        if (serviceName.length() == 0) {
            serviceName = name + "Service";
        }
        if ((targetNS = anWebServiceProvider.targetNamespace()).length() == 0) {
            targetNS = WSDLUtils.getTypeNamespace(sepClass);
        }
        if ((portName = anWebServiceProvider.portName()).length() == 0) {
            portName = name + "Port";
        }
        ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName(targetNS, serviceName));
        wsMetaData.addService(serviceMetaData);
        QName portQName = new QName(targetNS, portName);
        QName portTypeQName = new QName(targetNS, name);
        Endpoint ep = dep.getService().getEndpointByName(linkName);
        ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, ep, portQName, portTypeQName, EndpointMetaData.Type.JAXWS);
        sepMetaData.setLinkName(linkName);
        sepMetaData.setStyle(Style.DOCUMENT);
        sepMetaData.setParameterStyle(SOAPBinding.ParameterStyle.BARE);
        sepMetaData.setServiceEndpointImplName(sepClass.getName());
        sepMetaData.setServiceEndpointInterfaceName(sepClass.getName());
        ServiceMode anServiceMode = sepClass.getAnnotation(ServiceMode.class);
        sepMetaData.setServiceMode(anServiceMode != null ? anServiceMode.value() : Service.Mode.PAYLOAD);
        serviceMetaData.addEndpoint(sepMetaData);
        this.processInvokeMethod(sepMetaData);
        String wsdlLocation = anWebServiceProvider.wsdlLocation();
        if (wsdlLocation.length() > 0) {
            URL wsdlURL = dep.getResourceResolver().resolve(wsdlLocation);
            serviceMetaData.setWsdlLocation(wsdlURL);
        }
        this.processBindingType(sepMetaData, sepClass);
        this.processHandlerChain(sepMetaData, sepClass);
        this.processWSDDContribution((Deployment)dep, sepMetaData);
        this.processEndpointConfig((Deployment)dep, sepMetaData, sepClass, linkName);
        this.processWebContext((Deployment)dep, sepClass, linkName, sepMetaData);
        this.initEndpointAddress((Deployment)dep, sepMetaData);
        if (sepMetaData.getServiceMetaData().getWsdlLocation() != null) {
            MetaDataBuilder.replaceAddressLocation(sepMetaData);
        }
        ObjectName sepID = MetaDataBuilder.createServiceEndpointID((Deployment)dep, sepMetaData);
        sepMetaData.setServiceEndpointID(sepID);
        return sepMetaData;
    }

    private void processInvokeMethod(ServerEndpointMetaData epMetaData) {
        String javaName = "invoke";
        String targetNS = epMetaData.getPortName().getNamespaceURI();
        OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, javaName), javaName);
        epMetaData.addOperation(opMetaData);
        Class<Source> paramType = Source.class;
        QName xmlName = SOAPContentElement.GENERIC_PARAM_NAME;
        QName xmlType = Constants.TYPE_LITERAL_ANYTYPE;
        ParameterMetaData pmd = new ParameterMetaData(opMetaData, xmlName, xmlType, paramType.getName());
        opMetaData.addParameter(pmd);
        xmlName = SOAPContentElement.GENERIC_RETURN_NAME;
        ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, paramType.getName());
        opMetaData.setReturnParameter(retMetaData);
    }
}

