/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.Use;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.w3c.dom.Element;

public class OperationMetaData
extends ExtensibleMetaData
implements InitalizableMetaData {
    private static final ResourceBundle bundle = BundleUtils.getBundle(OperationMetaData.class);
    private final Logger log = Logger.getLogger(OperationMetaData.class);
    private EndpointMetaData epMetaData;
    private QName qname;
    private QName responseName;
    private String javaName;
    private Method javaMethod;
    private boolean oneWay;
    private String soapAction;
    private SOAPBinding.ParameterStyle parameterStyle;
    private List<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
    private List<FaultMetaData> faults = new ArrayList<FaultMetaData>();
    private ParameterMetaData returnParam;
    private String documentation;

    public OperationMetaData(EndpointMetaData epMetaData, QName qname, String javaName) {
        this.log.trace((Object)("new OperationMetaData: [xmlName=" + qname + ",javaName=" + javaName + "]"));
        this.initOperationMetaData(epMetaData, qname, javaName);
    }

    private void initOperationMetaData(EndpointMetaData epMetaData, QName qname, String javaName) {
        this.epMetaData = epMetaData;
        this.qname = qname;
        this.javaName = javaName;
        if (qname == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NULL_QNAME_ARGUMENT", (Object[])new Object[0]));
        }
        if (javaName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NULL_JAVANAME_ARGUMENT", (Object[])new Object[]{qname}));
        }
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        this.responseName = new QName(nsURI, localPart + "Response");
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.epMetaData;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getResponseName() {
        return this.responseName;
    }

    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSOAPAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public Style getStyle() {
        return this.epMetaData.getStyle();
    }

    public Use getUse() {
        return this.epMetaData.getEncodingStyle();
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        return this.parameterStyle != null ? this.parameterStyle : this.epMetaData.getParameterStyle();
    }

    public void setParameterStyle(SOAPBinding.ParameterStyle parameterStyle) {
        this.parameterStyle = parameterStyle;
    }

    public boolean isRPCLiteral() {
        return this.getStyle() == Style.RPC && this.getUse() == Use.LITERAL;
    }

    public boolean isRPCEncoded() {
        return this.getStyle() == Style.RPC && this.getUse() == Use.ENCODED;
    }

    public boolean isDocumentBare() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    public boolean isDocumentWrapped() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Method getJavaMethod() {
        Method tmpMethod = this.javaMethod;
        Class seiClass = this.epMetaData.getServiceEndpointInterface();
        if (tmpMethod == null && seiClass != null) {
            for (Method method : seiClass.getMethods()) {
                if (!this.isJavaMethod(method)) continue;
                tmpMethod = method;
                UnifiedMetaData wsMetaData = this.epMetaData.getServiceMetaData().getUnifiedMetaData();
                if (!wsMetaData.isEagerInitialized()) break;
                if (!UnifiedMetaData.isFinalRelease()) {
                    this.log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"LOADING_JAVA_METHOD", (Object[])new Object[0]), (Throwable)new IllegalStateException());
                }
                this.javaMethod = method;
                break;
            }
            if (tmpMethod == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_JAVA_METHOD", (Object[])new Object[]{this.javaName}));
            }
        }
        return tmpMethod;
    }

    public boolean isJavaMethod(Method method) {
        String methodName;
        boolean isJavaMethod = method.equals(this.javaMethod);
        if (!isJavaMethod && this.javaName.equals(methodName = method.getName())) {
            this.log.trace((Object)("Found java method: " + method));
            if (this.matchParameters(method, true)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found best matching java method: " + method));
                }
                isJavaMethod = true;
            }
            if (!isJavaMethod && this.matchParameters(method, false)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found possible matching java method: " + method));
                }
                isJavaMethod = true;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Synchronized java method:\n" + method + "\nwith: " + this.toString()));
        }
        return isJavaMethod;
    }

    private boolean matchParameters(Method method, boolean exact) {
        Class<?>[] paramTypes = method.getParameterTypes();
        HashSet<Integer> matches = new HashSet<Integer>(paramTypes.length);
        for (ParameterMetaData param : this.getParameters()) {
            if (param.matchParameter(method, matches, exact)) continue;
            return false;
        }
        ParameterMetaData returnMetaData = this.getReturnParameter();
        if (returnMetaData != null && !returnMetaData.matchParameter(method, matches, exact)) {
            return false;
        }
        return matches.size() == paramTypes.length;
    }

    public boolean isMessageEndpoint() {
        ParameterMetaData inParam;
        boolean isMessageEndpoint = false;
        if (this.parameters.size() == 1 && JavaUtils.isAssignableFrom(Element.class, (Class)(inParam = this.parameters.get(0)).getJavaType())) {
            isMessageEndpoint = true;
        }
        return isMessageEndpoint;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
        this.assertOneWayOperation();
    }

    public ParameterMetaData getParameter(QName xmlName) {
        ParameterMetaData paramMetaData = null;
        for (int i = 0; paramMetaData == null && i < this.parameters.size(); ++i) {
            ParameterMetaData aux = this.parameters.get(i);
            if (!xmlName.equals(aux.getXmlName())) continue;
            paramMetaData = aux;
        }
        return paramMetaData;
    }

    public List<ParameterMetaData> getInputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.IN && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getOutputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.OUT && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getNonHeaderParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            if (paramMetaData.isInHeader()) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getParameters() {
        return new ArrayList<ParameterMetaData>(this.parameters);
    }

    public void addParameter(ParameterMetaData pmd) {
        this.log.trace((Object)("addParameter: [xmlName=" + pmd.getXmlName() + ",xmlType=" + pmd.getXmlType() + "]"));
        this.parameters.add(pmd);
        this.assertOneWayOperation();
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public ParameterMetaData getReturnParameter() {
        return this.returnParam;
    }

    public void setReturnParameter(ParameterMetaData returnParam) {
        this.log.trace((Object)("setReturnParameter: " + returnParam));
        returnParam.setMode(ParameterMode.OUT);
        returnParam.setIndex(-1);
        this.returnParam = returnParam;
        this.assertOneWayOperation();
    }

    public List<FaultMetaData> getFaults() {
        return new ArrayList<FaultMetaData>(this.faults);
    }

    public FaultMetaData getFault(QName xmlName) {
        FaultMetaData faultMetaData = null;
        for (int i = 0; faultMetaData == null && i < this.faults.size(); ++i) {
            FaultMetaData aux = this.faults.get(i);
            if (!aux.getXmlName().equals(xmlName)) continue;
            faultMetaData = aux;
        }
        return faultMetaData;
    }

    public FaultMetaData getFaultMetaData(Class javaType) {
        FaultMetaData faultMetaData = null;
        for (FaultMetaData aux : this.faults) {
            if (!aux.getJavaType().equals(javaType)) continue;
            faultMetaData = aux;
            break;
        }
        return faultMetaData;
    }

    public void addFault(FaultMetaData fault) {
        this.log.trace((Object)("addFault: " + fault));
        this.faults.add(fault);
        this.assertOneWayOperation();
    }

    private void assertOneWayOperation() {
        if (this.oneWay) {
            if (this.returnParam != null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONEWAY_CANNOT_HAVE_RETURN", (Object[])new Object[0]));
            }
            if (this.faults.size() > 0) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONEWAY_CANNOT_HAVE_CHECKEDEX", (Object[])new Object[0]));
            }
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.getMode() == ParameterMode.IN) continue;
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONEWAY_CANNOT_HAVE_INOUT", (Object[])new Object[0]));
            }
        }
    }

    public void assertDocumentBare() {
        if (this.isDocumentBare()) {
            int in = 0;
            int out = 0;
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.isInHeader()) continue;
                ParameterMode mode = paramMetaData.getMode();
                if (mode != ParameterMode.OUT) {
                    ++in;
                }
                if (mode == ParameterMode.IN) continue;
                ++out;
            }
            if (this.returnParam != null && !this.returnParam.isInHeader()) {
                ++out;
            }
            if (in > 1 || out > (this.oneWay ? 0 : 1)) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"DOC_LIT_BARE_REQUIRE", (Object[])new Object[]{this.javaName, in, out}));
            }
        }
    }

    public void validate() {
        for (ParameterMetaData parameter : this.parameters) {
            parameter.validate();
        }
        for (FaultMetaData fault : this.faults) {
            fault.validate();
        }
    }

    @Override
    public void eagerInitialize() {
        throw new NotImplementedException();
    }

    public void eagerInitialize(List<Method> unsynchronizedMethods) {
        this.javaMethod = null;
        for (ParameterMetaData parameter : this.parameters) {
            parameter.eagerInitialize();
        }
        if (this.returnParam != null) {
            this.returnParam.eagerInitialize();
        }
        for (FaultMetaData fault : this.faults) {
            fault.eagerInitialize();
        }
        for (Method method : unsynchronizedMethods) {
            if (!this.isJavaMethod(method)) continue;
            this.javaMethod = method;
            break;
        }
        if (this.javaMethod == null) {
            StringBuilder errMsg = new StringBuilder("Cannot synchronize to any of these methods:");
            for (Method method : unsynchronizedMethods) {
                errMsg.append("\n" + method);
            }
            errMsg.append("\n" + this.toString());
            throw new IllegalStateException(errMsg.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nOperationMetaData:");
        buffer.append("\n qname=" + this.qname);
        buffer.append("\n javaName=" + this.javaName);
        buffer.append("\n style=" + this.getStyle() + "/" + this.getUse());
        if (this.getStyle() == Style.DOCUMENT) {
            buffer.append("/" + this.getParameterStyle());
        }
        buffer.append("\n oneWay=" + this.oneWay);
        buffer.append("\n soapAction=" + this.soapAction);
        for (ParameterMetaData param : this.parameters) {
            buffer.append(param);
        }
        if (this.returnParam != null) {
            buffer.append(this.returnParam.toString());
        }
        for (FaultMetaData fault : this.faults) {
            buffer.append(fault);
        }
        return buffer.toString();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

