/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.client;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.interfaces.ServiceCreatorIntf;

public class ServiceCreator
implements ServiceCreatorIntf {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServiceCreator.class);
    protected String packageName = null;
    protected File dirLocation = null;
    protected WSDLDefinitions wsdl = null;
    private WSDLUtils utils = WSDLUtils.getInstance();

    public ServiceCreator() {
    }

    public ServiceCreator(WSDLDefinitions wsdl, String packageName) {
        this.wsdl = wsdl;
        this.packageName = packageName;
    }

    public ServiceCreator(WSDLDefinitions wsdl, String packageName, File location) {
        this(wsdl, packageName);
        this.dirLocation = location;
    }

    public File getDirLocation() {
        return this.dirLocation;
    }

    public void setDirLocation(File dirLocation) {
        this.dirLocation = dirLocation;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public WSDLDefinitions getWsdl() {
        return this.wsdl;
    }

    @Override
    public void setWsdl(WSDLDefinitions wsdl) {
        this.wsdl = wsdl;
    }

    @Override
    public void createServiceDescriptor() throws IOException {
        if (this.packageName == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PACKAGE_NAME_IS_NULL", (Object[])new Object[0]));
        }
        if (this.dirLocation == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"DIR_LOCATION_IS_NULL", (Object[])new Object[0]));
        }
        if (this.wsdl == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"WSDL_DEFINITIONS_IS_NULL", (Object[])new Object[0]));
        }
        WSDLService[] services = this.wsdl.getServices();
        int len = services != null ? services.length : 0;
        for (int i = 0; i < len; ++i) {
            this.generateServiceFile(services[i]);
        }
    }

    private void generateHeader(StringBuilder buf) {
        buf.append("/*  " + this.newLine(1));
        buf.append("* JBoss, the OpenSource EJB server" + this.newLine(1));
        buf.append("* Distributable under LGPL license. See terms of license at gnu.org." + this.newLine(1));
        buf.append("*/" + this.newLine(2));
        buf.append("//Auto Generated by jbossws - Please do not edit!!!");
        buf.append(this.newLine(2));
    }

    private void generatePackageNameAndImport(StringBuilder buf) {
        buf.append("package " + this.packageName + ";" + this.newLine(3));
        buf.append("import javax.xml.rpc.*; " + this.newLine(3));
    }

    private String getReturnType(WSDLBinding wbind) {
        String portType = wbind.getInterface().getName().getLocalPart();
        if (this.wsdl.getService(portType = this.utils.chopPortType(portType)) != null) {
            portType = portType + "_PortType";
        }
        return this.packageName + "." + JavaUtils.capitalize((String)portType);
    }

    private void generateServiceFile(WSDLService wsdlService) throws IOException {
        String serviceName = wsdlService.getName().getLocalPart();
        if (!serviceName.endsWith("Service")) {
            serviceName = serviceName + "Service";
        }
        if (this.wsdl.getInterface(new QName(this.wsdl.getTargetNamespace(), serviceName)) != null) {
            serviceName = new StringBuilder(serviceName).insert(serviceName.lastIndexOf("Service"), '_').toString();
        }
        serviceName = ToolsUtils.convertInvalidCharacters(serviceName);
        serviceName = JavaUtils.capitalize((String)serviceName);
        StringBuilder buf = new StringBuilder();
        this.generateHeader(buf);
        this.generatePackageNameAndImport(buf);
        buf.append("public interface  " + serviceName + " extends  javax.xml.rpc.Service" + this.newLine(1));
        buf.append("{" + this.newLine(2));
        WSDLEndpoint[] endpts = wsdlService.getEndpoints();
        int len = endpts != null ? endpts.length : 0;
        for (int i = 0; i < len; ++i) {
            buf.append(this.generateServiceMethodForWSDLEndpoint(endpts[i])).append(this.newLine(1));
        }
        buf.append("}" + this.newLine(1));
        File loc = this.utils.createPackage(this.dirLocation.getAbsolutePath(), this.packageName);
        File sei = this.utils.createPhysicalFile(loc, serviceName);
        FileWriter writer = new FileWriter(sei);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    public static String removeHyphens(String component) {
        String result = component;
        for (int i = 0; i < result.length(); ++i) {
            if (result.charAt(i) != '-') continue;
            result = result.replace(result.charAt(i), '_');
        }
        return result;
    }

    private String generateServiceMethodForWSDLEndpoint(WSDLEndpoint endpt) {
        StringBuilder buf = new StringBuilder("     public ");
        QName bindName = endpt.getBinding();
        WSDLBinding wbind = this.wsdl.getBinding(bindName);
        buf.append(ServiceCreator.removeHyphens(this.getReturnType(wbind))).append(" get");
        buf.append(endpt.getName().getLocalPart()).append("()").append(" throws ServiceException;").append(this.newLine(1));
        return buf.toString();
    }

    private String newLine(int times) {
        String newline = "\n";
        StringBuilder buf = new StringBuilder(newline);
        for (int i = 0; i < times - 1; ++i) {
            buf.append(newline);
        }
        return buf.toString();
    }
}

