/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wsp;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.ParserController;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.ws.policy.AppliesTo;

public class WSPolicyParser
extends AbstractParser {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                String elementName = StaxParserUtil.getStartElementName(startElement);
                if (!elementName.equalsIgnoreCase("AppliesTo")) continue;
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                AppliesTo appliesTo = new AppliesTo();
                startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                QName qname = startElement.getName();
                ParserNamespaceSupport parser = ParserController.get(qname);
                if (parser == null) {
                    throw new RuntimeException("PL00062: Parser : Unknown tag:" + qname);
                }
                Object parsedObject = parser.parse(xmlEventReader);
                appliesTo.addAny(parsedObject);
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, "AppliesTo");
                return appliesTo;
            }
            StaxParserUtil.getNextEvent(xmlEventReader);
        }
        throw logger.parserFailed("http://schemas.xmlsoap.org/ws/2004/09/policy");
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        return "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(nsURI);
    }
}

