/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.saml.v2.util.SecurityActions;

public class XMLTimeUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static XMLGregorianCalendar add(XMLGregorianCalendar value, long milis) throws ConfigurationException {
        Duration duration;
        XMLGregorianCalendar newVal = (XMLGregorianCalendar)value.clone();
        try {
            duration = DatatypeFactory.newInstance().newDuration(milis);
        }
        catch (DatatypeConfigurationException e) {
            throw logger.configurationError(e);
        }
        newVal.add(duration);
        return newVal;
    }

    public static XMLGregorianCalendar subtract(XMLGregorianCalendar value, long milis) throws ConfigurationException {
        if (milis < 0L) {
            throw logger.invalidArgumentError("milis should be a positive value");
        }
        return XMLTimeUtil.add(value, -1L * milis);
    }

    public static XMLGregorianCalendar getIssueInstant(String timezone) throws ConfigurationException {
        DatatypeFactory dtf;
        TimeZone tz = TimeZone.getTimeZone(timezone);
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw logger.configurationError(e);
        }
        GregorianCalendar gc = new GregorianCalendar(tz);
        XMLGregorianCalendar xgc = dtf.newXMLGregorianCalendar(gc);
        return xgc;
    }

    public static XMLGregorianCalendar getIssueInstant() throws ConfigurationException {
        return XMLTimeUtil.getIssueInstant(XMLTimeUtil.getCurrentTimeZoneID());
    }

    public static String getCurrentTimeZoneID() {
        String timezonePropertyValue = SecurityActions.getSystemProperty("picketlink.timezone", "GMT");
        TimeZone timezone = "TIMEZONE_DEFAULT".equals(timezonePropertyValue) ? TimeZone.getDefault() : TimeZone.getTimeZone(timezonePropertyValue);
        return timezone.getID();
    }

    public static long inMilis(int valueInMins) {
        return valueInMins * 60 * 1000;
    }

    public static boolean isValid(XMLGregorianCalendar now, XMLGregorianCalendar notbefore, XMLGregorianCalendar notOnOrAfter) {
        if (notbefore == null) {
            throw logger.nullArgumentError("notbefore argument is null");
        }
        if (notOnOrAfter == null) {
            throw logger.nullArgumentError("notOnOrAfter argument is null");
        }
        int val = notbefore.compare(now);
        if (val == 2 || val == 1) {
            return false;
        }
        val = notOnOrAfter.compare(now);
        return val == 1;
    }

    public static Duration parseAsDuration(String timeValue) throws ParsingException {
        DatatypeFactory factory = null;
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw logger.parserError(e);
        }
        return factory.newDuration(Long.parseLong(timeValue));
    }

    public static XMLGregorianCalendar parse(String timeString) throws ParsingException {
        DatatypeFactory factory = null;
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw logger.parserError(e);
        }
        return factory.newXMLGregorianCalendar(timeString);
    }
}

