/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustParser;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.core.wstrust.writers.WSTrustRequestWriter;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STSClient {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final ThreadLocal<Dispatch<Source>> dispatchLocal = new InheritableThreadLocal<Dispatch<Source>>();
    private final String targetNS = "http://org.picketlink.trust/sts/";
    private String wsaIssuerAddress;
    private String wspAppliesTo;
    private boolean isBatch = false;

    public STSClient() {
    }

    public STSClient(STSClientConfig config) {
        QName service = new QName("http://org.picketlink.trust/sts/", config.getServiceName());
        QName portName = new QName("http://org.picketlink.trust/sts/", config.getPortName());
        this.isBatch = config.isBatch();
        this.wsaIssuerAddress = config.getWsaIssuer();
        this.wspAppliesTo = config.getWspAppliesTo();
        Service jaxwsService = Service.create((QName)service);
        jaxwsService.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", config.getEndPointAddress());
        Dispatch dispatch = jaxwsService.createDispatch(portName, Source.class, Service.Mode.PAYLOAD);
        Map reqContext = dispatch.getRequestContext();
        String username = config.getUsername();
        if (username != null) {
            reqContext.put("javax.xml.ws.security.auth.username", config.getUsername());
            reqContext.put("javax.xml.ws.security.auth.password", config.getPassword());
        }
        this.setDispatch((Dispatch<Source>)dispatch);
    }

    public void setDispatch(Dispatch<Source> dispatch) {
        if (dispatch == null) {
            throw logger.nullArgumentError("dispatch");
        }
        this.dispatchLocal.set(dispatch);
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        this.setTokenType(tokenType, request);
        if (this.wsaIssuerAddress != null) {
            request.setIssuer(WSTrustUtil.createIssuer(this.wsaIssuerAddress));
        }
        if (this.wspAppliesTo != null) {
            request.setAppliesTo(WSTrustUtil.createAppliesTo(this.wspAppliesTo));
        }
        return this.issueToken(request);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        if (this.wsaIssuerAddress != null) {
            request.setIssuer(WSTrustUtil.createIssuer(this.wsaIssuerAddress));
        }
        this.setAppliesTo(endpointURI, request);
        return this.issueToken(request);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw logger.nullArgumentError("endpointURI or tokenType");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        if (this.wsaIssuerAddress != null) {
            request.setIssuer(WSTrustUtil.createIssuer(this.wsaIssuerAddress));
        }
        this.setAppliesTo(endpointURI, request);
        this.setTokenType(tokenType, request);
        return this.issueToken(request);
    }

    public Element issueTokenOnBehalfOf(String endpointURI, String tokenType, Principal principal) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw logger.nullArgumentError("endpointURI or tokenType");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        if (this.wsaIssuerAddress != null) {
            request.setIssuer(WSTrustUtil.createIssuer(this.wsaIssuerAddress));
        }
        this.setAppliesTo(endpointURI, request);
        this.setTokenType(tokenType, request);
        this.setOnBehalfOf(principal, request);
        return this.issueToken(request);
    }

    private RequestSecurityToken setAppliesTo(String endpointURI, RequestSecurityToken rst) {
        if (StringUtil.isNotNull(this.wspAppliesTo)) {
            rst.setAppliesTo(WSTrustUtil.createAppliesTo(this.wspAppliesTo));
        } else if (endpointURI != null) {
            rst.setAppliesTo(WSTrustUtil.createAppliesTo(endpointURI));
        }
        return rst;
    }

    private RequestSecurityToken setTokenType(String tokenType, RequestSecurityToken rst) {
        if (tokenType != null) {
            rst.setTokenType(URI.create(tokenType));
        }
        return rst;
    }

    private RequestSecurityToken setOnBehalfOf(Principal principal, RequestSecurityToken request) {
        if (principal != null) {
            request.setOnBehalfOf(WSTrustUtil.createOnBehalfOfWithUsername(principal.getName(), "ID"));
        }
        return request;
    }

    public Element issueToken(RequestSecurityToken request) throws WSTrustException {
        NodeList nodes;
        if (request.getRequestType() == null) {
            if (this.isBatch) {
                request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue"));
            } else {
                request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue"));
            }
        }
        if (request.getContext() == null) {
            request.setContext("default-context");
        }
        this.validateDispatch();
        DOMSource requestSource = this.createSourceFromRequest(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(response);
            Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
                }
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = responseDoc.getElementsByTagName("RequestedSecurityToken");
                }
            }
        }
        catch (Exception e) {
            throw new WSTrustException(logger.processingError(e));
        }
        if (nodes == null) {
            throw new WSTrustException(logger.nullValueError("NodeList"));
        }
        Node rstr = nodes.item(0);
        if (rstr == null) {
            throw new WSTrustException(logger.nullValueError("RSTR in the payload"));
        }
        return (Element)rstr.getFirstChild();
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        NodeList nodes;
        this.validateDispatch();
        RequestSecurityToken request = new RequestSecurityToken();
        request.setContext("context");
        request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew"));
        RenewTargetType renewTarget = new RenewTargetType();
        renewTarget.add(token);
        request.setRenewTarget(renewTarget);
        DOMSource requestSource = this.createSourceFromRequest(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            Node documentNode = DocumentUtil.getNodeFromSource(response);
            Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
                }
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken");
                if (nodes == null || nodes.getLength() == 0) {
                    nodes = responseDoc.getElementsByTagName("RequestedSecurityToken");
                }
            }
        }
        catch (Exception e) {
            throw new WSTrustException(logger.processingError(e));
        }
        if (nodes == null) {
            throw new WSTrustException(logger.nullValueError("NodeList"));
        }
        Node rstr = nodes.item(0);
        return (Element)rstr.getFirstChild();
    }

    public boolean validateToken(Element token) throws WSTrustException {
        this.validateDispatch();
        RequestSecurityToken request = new RequestSecurityToken();
        request.setContext("context");
        request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate"));
        ValidateTargetType validateTarget = new ValidateTargetType();
        validateTarget.add(token);
        request.setValidateTarget(validateTarget);
        DOMSource requestSource = this.createSourceFromRequest(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            InputStream stream = DocumentUtil.getNodeAsStream(DocumentUtil.getNodeFromSource(response));
            RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)new WSTrustParser().parse(stream);
            RequestSecurityTokenResponse tokenResponse = responseCollection.getRequestSecurityTokenResponses().get(0);
            StatusType status = tokenResponse.getStatus();
            if (status != null) {
                String code = status.getCode();
                return "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid".equals(code);
            }
            return false;
        }
        catch (Exception e) {
            throw new WSTrustException(logger.parserError(e));
        }
    }

    public boolean cancelToken(Element securityToken) throws WSTrustException {
        this.validateDispatch();
        RequestSecurityToken request = new RequestSecurityToken();
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel"));
        CancelTargetType cancelTarget = new CancelTargetType();
        cancelTarget.add(securityToken);
        request.setCancelTarget(cancelTarget);
        request.setContext("context");
        DOMSource requestSource = this.createSourceFromRequest(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        try {
            InputStream stream = DocumentUtil.getNodeAsStream(DocumentUtil.getNodeFromSource(response));
            RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)new WSTrustParser().parse(stream);
            RequestSecurityTokenResponse tokenResponse = responseCollection.getRequestSecurityTokenResponses().get(0);
            return tokenResponse.getRequestedTokenCancelled() != null;
        }
        catch (Exception e) {
            throw new WSTrustException(logger.parserError(e));
        }
    }

    public Dispatch<Source> getDispatch() {
        return this.dispatchLocal.get();
    }

    private DOMSource createSourceFromRequest(RequestSecurityToken request) throws WSTrustException {
        try {
            DOMResult result = new DOMResult(DocumentUtil.createDocument());
            WSTrustRequestWriter writer = new WSTrustRequestWriter(result);
            writer.write(request);
            return new DOMSource(result.getNode());
        }
        catch (Exception e) {
            throw new WSTrustException(logger.processingError(e));
        }
    }

    private void validateDispatch() {
        if (this.getDispatch() == null) {
            throw logger.injectedValueMissing("Dispatch");
        }
    }
}

