/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspCollector;
import org.jgroups.blocks.RspFilter;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;

public abstract class Request
implements RspCollector,
NotifyingFuture {
    protected static final Log log = LogFactory.getLog(Request.class);
    protected static final AtomicLong REQUEST_ID = new AtomicLong(1L);
    protected final Lock lock = new ReentrantLock();
    protected final Condition completed = this.lock.newCondition();
    protected final Message request_msg;
    protected final RequestCorrelator corr;
    protected final RequestOptions options;
    protected volatile boolean done;
    protected boolean block_for_results = true;
    protected final long req_id;
    protected volatile FutureListener listener;

    public Request(Message request, RequestCorrelator corr, RequestOptions options) {
        this.request_msg = request;
        this.corr = corr;
        this.options = options;
        this.req_id = Request.getRequestId();
    }

    public void setResponseFilter(RspFilter filter) {
        this.options.setRspFilter(filter);
    }

    public boolean getBlockForResults() {
        return this.block_for_results;
    }

    public void setBlockForResults(boolean block_for_results) {
        this.block_for_results = block_for_results;
    }

    public NotifyingFuture setListener(FutureListener listener) {
        this.listener = listener;
        if (this.done) {
            listener.futureDone(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        if (this.corr == null) {
            if (log.isErrorEnabled()) {
                log.error("corr is null, cannot send request");
            }
            return false;
        }
        this.sendRequest();
        if (!this.block_for_results || this.options.getMode() == ResponseMode.GET_NONE) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.responsesComplete(this.options.getTimeout());
            return bl;
        }
        finally {
            this.done = true;
            this.lock.unlock();
        }
    }

    protected abstract void sendRequest() throws Exception;

    @Override
    public abstract void receiveResponse(Object var1, Address var2, boolean var3);

    @Override
    public abstract void viewChange(View var1);

    @Override
    public abstract void suspect(Address var1);

    protected abstract boolean responsesComplete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResponsesComplete() {
        this.lock.lock();
        try {
            boolean bl = this.responsesComplete();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.lock.lock();
        try {
            boolean retval = !this.done;
            this.done = true;
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            this.completed.signalAll();
            boolean bl = retval;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        ret.append(", req_id=").append(this.req_id).append(", mode=" + (Object)((Object)this.options.getMode()));
        return ret.toString();
    }

    protected void checkCompletion(Future future) {
        if (this.listener != null && this.responsesComplete()) {
            this.listener.futureDone(future);
        }
    }

    protected static long getRequestId() {
        return REQUEST_ID.incrementAndGet();
    }

    protected boolean responsesComplete(long timeout) throws InterruptedException {
        if (timeout <= 0L) {
            while (!this.done) {
                if (this.responsesComplete()) {
                    if (this.corr != null) {
                        this.corr.done(this.req_id);
                    }
                    return true;
                }
                this.completed.await();
            }
            return this.responsesComplete();
        }
        long start_time = System.currentTimeMillis();
        long timeout_time = start_time + timeout;
        while (timeout > 0L && !this.done) {
            if (this.responsesComplete()) {
                if (this.corr != null) {
                    this.corr.done(this.req_id);
                }
                return true;
            }
            timeout = timeout_time - System.currentTimeMillis();
            if (timeout <= 0L) continue;
            this.completed.await(timeout, TimeUnit.MILLISECONDS);
        }
        if (this.corr != null) {
            this.corr.done(this.req_id);
        }
        return this.responsesComplete();
    }

    protected boolean waitForResults(long timeout) {
        if (timeout <= 0L) {
            while (true) {
                if (this.responsesComplete()) {
                    return true;
                }
                try {
                    this.completed.await();
                }
                catch (Exception e) {}
            }
        }
        long start_time = System.currentTimeMillis();
        long timeout_time = start_time + timeout;
        while (timeout > 0L) {
            if (this.responsesComplete()) {
                return true;
            }
            timeout = timeout_time - System.currentTimeMillis();
            if (timeout <= 0L) continue;
            try {
                this.completed.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {}
        }
        return false;
    }
}

