/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.DistributedCacheManager;
import org.jboss.as.clustering.web.IncomingDistributableSessionData;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionOwnershipSupport;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.session.ClusteredSessionManager;
import org.jboss.as.web.session.SessionInvalidationTracker;
import org.jboss.as.web.session.notification.ClusteredSessionManagementStatus;
import org.jboss.as.web.session.notification.ClusteredSessionNotificationCause;
import org.jboss.as.web.session.notification.ClusteredSessionNotificationPolicy;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationTrigger;

public abstract class ClusteredSession<O extends OutgoingDistributableSessionData>
implements HttpSession,
Session {
    protected static final boolean ACTIVITY_CHECK = Globals.STRICT_SERVLET_COMPLIANCE || Boolean.valueOf(System.getProperty("org.apache.catalina.session.StandardSession.ACTIVITY_CHECK", "false")) != false;
    protected static final String info = "ClusteredSession/1.0";
    protected static final String[] excludedAttributes = new String[]{"javax.security.auth.subject"};
    protected static final Set<String> replicationExcludes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(excludedAttributes)));
    protected static final Class<?>[] containerEventTypes = new Class[]{String.class, Object.class};
    protected static final Logger log = Logger.getLogger(ClusteredSession.class);
    protected static HttpSessionContext sessionContext = new HttpSessionContext(){

        public Enumeration<String> getIds() {
            return Collections.enumeration(Collections.emptyList());
        }

        public HttpSession getSession(String sessionId) {
            return null;
        }
    };
    protected static final StringManager sm = StringManager.getManager((String)ClusteredSession.class.getPackage().getName());
    private static final long FULL_REPLICATION_WINDOW_LENGTH = 5000L;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(16, 0.75f, 2);
    private transient String authType = null;
    private transient Method containerEventMethod = null;
    private long creationTime = 0L;
    private volatile transient boolean expiring = false;
    private transient StandardSessionFacade facade = null;
    private String id = null;
    private volatile long lastAccessedTime = this.creationTime;
    private transient List<SessionListener> listeners = new ArrayList<SessionListener>();
    private transient ClusteredSessionManager<O> manager = null;
    private transient DistributedCacheManager<O> distributedCacheManager;
    private int maxInactiveInterval = -1;
    private boolean isNew = false;
    private volatile boolean isValid = false;
    private final transient Map<String, Object> notes = new Hashtable<String, Object>();
    private transient Principal principal = null;
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile long thisAccessedTime = this.creationTime;
    private final transient AtomicInteger accessCount;
    private ReplicationTrigger invalidationPolicy;
    private transient boolean sessionMetadataDirty;
    private transient boolean sessionAttributesDirty;
    private final transient AtomicLong timestamp = new AtomicLong(0L);
    private volatile transient DistributableSessionMetadata metadata = new DistributableSessionMetadata();
    private volatile transient long outdatedTime;
    private final AtomicInteger version = new AtomicInteger(0);
    private transient String realId;
    private volatile transient long lastReplicated;
    private transient long maxUnreplicatedInterval;
    private transient boolean alwaysReplicateTimestamp = true;
    private transient Boolean hasActivationListener;
    private transient boolean firstAccess = true;
    private transient ClusteredSessionNotificationPolicy notificationPolicy;
    private transient ClusteredSessionManagementStatus clusterStatus;
    private transient boolean needsPostReplicateActivation;
    private transient boolean fullReplicationRequired = true;
    private transient long fullReplicationWindow = -1L;
    private transient Lock ownershipLock = new ReentrantLock();

    protected ClusteredSession(ClusteredSessionManager<O> manager) {
        this.accessCount = ACTIVITY_CHECK ? new AtomicInteger() : null;
        this.setManager(manager);
        this.requireFullReplication();
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public long getCreationTime() {
        if (!this.isValidInternal()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        return this.creationTime;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
        this.sessionMetadataDirty();
    }

    public String getId() {
        return this.id;
    }

    public String getIdInternal() {
        return this.id;
    }

    public void setId(String id) {
        this.parseRealId(id);
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = id;
        this.clusterStatus = new ClusteredSessionManagementStatus(this.realId, true, null, null);
        if (this.manager != null) {
            this.manager.add(this);
        }
    }

    public long getLastAccessedTime() {
        if (!this.isValidInternal()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        return this.lastAccessedTime;
    }

    public long getLastAccessedTimeInternal() {
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        ClusteredSessionManager unchecked;
        if (!(manager instanceof ClusteredSessionManager)) {
            throw WebMessages.MESSAGES.invalidManager();
        }
        this.manager = unchecked = (ClusteredSessionManager)manager;
        this.invalidationPolicy = this.manager.getReplicationTrigger();
        int maxUnrep = this.manager.getMaxUnreplicatedInterval() * 1000;
        this.setMaxUnreplicatedInterval(maxUnrep);
        this.notificationPolicy = this.manager.getNotificationPolicy();
        this.establishDistributedCacheManager();
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
        this.checkAlwaysReplicateTimestamp();
        this.sessionMetadataDirty();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (oldPrincipal != null && !((Object)oldPrincipal).equals(principal) || oldPrincipal == null && principal != null) {
            this.sessionMetadataDirty();
        }
    }

    public void access() {
        try {
            this.acquireSessionOwnership();
        }
        catch (TimeoutException e) {
            try {
                this.acquireSessionOwnership();
            }
            catch (TimeoutException te) {
                throw WebMessages.MESSAGES.failAcquiringOwnership(this.realId, te);
            }
        }
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        if (ACTIVITY_CHECK) {
            this.accessCount.incrementAndGet();
        }
        if (!this.firstAccess && this.isNew) {
            this.setNew(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireSessionOwnership() throws TimeoutException {
        SessionOwnershipSupport support = this.distributedCacheManager.getSessionOwnershipSupport();
        if (support != null) {
            try {
                this.ownershipLock.lockInterruptibly();
                try {
                    IncomingDistributableSessionData data;
                    if (support.acquireSessionOwnership(this.realId, this.needNewLock()) == SessionOwnershipSupport.LockResult.ACQUIRED_FROM_CLUSTER && (data = this.distributedCacheManager.getSessionData(this.realId, false)) != null) {
                        this.update(data);
                    }
                }
                finally {
                    this.ownershipLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw WebMessages.MESSAGES.interruptedAcquiringOwnership(this.realId, e);
            }
        }
    }

    private boolean needNewLock() {
        return this.firstAccess && this.isNew;
    }

    public void endAccess() {
        this.isNew = false;
        if (ACTIVITY_CHECK) {
            this.accessCount.decrementAndGet();
        }
        this.lastAccessedTime = this.thisAccessedTime;
        if (this.firstAccess) {
            this.firstAccess = false;
            this.isNew = true;
        }
        this.relinquishSessionOwnership(false);
    }

    private void relinquishSessionOwnership(boolean remove) {
        SessionOwnershipSupport support = this.distributedCacheManager.getSessionOwnershipSupport();
        if (support != null) {
            support.relinquishSessionOwnership(this.realId, remove);
        }
    }

    public boolean isNew() {
        if (!this.isValidInternal()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
        this.sessionMetadataDirty();
    }

    public void invalidate() {
        if (!this.isValid()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        boolean notify = true;
        boolean localCall = true;
        boolean localOnly = false;
        this.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE);
        this.relinquishSessionOwnership(false);
    }

    public void expire() {
        boolean notify = true;
        boolean localCall = true;
        boolean localOnly = false;
        this.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE);
    }

    public void recycle() {
        if (!this.isValid) {
            SessionInvalidationTracker.clearInvalidatedSession(this.id, this.manager);
        }
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        this.firstAccess = true;
        this.manager = null;
        this.listeners.clear();
        this.support = new PropertyChangeSupport(this);
        this.invalidationPolicy = ReplicationTrigger.ACCESS;
        this.outdatedTime = 0L;
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.realId = null;
        this.version.set(0);
        this.hasActivationListener = null;
        this.lastReplicated = 0L;
        this.maxUnreplicatedInterval = 0L;
        this.alwaysReplicateTimestamp = true;
        this.notificationPolicy = null;
        this.clusterStatus = null;
    }

    public void addSessionListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                StandardSessionFacade ssf;
                final ClusteredSession fsession = this;
                this.facade = ssf = AccessController.doPrivileged(new PrivilegedAction<StandardSessionFacade>(){

                    @Override
                    public StandardSessionFacade run() {
                        return new StandardSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new StandardSessionFacade((HttpSession)this);
            }
        }
        return this.facade;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = (Context)this.manager.getContainer();
        if (context == null) {
            return null;
        }
        return context.getServletContext();
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        return this.getAttributeInternal(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (!this.isValid()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        return new Enumerator(this.getAttributesInternal().keySet(), true);
    }

    public void setAttribute(String name, Object value) {
        Object unbound;
        if (name == null) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValidInternal()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        if (!this.canAttributeBeReplicated(value)) {
            throw WebMessages.MESSAGES.failToReplicateAttribute();
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener && this.notificationPolicy.isHttpSessionBindingListenerInvocationAllowed(this.clusterStatus, ClusteredSessionNotificationCause.MODIFY, name, true)) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorValueBoundEvent(t));
            }
        }
        if (value instanceof HttpSessionActivationListener) {
            this.hasActivationListener = Boolean.TRUE;
        }
        if ((unbound = this.setAttributeInternal(name, value)) != null && unbound != value && unbound instanceof HttpSessionBindingListener && this.notificationPolicy.isHttpSessionBindingListenerInvocationAllowed(this.clusterStatus, ClusteredSessionNotificationCause.MODIFY, name, true)) {
            try {
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorValueUnboundEvent(t));
            }
        }
        if (this.notificationPolicy.isHttpSessionAttributeListenerInvocationAllowed(this.clusterStatus, ClusteredSessionNotificationCause.MODIFY, name, true)) {
            Context context = (Context)this.manager.getContainer();
            Object[] lifecycleListeners = context.getApplicationEventListeners();
            if (lifecycleListeners == null) {
                return;
            }
            for (int i = 0; i < lifecycleListeners.length; ++i) {
                if (!(lifecycleListeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)lifecycleListeners[i];
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                        if (event == null) {
                            event = new HttpSessionBindingEvent(this.getSession(), name, unbound);
                        }
                        listener.attributeReplaced(event);
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                        continue;
                    }
                    this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, value);
                    }
                    listener.attributeAdded(event);
                    this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        if (unbound != null) {
                            this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                        } else {
                            this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorSessionAttributeEvent(t));
                }
            }
        }
    }

    public void removeAttribute(String name) {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("clusteredSession.removeAttribute.ise"));
        }
        boolean localCall = true;
        boolean localOnly = false;
        boolean notify = true;
        this.removeAttributeInternal(name, true, false, true, ClusteredSessionNotificationCause.MODIFY);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return sessionContext;
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public String[] getValueNames() {
        if (!this.isValidInternal()) {
            throw WebMessages.MESSAGES.expiredSession();
        }
        return this.keys();
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public String getRealId() {
        return this.realId;
    }

    public boolean getMustReplicateTimestamp() {
        boolean exceeds;
        boolean touched = this.thisAccessedTime != this.lastAccessedTime;
        boolean bl = exceeds = this.alwaysReplicateTimestamp && touched;
        if (!exceeds && touched && this.maxUnreplicatedInterval > 0L) {
            long unrepl = System.currentTimeMillis() - this.lastReplicated;
            exceeds = unrepl >= this.maxUnreplicatedInterval;
        }
        return exceeds;
    }

    public void update(IncomingDistributableSessionData sessionData) {
        long ts;
        assert (sessionData != null) : WebMessages.MESSAGES.nullSessionData();
        this.version.set(sessionData.getVersion());
        this.lastAccessedTime = this.thisAccessedTime = (ts = sessionData.getTimestamp());
        this.timestamp.set(ts);
        DistributableSessionMetadata md = sessionData.getMetadata();
        this.id = md.getId();
        this.creationTime = md.getCreationTime();
        this.maxInactiveInterval = md.getMaxInactiveInterval();
        this.isNew = md.isNew();
        this.isValid = md.isValid();
        this.metadata = md;
        this.parseRealId(this.id);
        this.hasActivationListener = null;
        this.firstAccess = false;
        this.lastReplicated = this.creationTime;
        this.clusterStatus = new ClusteredSessionManagementStatus(this.realId, true, null, null);
        this.checkAlwaysReplicateTimestamp();
        this.populateAttributes(sessionData.getSessionAttributes());
        this.outdatedTime = 0L;
        this.requireFullReplication();
    }

    public synchronized void processSessionReplication() {
        if (log.isTraceEnabled()) {
            log.tracef("processSessionReplication(): session is dirty. Will increment version from: %s and replicate.", (Object)this.getVersion());
        }
        this.version.incrementAndGet();
        O outgoingData = this.getOutgoingSessionData();
        this.distributedCacheManager.storeSessionData(outgoingData);
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.lastReplicated = System.currentTimeMillis();
        this.fullReplicationRequired = false;
        if (this.fullReplicationWindow > 0L && System.currentTimeMillis() > this.fullReplicationWindow) {
            this.fullReplicationWindow = -1L;
        }
    }

    public void removeMyself() {
        this.getDistributedCacheManager().removeSession(this.getRealId());
    }

    public void removeMyselfLocal() {
        this.getDistributedCacheManager().removeSessionLocal(this.getRealId());
    }

    public long getCreationTimeInternal() {
        return this.creationTime;
    }

    public long getLastReplicated() {
        return this.lastReplicated;
    }

    public long getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(long interval) {
        this.maxUnreplicatedInterval = Math.max(interval, -1L);
        this.checkAlwaysReplicateTimestamp();
    }

    public void resetIdWithRouteInfo(String id) {
        this.id = id;
        this.parseRealId(id);
    }

    public boolean setVersionFromDistributedCache(int version) {
        boolean outdated;
        boolean bl = outdated = this.getVersion() < version;
        if (outdated) {
            this.outdatedTime = System.currentTimeMillis();
        }
        return outdated;
    }

    public boolean isOutdated() {
        return this.thisAccessedTime < this.outdatedTime || this.creationTime == 0L;
    }

    public boolean isSessionDirty() {
        return this.sessionAttributesDirty || this.sessionMetadataDirty;
    }

    public void tellNew(ClusteredSessionNotificationCause cause) {
        Context context;
        Object[] lifecycleListeners;
        this.fireSessionEvent("createSession", null);
        if (this.notificationPolicy.isHttpSessionListenerInvocationAllowed(this.clusterStatus, cause, true) && (lifecycleListeners = (context = (Context)this.manager.getContainer()).getApplicationSessionLifecycleListeners()) != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            for (int i = 0; i < lifecycleListeners.length; ++i) {
                if (!(lifecycleListeners[i] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)lifecycleListeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                    this.fireContainerEvent(context, "afterSessionCreated", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionCreated", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorSessionEvent(t));
                }
            }
        }
    }

    public boolean isValid(boolean expireIfInvalid) {
        long timeNow;
        int timeIdle;
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (ACTIVITY_CHECK && this.accessCount.get() > 0) {
            return true;
        }
        if (this.maxInactiveInterval > 0 && (timeIdle = (int)(((timeNow = System.currentTimeMillis()) - this.thisAccessedTime) / 1000L)) >= this.maxInactiveInterval) {
            if (expireIfInvalid) {
                boolean notify = true;
                boolean localCall = true;
                boolean localOnly = true;
                this.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.TIMEOUT);
            } else {
                return false;
            }
        }
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify, boolean localCall, boolean localOnly, ClusteredSessionNotificationCause cause) {
        if (log.isTraceEnabled()) {
            log.tracef("The session has expired with id: %s  -- is expiration local? %s", (Object)this.id, (Object)localOnly);
        }
        if (this.expiring) {
            return;
        }
        ClusteredSession clusteredSession = this;
        synchronized (clusteredSession) {
            boolean requireOwnershipLock;
            if (!this.isValid) {
                return;
            }
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            RuntimeException listenerException = null;
            boolean bl = requireOwnershipLock = localCall && !localOnly;
            if (requireOwnershipLock) {
                try {
                    this.acquireSessionOwnership();
                }
                catch (TimeoutException e) {
                    this.expiring = false;
                    throw WebMessages.MESSAGES.failAcquiringOwnership(this.realId, e);
                }
            }
            try {
                int i;
                Context context = (Context)this.manager.getContainer();
                Object[] lifecycleListeners = context.getApplicationSessionLifecycleListeners();
                if (notify && lifecycleListeners != null && this.notificationPolicy.isHttpSessionListenerInvocationAllowed(this.clusterStatus, cause, localCall)) {
                    HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                    for (i = 0; i < lifecycleListeners.length; ++i) {
                        int j = lifecycleListeners.length - 1 - i;
                        if (!(lifecycleListeners[j] instanceof HttpSessionListener)) continue;
                        HttpSessionListener listener = (HttpSessionListener)lifecycleListeners[j];
                        try {
                            block29: {
                                this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                                try {
                                    listener.sessionDestroyed(event);
                                }
                                catch (RuntimeException e) {
                                    if (listenerException != null) break block29;
                                    listenerException = e;
                                }
                            }
                            this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorSessionEvent(t));
                        }
                    }
                }
                if (ACTIVITY_CHECK) {
                    this.accessCount.set(0);
                }
                if (notify) {
                    this.fireSessionEvent("destroySession", null);
                }
                String[] keys = this.keys();
                for (i = 0; i < keys.length; ++i) {
                    try {
                        this.removeAttributeInternal(keys[i], localCall, localOnly, notify, cause);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (listenerException != null) continue;
                        listenerException = e;
                    }
                }
                if (localCall) {
                    this.removeFromManager(localOnly);
                }
                if (listenerException != null) {
                    throw listenerException;
                }
            }
            finally {
                this.setValid(false);
                this.expiring = false;
                if (requireOwnershipLock) {
                    this.relinquishSessionOwnership(true);
                }
            }
        }
    }

    public void notifyWillPassivate(ClusteredSessionNotificationCause cause) {
        this.fireSessionEvent("passivateSession", null);
        if (this.hasActivationListener != Boolean.FALSE) {
            boolean hasListener = false;
            HttpSessionEvent event = null;
            String[] keys = this.keys();
            Map<String, Object> attrs = this.getAttributesInternal();
            for (int i = 0; i < keys.length; ++i) {
                Object attribute = attrs.get(keys[i]);
                if (!(attribute instanceof HttpSessionActivationListener)) continue;
                hasListener = true;
                if (!this.notificationPolicy.isHttpSessionActivationListenerInvocationAllowed(this.clusterStatus, cause, keys[i])) continue;
                if (event == null) {
                    event = new HttpSessionEvent(this.getSession());
                }
                try {
                    ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
                    continue;
                }
                catch (Throwable t) {
                    this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorSessionActivationEvent(t));
                }
            }
            Boolean bl = this.hasActivationListener = hasListener ? Boolean.TRUE : Boolean.FALSE;
        }
        if (cause != ClusteredSessionNotificationCause.PASSIVATION) {
            this.needsPostReplicateActivation = true;
        }
    }

    public void notifyDidActivate(ClusteredSessionNotificationCause cause) {
        if (cause == ClusteredSessionNotificationCause.ACTIVATION) {
            this.needsPostReplicateActivation = true;
        }
        this.fireSessionEvent("activateSession", null);
        if (this.hasActivationListener != Boolean.FALSE) {
            boolean hasListener = false;
            HttpSessionEvent event = null;
            String[] keys = this.keys();
            Map<String, Object> attrs = this.getAttributesInternal();
            for (int i = 0; i < keys.length; ++i) {
                Object attribute = attrs.get(keys[i]);
                if (!(attribute instanceof HttpSessionActivationListener)) continue;
                hasListener = true;
                if (!this.notificationPolicy.isHttpSessionActivationListenerInvocationAllowed(this.clusterStatus, cause, keys[i])) continue;
                if (event == null) {
                    event = new HttpSessionEvent(this.getSession());
                }
                try {
                    ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
                    continue;
                }
                catch (Throwable t) {
                    this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorSessionActivationEvent(t));
                }
            }
            Boolean bl = this.hasActivationListener = hasListener ? Boolean.TRUE : Boolean.FALSE;
        }
        if (cause != ClusteredSessionNotificationCause.ACTIVATION) {
            this.needsPostReplicateActivation = false;
        }
    }

    public boolean getNeedsPostReplicateActivation() {
        return this.needsPostReplicateActivation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "id: " + this.id + " lastAccessedTime: " + this.lastAccessedTime + " version: " + this.version + " lastOutdated: " + this.outdatedTime + ']';
    }

    protected abstract Object setAttributeInternal(String var1, Object var2);

    protected abstract Object removeAttributeInternal(String var1, boolean var2, boolean var3);

    protected abstract O getOutgoingSessionData();

    protected Object getAttributeInternal(String name) {
        Object result = this.getAttributesInternal().get(name);
        if (this.isGetDirty(result)) {
            this.sessionAttributesDirty();
        }
        return result;
    }

    protected void populateAttributes(Map<String, Object> distributedCacheAttributes) {
        Map<String, Object> existing = this.getAttributesInternal();
        Map<String, Object> excluded = this.removeExcludedAttributes(existing);
        existing.clear();
        existing.putAll(distributedCacheAttributes);
        if (excluded != null) {
            existing.putAll(excluded);
        }
    }

    protected final Map<String, Object> getAttributesInternal() {
        return this.attributes;
    }

    protected final ClusteredSessionManager<O> getManagerInternal() {
        return this.manager;
    }

    protected final DistributedCacheManager<O> getDistributedCacheManager() {
        return this.distributedCacheManager;
    }

    protected final void setDistributedCacheManager(DistributedCacheManager<O> distributedCacheManager) {
        this.distributedCacheManager = distributedCacheManager;
    }

    protected boolean canAttributeBeReplicated(Object attribute) {
        if (attribute instanceof Serializable || attribute == null) {
            return true;
        }
        Class<?> clazz = attribute.getClass().getComponentType();
        return clazz != null && clazz.isPrimitive();
    }

    protected final Map<String, Object> removeExcludedAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> excluded = null;
        for (int i = 0; i < excludedAttributes.length; ++i) {
            Object attr = attributes.remove(excludedAttributes[i]);
            if (attr == null) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Excluding attribute %s from replication", (Object)excludedAttributes[i]);
            }
            if (excluded == null) {
                excluded = new HashMap<String, Object>();
            }
            excluded.put(excludedAttributes[i], attr);
        }
        return excluded;
    }

    protected final boolean isGetDirty(Object attribute) {
        boolean result = false;
        switch (this.invalidationPolicy) {
            case SET_AND_GET: {
                result = true;
                break;
            }
            case SET_AND_NON_PRIMITIVE_GET: {
                result = this.isMutable(attribute);
                break;
            }
        }
        return result;
    }

    protected boolean isMutable(Object attribute) {
        return attribute != null && !(attribute instanceof String) && !(attribute instanceof Number) && !(attribute instanceof Character) && !(attribute instanceof Boolean);
    }

    protected void establishDistributedCacheManager() {
        if (this.distributedCacheManager == null) {
            this.distributedCacheManager = this.getManagerInternal().getDistributedCacheManager();
            if (this.distributedCacheManager == null) {
                throw WebMessages.MESSAGES.nullDistributedCacheManager();
            }
        }
    }

    protected final void sessionAttributesDirty() {
        if (!this.sessionAttributesDirty && log.isTraceEnabled()) {
            log.tracef("Marking session attributes dirty %s", (Object)this.id);
        }
        this.sessionAttributesDirty = true;
    }

    protected final void setHasActivationListener(boolean hasListener) {
        this.hasActivationListener = hasListener;
    }

    protected int getVersion() {
        return this.version.get();
    }

    protected long getSessionTimestamp() {
        this.timestamp.set(this.thisAccessedTime);
        return this.timestamp.get();
    }

    protected boolean isSessionMetadataDirty() {
        return this.sessionMetadataDirty;
    }

    protected DistributableSessionMetadata getSessionMetadata() {
        this.metadata.setId(this.id);
        this.metadata.setCreationTime(this.creationTime);
        this.metadata.setMaxInactiveInterval(this.maxInactiveInterval);
        this.metadata.setNew(this.isNew);
        this.metadata.setValid(this.isValid);
        return this.metadata;
    }

    protected boolean isSessionAttributeMapDirty() {
        return this.sessionAttributesDirty || this.isFullReplicationNeeded();
    }

    protected boolean isFullReplicationNeeded() {
        if (this.fullReplicationRequired) {
            return true;
        }
        return this.fullReplicationRequired || this.fullReplicationWindow > 0L && System.currentTimeMillis() < this.fullReplicationWindow;
    }

    private void checkAlwaysReplicateTimestamp() {
        this.alwaysReplicateTimestamp = this.maxUnreplicatedInterval == 0L || this.maxUnreplicatedInterval > 0L && this.maxInactiveInterval >= 0 && this.maxUnreplicatedInterval > (long)(this.maxInactiveInterval * 1000);
    }

    private void parseRealId(String sessionId) {
        String newId = this.manager.parse(sessionId).getKey();
        if (!newId.equals(this.realId)) {
            this.realId = newId;
        }
    }

    private void removeAttributeInternal(String name, boolean localCall, boolean localOnly, boolean notify, ClusteredSessionNotificationCause cause) {
        Context context;
        Object[] lifecycleListeners;
        Object value = this.removeAttributeInternal(name, localCall, localOnly);
        if (!notify || value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener && this.notificationPolicy.isHttpSessionBindingListenerInvocationAllowed(this.clusterStatus, cause, name, localCall)) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if (this.notificationPolicy.isHttpSessionAttributeListenerInvocationAllowed(this.clusterStatus, cause, name, localCall) && (lifecycleListeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) != null) {
            RuntimeException listenerException = null;
            for (int i = 0; i < lifecycleListeners.length; ++i) {
                if (!(lifecycleListeners[i] instanceof HttpSessionAttributeListener)) continue;
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)lifecycleListeners[i];
                try {
                    block12: {
                        this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                        if (event == null) {
                            event = new HttpSessionBindingEvent(this.getSession(), name, value);
                        }
                        try {
                            listener.attributeRemoved(event);
                        }
                        catch (RuntimeException e) {
                            if (listenerException != null) break block12;
                            listenerException = e;
                        }
                    }
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)WebMessages.MESSAGES.errorSessionAttributeEvent(t));
                }
            }
            if (listenerException != null) {
                throw listenerException;
            }
        }
    }

    private String[] keys() {
        Set<String> keySet = this.getAttributesInternal().keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public boolean isValidInternal() {
        return this.isValid || this.expiring;
    }

    private void fireContainerEvent(Context context, String type, Object data) throws Exception {
        if (!"org.apache.catalina.core.StandardContext".equals(context.getClass().getName())) {
            return;
        }
        if (this.containerEventMethod == null) {
            this.containerEventMethod = context.getClass().getMethod("fireContainerEvent", containerEventTypes);
        }
        Object[] containerEventParams = new Object[]{type, data};
        this.containerEventMethod.invoke((Object)context, containerEventParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent event = new SessionEvent((Session)this, type, data);
        SessionListener[] list = new SessionListener[]{};
        List<SessionListener> list2 = this.listeners;
        synchronized (list2) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].sessionEvent(event);
        }
    }

    private void sessionMetadataDirty() {
        if (!this.sessionMetadataDirty && !this.isNew && log.isTraceEnabled()) {
            log.tracef("Marking session metadata dirty %s", (Object)this.id);
        }
        this.sessionMetadataDirty = true;
    }

    private void removeFromManager(boolean localOnly) {
        if (localOnly) {
            this.manager.removeLocal(this);
        } else {
            this.manager.remove(this);
        }
    }

    private void requireFullReplication() {
        this.fullReplicationRequired = true;
        this.fullReplicationWindow = System.currentTimeMillis() + 5000L;
    }
}

