/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class AbstractAddJndiHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String ADD_JNDI = "add-jndi";
    private final ParametersValidator validator = new ParametersValidator();

    protected AbstractAddJndiHandler() {
        this.validator.registerValidator("jndi-binding", (ParameterValidator)new StringLengthValidator(1));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String jndiName = operation.require("jndi-binding").asString();
        ModelNode entries = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get(CommonAttributes.ENTRIES.getName());
        for (ModelNode entry : entries.asList()) {
            if (!jndiName.equals(entry.asString())) continue;
            throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.jndiNameAlreadyRegistered(jndiName)));
        }
        entries.add(jndiName);
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
                    ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
                    if (hqService != null) {
                        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
                        String resourceName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                        String jndiName = operation.require("jndi-binding").asString();
                        AbstractAddJndiHandler.this.addJndiNameToControl(jndiName, resourceName, hqServer, context);
                    }
                    if (!context.hasFailureDescription()) {
                        context.getResult();
                    }
                    if (context.completeStep() != OperationContext.ResultAction.KEEP) {
                        // empty if block
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public void registerOperation(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(ADD_JNDI, (OperationStepHandler)this, (DescriptionProvider)this);
    }

    protected abstract void addJndiNameToControl(String var1, String var2, HornetQServer var3, OperationContext var4);
}

