/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Arrays;
import java.util.List;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSTopicReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSTopicReadAttributeHandler INSTANCE = new JMSTopicReadAttributeHandler();
    public static final List<String> METRICS = Arrays.asList("message-count", "delivering-count", "messages-added", "durable-message-count", "non-durable-message-count", "subscription-count", "durable-subscription-count", "non-durable-subscription-count");
    public static final List<String> READ_ATTRIBUTES = Arrays.asList("topic-address", "temporary");
    private ParametersValidator validator = new ParametersValidator();

    private JMSTopicReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        String topicName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        TopicControl control = (TopicControl)TopicControl.class.cast(hqServer.getManagementService().getResource("jms.topic." + topicName));
        if (control == null) {
            ManagementUtil.rollbackOperationWithNoHandler(context, operation);
            return;
        }
        if ("message-count".equals(attributeName)) {
            try {
                context.getResult().set(control.getMessageCount());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if ("delivering-count".equals(attributeName)) {
            context.getResult().set(control.getDeliveringCount());
        } else if ("messages-added".equals(attributeName)) {
            context.getResult().set(control.getMessagesAdded());
        } else if ("durable-message-count".equals(attributeName)) {
            context.getResult().set(control.getDurableMessageCount());
        } else if ("non-durable-message-count".equals(attributeName)) {
            context.getResult().set(control.getNonDurableMessageCount());
        } else if ("subscription-count".equals(attributeName)) {
            context.getResult().set(control.getSubscriptionCount());
        } else if ("durable-subscription-count".equals(attributeName)) {
            context.getResult().set(control.getDurableSubscriptionCount());
        } else if ("non-durable-subscription-count".equals(attributeName)) {
            context.getResult().set(control.getNonDurableSubscriptionCount());
        } else if ("topic-address".equals(attributeName)) {
            context.getResult().set(control.getAddress());
        } else if ("temporary".equals(attributeName)) {
            context.getResult().set(control.isTemporary());
        } else if (METRICS.contains(attributeName) || READ_ATTRIBUTES.contains(attributeName)) {
            throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
        }
        context.completeStep();
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (String attr : READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String metric : METRICS) {
            registration.registerMetric(metric, (OperationStepHandler)this);
        }
    }
}

