/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.tcp.ChannelIdParser;
import org.apache.cxf.binding.soap.tcp.SoapTcpUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrame;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameContentDescription;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameHeader;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.MessageObserver;

public class SoapTcpOutputStream
extends AbstractThresholdOutputStream {
    public static final int CHUNK_SIZE = 4096;
    private int channelId;
    private OutputStream outStream;
    private InputStream inStream;
    private boolean messageSent = false;
    private Message outMessage;
    private int chunkSize;
    private MessageObserver incomingObserver;

    public SoapTcpOutputStream(InputStream inStream, OutputStream outStream, Message message, String targetWsURI, MessageObserver incomingObserver) {
        this(inStream, outStream, message, targetWsURI, incomingObserver, 4096);
    }

    public SoapTcpOutputStream(InputStream inStream, OutputStream outStream, Message message, String targetWsURI, MessageObserver incomingObserver, int chunkSize) {
        super(chunkSize);
        this.inStream = inStream;
        this.outStream = outStream;
        this.outMessage = message;
        this.wrappedStream = null;
        this.chunkSize = chunkSize;
        this.incomingObserver = incomingObserver;
        ArrayList<String> mimeTypes = new ArrayList<String>();
        SoapMessage m = (SoapMessage)message;
        mimeTypes.add(m.getVersion().getContentType());
        ArrayList<String> supportedParams = new ArrayList<String>();
        supportedParams.add("charset");
        if (m.getVersion() == Soap11.getInstance()) {
            supportedParams.add("SOAPAction");
        } else {
            supportedParams.add("action");
        }
        try {
            this.channelId = this.openChannel(targetWsURI, mimeTypes, supportedParams);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int openChannel(String targetWsURI, List<String> supportedMimeTypes, List<String> supportedParams) throws IOException {
        String openChannelMsg = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><openChannel xmlns=\"http://servicechannel.tcp.transport.ws.xml.sun.com/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
        openChannelMsg = openChannelMsg + "<targetWSURI xmlns=\"\">" + targetWsURI + "</targetWSURI>";
        for (String mimeType : supportedMimeTypes) {
            openChannelMsg = openChannelMsg + "<negotiatedMimeTypes xmlns=\"\">" + mimeType + "</negotiatedMimeTypes>";
        }
        for (String param : supportedParams) {
            openChannelMsg = openChannelMsg + "<negotiatedParams xmlns=\"\">" + param + "</negotiatedParams>";
        }
        openChannelMsg = openChannelMsg + "</openChannel></s:Body></s:Envelope>";
        SoapTcpFrameContentDescription contentDesc = new SoapTcpFrameContentDescription();
        contentDesc.setContentId(0);
        Hashtable<Integer, String> parameters = new Hashtable<Integer, String>();
        parameters.put(0, "utf-8");
        contentDesc.setParameters(parameters);
        SoapTcpFrameHeader header = new SoapTcpFrameHeader(0, contentDesc);
        SoapTcpFrame frame = new SoapTcpFrame();
        frame.setHeader(header);
        frame.setChannelId(0);
        try {
            frame.setPayload(openChannelMsg.getBytes("UTF-8"));
            SoapTcpUtils.writeMessageFrame(this.outStream, frame);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        SoapTcpFrame response = SoapTcpUtils.readMessageFrame(this.inStream);
        if (!SoapTcpUtils.checkSingleFrameResponse(response, "openChannelResponse")) {
            throw new IOException("Couldn't open new channel.");
        }
        return this.getChannelIdFromResponse(response);
    }

    private int getChannelIdFromResponse(SoapTcpFrame frame) {
        return ChannelIdParser.getChannelId(new ByteArrayInputStream(frame.getPayload()));
    }

    public void thresholdNotReached() throws IOException {
        if (this.messageSent) {
            SoapTcpFrameHeader header = new SoapTcpFrameHeader(3, null);
            header.setChannelId(this.channelId);
            SoapTcpFrame frame = new SoapTcpFrame();
            frame.setChannelId(this.channelId);
            frame.setHeader(header);
            frame.setPayload(this.buffer.toByteArray());
            SoapTcpUtils.writeMessageFrame(this.outStream, frame);
        } else {
            SoapTcpFrameContentDescription contentDesc = new SoapTcpFrameContentDescription();
            contentDesc.setContentId(0);
            Hashtable<Integer, String> parameters = new Hashtable<Integer, String>();
            parameters.put(0, "utf-8");
            contentDesc.setParameters(parameters);
            SoapTcpFrameHeader header = new SoapTcpFrameHeader(0, contentDesc);
            header.setChannelId(this.channelId);
            SoapTcpFrame frame = new SoapTcpFrame();
            frame.setHeader(header);
            frame.setChannelId(this.channelId);
            frame.setPayload(this.buffer.toByteArray());
            SoapTcpUtils.writeMessageFrame(this.outStream, frame);
            this.messageSent = true;
        }
    }

    public void thresholdReached() throws IOException {
        if (this.messageSent) {
            SoapTcpFrameHeader header = new SoapTcpFrameHeader(2, null);
            header.setChannelId(this.channelId);
            SoapTcpFrame frame = new SoapTcpFrame();
            frame.setChannelId(this.channelId);
            frame.setHeader(header);
            frame.setPayload(this.buffer.toByteArray());
            SoapTcpUtils.writeMessageFrame(this.outStream, frame);
        } else {
            SoapTcpFrameContentDescription contentDesc = new SoapTcpFrameContentDescription();
            contentDesc.setContentId(0);
            Hashtable<Integer, String> parameters = new Hashtable<Integer, String>();
            parameters.put(0, "utf-8");
            contentDesc.setParameters(parameters);
            SoapTcpFrameHeader header = new SoapTcpFrameHeader(1, contentDesc);
            header.setChannelId(this.channelId);
            SoapTcpFrame frame = new SoapTcpFrame();
            frame.setHeader(header);
            frame.setChannelId(this.channelId);
            frame.setPayload(this.buffer.toByteArray());
            SoapTcpUtils.writeMessageFrame(this.outStream, frame);
            this.messageSent = true;
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.messageSent) {
            InputStream inputStream = this.getResponse();
            Exchange exchange = this.outMessage.getExchange();
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            inMessage.setContent(InputStream.class, (Object)inputStream);
            this.incomingObserver.onMessage((Message)inMessage);
        }
    }

    protected void onFirstWrite() throws IOException {
    }

    private InputStream getResponse() {
        SoapTcpFrame responseMessage = null;
        try {
            responseMessage = SoapTcpUtils.readMessageFrame(this.inStream);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (responseMessage != null) {
            int frameType = responseMessage.getHeader().getFrameType();
            if (frameType == 0 || frameType == 4 || frameType == 5) {
                return new ByteArrayInputStream(responseMessage.getPayload());
            }
            if (frameType == 1) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4 * this.chunkSize);
                try {
                    baos.write(responseMessage.getPayload());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                while (frameType != 3) {
                    try {
                        SoapTcpFrame frame = SoapTcpUtils.readMessageFrame(this.inStream);
                        baos.write(frame.getPayload());
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }
        return null;
    }
}

