/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.CreateSequenceType;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.TerminateSequenceType;
import org.apache.cxf.ws.rm.WrappedEndpoint;
import org.apache.cxf.ws.rm.WrappedService;
import org.apache.cxf.ws.rm.manager.SequenceTerminationPolicyType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

public class RMEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(RMEndpoint.class);
    private static final QName SERVICE_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractService");
    private static final QName INTERFACE_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractPortType");
    private static final QName BINDING_NAME = new QName(RMConstants.getWsdlNamespace(), "SequenceAbstractSoapBinding");
    private static final QName CREATE_PART_NAME = new QName(RMConstants.getWsdlNamespace(), "create");
    private static final QName CREATE_RESPONSE_PART_NAME = new QName(RMConstants.getWsdlNamespace(), "createResponse");
    private static final QName TERMINATE_PART_NAME = new QName(RMConstants.getWsdlNamespace(), "terminate");
    private static Schema rmSchema;
    private RMManager manager;
    private Endpoint applicationEndpoint;
    private Conduit conduit;
    private EndpointReferenceType replyTo;
    private Source source;
    private Destination destination;
    private WrappedService service;
    private Endpoint endpoint;
    private Proxy proxy;
    private Servant servant;
    private long lastApplicationMessage;
    private long lastControlMessage;

    public RMEndpoint(RMManager m, Endpoint ae) {
        this.manager = m;
        this.applicationEndpoint = ae;
        this.source = new Source(this);
        this.destination = new Destination(this);
        this.proxy = new Proxy(this);
        this.servant = new Servant(this);
    }

    public RMManager getManager() {
        return this.manager;
    }

    public Endpoint getApplicationEndpoint() {
        return this.applicationEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Service getService() {
        return this.service;
    }

    public BindingInfo getBindingInfo() {
        return this.service.getServiceInfo().getBinding(BINDING_NAME);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Servant getServant() {
        return this.servant;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public long getLastApplicationMessage() {
        return this.lastApplicationMessage;
    }

    public void receivedApplicationMessage() {
        this.lastApplicationMessage = System.currentTimeMillis();
    }

    public long getLastControlMessage() {
        return this.lastControlMessage;
    }

    public void receivedControlMessage() {
        this.lastControlMessage = System.currentTimeMillis();
    }

    public Conduit getConduit() {
        return this.conduit;
    }

    EndpointReferenceType getReplyTo() {
        return this.replyTo;
    }

    void initialise(Conduit c, EndpointReferenceType r, org.apache.cxf.transport.Destination d) {
        this.conduit = c;
        this.replyTo = r;
        this.createService();
        this.createEndpoint(d);
        this.setPolicies();
    }

    void createService() {
        ServiceInfo si = new ServiceInfo();
        si.setProperty(Schema.class.getName(), (Object)RMEndpoint.getSchema());
        si.setName(SERVICE_NAME);
        this.buildInterfaceInfo(si);
        this.service = new WrappedService(this.applicationEndpoint.getService(), SERVICE_NAME, si);
        JAXBDataBinding dataBinding = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)PackageUtils.getPackageName(CreateSequenceType.class), (ClassLoader)CreateSequenceType.class.getClassLoader());
            dataBinding = new JAXBDataBinding(ctx);
        }
        catch (JAXBException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        this.service.setDataBinding((DataBinding)dataBinding);
        this.service.setInvoker(this.servant);
    }

    private static synchronized Schema getSchema() {
        if (rmSchema == null) {
            try {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource ad = new StreamSource(RMEndpoint.class.getResource("/schemas/wsdl/addressing.xsd").openStream(), "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                StreamSource rm = new StreamSource(RMEndpoint.class.getResource("/schemas/wsdl/wsrm.xsd").openStream());
                javax.xml.transform.Source[] schemas = new javax.xml.transform.Source[]{ad, rm};
                rmSchema = factory.newSchema(schemas);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rmSchema;
    }

    void createEndpoint(org.apache.cxf.transport.Destination d) {
        ServiceInfo si = this.service.getServiceInfo();
        this.buildBindingInfo(si);
        EndpointInfo aei = this.applicationEndpoint.getEndpointInfo();
        String transportId = aei.getTransportId();
        EndpointInfo ei = new EndpointInfo(si, transportId);
        if (d != null) {
            ei.setProperty(MAPAggregator.DECOUPLED_DESTINATION, (Object)d);
        }
        ei.setAddress(aei.getAddress());
        ei.setName(RMConstants.getPortName());
        ei.setBinding(si.getBinding(BINDING_NAME));
        Object ua = this.getUsingAddressing(aei);
        if (null != ua) {
            ei.addExtensor(ua);
        }
        si.addEndpoint(ei);
        this.endpoint = new WrappedEndpoint(this.applicationEndpoint, ei, this.service);
        this.service.setEndpoint(this.endpoint);
    }

    void setPolicies() {
        EndpointPolicy ep;
        PolicyEngine engine = (PolicyEngine)this.manager.getBus().getExtension(PolicyEngine.class);
        if (null == engine || !engine.isEnabled()) {
            return;
        }
        EndpointInfo ei = this.getEndpoint().getEndpointInfo();
        PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)this.manager.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        EndpointPolicy endpointPolicy = ep = null == this.conduit ? engine.getServerEndpointPolicy(this.applicationEndpoint.getEndpointInfo(), null) : engine.getClientEndpointPolicy(this.applicationEndpoint.getEndpointInfo(), this.conduit);
        if (this.conduit != null) {
            engine.setClientEndpointPolicy(ei, ep);
        } else {
            engine.setServerEndpointPolicy(ei, ep);
        }
        EffectivePolicyImpl effectiveOutbound = new EffectivePolicyImpl(ep, reg, true, false);
        EffectivePolicyImpl effectiveInbound = new EffectivePolicyImpl(ep, reg, false, false);
        BindingInfo bi = ei.getBinding();
        Collection bois = bi.getOperations();
        for (BindingOperationInfo boi : bois) {
            engine.setEffectiveServerRequestPolicy(ei, boi, (EffectivePolicy)effectiveInbound);
            engine.setEffectiveServerResponsePolicy(ei, boi, (EffectivePolicy)effectiveOutbound);
            engine.setEffectiveClientRequestPolicy(ei, boi, (EffectivePolicy)effectiveOutbound);
            engine.setEffectiveClientResponsePolicy(ei, boi, (EffectivePolicy)effectiveInbound);
        }
    }

    void buildInterfaceInfo(ServiceInfo si) {
        InterfaceInfo ii = new InterfaceInfo(si, INTERFACE_NAME);
        this.buildOperationInfo(ii);
    }

    void buildOperationInfo(InterfaceInfo ii) {
        this.buildCreateSequenceOperationInfo(ii);
        this.buildTerminateSequenceOperationInfo(ii);
        this.buildSequenceAckOperationInfo(ii);
        this.buildLastMessageOperationInfo(ii);
        this.buildAckRequestedOperationInfo(ii);
    }

    void buildCreateSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessagePartInfo partInfo = null;
        MessageInfo messageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getCreateSequenceOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceType.class);
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceResponseOperationName(), MessageInfo.Type.OUTPUT);
        operationInfo.setOutput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceResponseOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceResponseType.class);
        partInfo.setIndex(0);
        operationInfo = ii.addOperation(RMConstants.getCreateSequenceOnewayOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceType.class);
        operationInfo = ii.addOperation(RMConstants.getCreateSequenceResponseOnewayOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getCreateSequenceResponseOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(CREATE_RESPONSE_PART_NAME);
        partInfo.setElementQName(RMConstants.getCreateSequenceResponseOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(CreateSequenceResponseType.class);
    }

    void buildTerminateSequenceOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessagePartInfo partInfo = null;
        MessageInfo messageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getTerminateSequenceOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getTerminateSequenceOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
        partInfo = messageInfo.addMessagePart(TERMINATE_PART_NAME);
        partInfo.setElementQName(RMConstants.getTerminateSequenceOperationName());
        partInfo.setElement(true);
        partInfo.setTypeClass(TerminateSequenceType.class);
    }

    void buildSequenceAckOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessageInfo messageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getSequenceAckOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getSequenceAckOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
    }

    void buildLastMessageOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessageInfo messageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getLastMessageOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getLastMessageOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
    }

    void buildAckRequestedOperationInfo(InterfaceInfo ii) {
        OperationInfo operationInfo = null;
        MessageInfo messageInfo = null;
        operationInfo = ii.addOperation(RMConstants.getAckRequestedOperationName());
        messageInfo = operationInfo.createMessage(RMConstants.getAckRequestedOperationName(), MessageInfo.Type.INPUT);
        operationInfo.setInput(messageInfo.getName().getLocalPart(), messageInfo);
    }

    void buildBindingInfo(ServiceInfo si) {
        if (null != this.applicationEndpoint) {
            SoapBindingInfo sbi = (SoapBindingInfo)this.applicationEndpoint.getEndpointInfo().getBinding();
            SoapVersion sv = sbi.getSoapVersion();
            String bindingId = sbi.getBindingId();
            SoapBindingInfo bi = new SoapBindingInfo(si, bindingId, sv);
            bi.setName(BINDING_NAME);
            BindingOperationInfo boi = null;
            boi = bi.buildOperation(RMConstants.getCreateSequenceOperationName(), RMConstants.getCreateSequenceOperationName().getLocalPart(), null);
            this.addAction(boi, RMConstants.getCreateSequenceAction(), RMConstants.getCreateSequenceResponseAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getTerminateSequenceOperationName(), RMConstants.getTerminateSequenceOperationName().getLocalPart(), null);
            this.addAction(boi, RMConstants.getTerminateSequenceAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getSequenceAckOperationName(), null, null);
            this.addAction(boi, RMConstants.getSequenceAckAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getLastMessageOperationName(), null, null);
            this.addAction(boi, RMConstants.getLastMessageAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getAckRequestedOperationName(), null, null);
            this.addAction(boi, RMConstants.getAckRequestedAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getCreateSequenceOnewayOperationName(), RMConstants.getCreateSequenceOperationName().getLocalPart(), null);
            this.addAction(boi, RMConstants.getCreateSequenceAction());
            bi.addOperation(boi);
            boi = bi.buildOperation(RMConstants.getCreateSequenceResponseOnewayOperationName(), RMConstants.getCreateSequenceResponseOperationName().getLocalPart(), null);
            this.addAction(boi, RMConstants.getCreateSequenceResponseAction());
            bi.addOperation(boi);
            si.addBinding((BindingInfo)bi);
        }
    }

    private void addAction(BindingOperationInfo boi, String action) {
        this.addAction(boi, action, action);
    }

    private void addAction(BindingOperationInfo boi, String action, String outputAction) {
        SoapOperationInfo soi = new SoapOperationInfo();
        soi.setAction(action);
        boi.addExtensor((Object)soi);
        MessageInfo info = boi.getOperationInfo().getInput();
        info.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, (Object)action);
        info = boi.getOperationInfo().getOutput();
        if (info != null) {
            info.addExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME, (Object)outputAction);
        }
    }

    Object getUsingAddressing(EndpointInfo endpointInfo) {
        if (null == endpointInfo) {
            return null;
        }
        Object ua = null;
        List exts = endpointInfo.getExtensors(ExtensibilityElement.class);
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        exts = endpointInfo.getBinding() != null ? endpointInfo.getBinding().getExtensors(ExtensibilityElement.class) : null;
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        exts = endpointInfo.getService() != null ? endpointInfo.getService().getExtensors(ExtensibilityElement.class) : null;
        ua = this.getUsingAddressing(exts);
        if (null != ua) {
            return ua;
        }
        return ua;
    }

    Object getUsingAddressing(List<ExtensibilityElement> exts) {
        ExtensibilityElement ua = null;
        if (exts != null) {
            for (ExtensibilityElement ext : exts) {
                if (!Names.WSAW_USING_ADDRESSING_QNAME.equals(ext.getElementType())) continue;
                ua = ext;
            }
        }
        return ua;
    }

    void setAplicationEndpoint(Endpoint ae) {
        this.applicationEndpoint = ae;
    }

    void setManager(RMManager m) {
        this.manager = m;
    }

    void shutdown() {
        for (DestinationSequence ds : this.getDestination().getAllSequences()) {
            ds.cancelDeferredAcknowledgments();
            ds.cancelTermination();
        }
        SourcePolicyType sp = this.manager.getSourcePolicy();
        SequenceTerminationPolicyType stp = null;
        if (null != sp) {
            stp = sp.getSequenceTerminationPolicy();
        }
        if (null != stp && stp.isTerminateOnShutdown()) {
            Collection<SourceSequence> seqs = this.source.getAllUnacknowledgedSequences();
            LOG.log(Level.FINE, "Trying to terminate {0} sequences", seqs.size());
            for (SourceSequence seq : seqs) {
                try {
                    if (seq.isLastMessage()) continue;
                    this.getProxy().lastMessage(seq);
                }
                catch (RMException ex) {}
            }
        }
        for (SourceSequence ss : this.getSource().getAllSequences()) {
            this.manager.getRetransmissionQueue().stop(ss);
        }
    }

    class EffectivePolicyImpl
    implements EffectivePolicy {
        private EndpointPolicy endpointPolicy;
        private List<Interceptor<? extends Message>> interceptors;

        EffectivePolicyImpl(EndpointPolicy ep, PolicyInterceptorProviderRegistry reg, boolean outbound, boolean fault) {
            this.endpointPolicy = ep;
            this.interceptors = reg.getInterceptors(this.endpointPolicy.getChosenAlternative(), outbound, fault);
        }

        public Collection<Assertion> getChosenAlternative() {
            return this.endpointPolicy.getChosenAlternative();
        }

        public List<Interceptor<? extends Message>> getInterceptors() {
            return this.interceptors;
        }

        public Policy getPolicy() {
            return this.endpointPolicy.getPolicy();
        }
    }
}

