/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.policy;

import java.util.Collection;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.policy.RMAssertion;

public final class PolicyUtils {
    private PolicyUtils() {
    }

    public static RMAssertion getRMAssertion(RMAssertion defaultValue, Message message) {
        Collection ais;
        RMAssertion compatible = defaultValue;
        AssertionInfoMap amap = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null != amap && null != (ais = (Collection)amap.get((Object)RMConstants.getRMAssertionQName()))) {
            for (AssertionInfo ai : ais) {
                JaxbAssertion<RMAssertion> ja = PolicyUtils.getAssertion(ai);
                RMAssertion rma = (RMAssertion)ja.getData();
                compatible = null == defaultValue ? rma : PolicyUtils.intersect(compatible, rma);
            }
        }
        return compatible;
    }

    public static RMAssertion intersect(RMAssertion a, RMAssertion b) {
        if (PolicyUtils.equals(a, b)) {
            return a;
        }
        RMAssertion compatible = new RMAssertion();
        Long aval = null;
        if (null != a.getInactivityTimeout()) {
            aval = a.getInactivityTimeout().getMilliseconds();
        }
        Long bval = null;
        if (null != b.getInactivityTimeout()) {
            bval = b.getInactivityTimeout().getMilliseconds();
        }
        if (null != aval || null != bval) {
            RMAssertion.InactivityTimeout ia = new RMAssertion.InactivityTimeout();
            if (null != aval && null != bval) {
                ia.setMilliseconds(bval);
            } else {
                ia.setMilliseconds(aval != null ? aval : bval);
            }
            compatible.setInactivityTimeout(ia);
        }
        aval = null;
        if (null != a.getBaseRetransmissionInterval()) {
            aval = a.getBaseRetransmissionInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getBaseRetransmissionInterval()) {
            bval = b.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (null != aval || null != bval) {
            RMAssertion.BaseRetransmissionInterval bri = new RMAssertion.BaseRetransmissionInterval();
            if (null != aval && null != bval) {
                bri.setMilliseconds(bval);
            } else {
                bri.setMilliseconds(aval != null ? aval : bval);
            }
            compatible.setBaseRetransmissionInterval(bri);
        }
        aval = null;
        if (null != a.getAcknowledgementInterval()) {
            aval = a.getAcknowledgementInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getAcknowledgementInterval()) {
            bval = b.getAcknowledgementInterval().getMilliseconds();
        }
        if (null != aval || null != bval) {
            RMAssertion.AcknowledgementInterval ai = new RMAssertion.AcknowledgementInterval();
            if (null != aval && null != bval) {
                ai.setMilliseconds(bval);
            } else {
                ai.setMilliseconds(aval != null ? aval : bval);
            }
            compatible.setAcknowledgementInterval(ai);
        }
        if (null != a.getExponentialBackoff() || null != b.getExponentialBackoff()) {
            compatible.setExponentialBackoff(new RMAssertion.ExponentialBackoff());
        }
        return compatible;
    }

    public static boolean equals(RMAssertion a, RMAssertion b) {
        if (a == b) {
            return true;
        }
        Long aval = null;
        if (null != a.getInactivityTimeout()) {
            aval = a.getInactivityTimeout().getMilliseconds();
        }
        Long bval = null;
        if (null != b.getInactivityTimeout()) {
            bval = b.getInactivityTimeout().getMilliseconds();
        }
        if (!PolicyUtils.equals(aval, bval)) {
            return false;
        }
        aval = null;
        if (null != a.getBaseRetransmissionInterval()) {
            aval = a.getBaseRetransmissionInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getBaseRetransmissionInterval()) {
            bval = b.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (!PolicyUtils.equals(aval, bval)) {
            return false;
        }
        aval = null;
        if (null != a.getAcknowledgementInterval()) {
            aval = a.getAcknowledgementInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getAcknowledgementInterval()) {
            bval = b.getAcknowledgementInterval().getMilliseconds();
        }
        if (!PolicyUtils.equals(aval, bval)) {
            return false;
        }
        return null == a.getExponentialBackoff() ? null == b.getExponentialBackoff() : null != b.getExponentialBackoff();
    }

    private static boolean equals(Long aval, Long bval) {
        if (null != aval) {
            if (null != bval) {
                return aval.equals(bval);
            }
            return false;
        }
        return null == bval;
    }

    private static JaxbAssertion<RMAssertion> getAssertion(AssertionInfo ai) {
        return (JaxbAssertion)ai.getAssertion();
    }
}

