/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.GenericFacesPortlet;
import javax.servlet.ServletContext;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class GenericPortletTestBase {
    static final String FOO = "foo";
    @Mock
    protected ServletContext servletContext;
    @Mock
    protected PortletConfig portletConfig;
    @Mock
    protected PortletContext portletContext;
    protected GenericFacesPortlet facesPortlet;
    protected Collection<String> portletInitParameters = new ArrayList<String>();
    protected Collection<String> contextInitParameters = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.portletConfig.getInitParameterNames()).thenAnswer(this.enumerationAnswer(this.portletInitParameters));
        Mockito.when((Object)this.portletContext.getInitParameterNames()).thenAnswer(this.enumerationAnswer(this.contextInitParameters));
        Mockito.when((Object)this.portletConfig.getPortletContext()).thenReturn((Object)this.portletContext);
        Mockito.when((Object)this.portletConfig.getPortletName()).thenReturn((Object)FOO);
        this.facesPortlet = (GenericFacesPortlet)Mockito.spy((Object)new GenericFacesPortlet());
        Mockito.when((Object)this.portletContext.getInitParameter("javax.portlet.faces.BridgeClassName")).thenReturn((Object)Bridge.class.getName());
    }

    private Answer<Enumeration<String>> enumerationAnswer(final Collection<String> collection) {
        return new Answer<Enumeration<String>>(){

            public Enumeration<String> answer(InvocationOnMock invocation) throws Throwable {
                return Collections.enumeration(collection);
            }
        };
    }

    @After
    public void tearDown() throws Exception {
    }

    protected GenericFacesPortlet createGenericPortlet() {
        return this.facesPortlet;
    }
}

