/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.util.Arrays;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.faces.GenericFacesPortlet;
import javax.portlet.faces.GenericPortletTestBase;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class PortletInitTest
extends GenericPortletTestBase {
    @Test
    public void preseveActionParams() throws Exception {
        this.whenPortletInitParameter("javax.portlet.faces.preserveActionParams", "true");
        this.initPortlet();
        this.verifyContextAttribute("javax.portlet.faces.foo.preserveActionParams", Boolean.TRUE);
    }

    @Test
    public void excludedRequestAttreibutes() throws Exception {
        this.whenPortletInitParameter("javax.portlet.faces.excludedRequestAttributes", "bar,baz,boo");
        this.initPortlet();
        this.verifyContextAttribute("javax.portlet.faces.foo.excludedRequestAttributes", Arrays.asList("bar", "baz", "boo"));
    }

    @Test
    public void customAttribute() throws Exception {
        this.whenPortletInitParameter("javax.portlet.faces.extension.my_package.my_attribute", "xxx");
        this.initPortlet();
        this.verifyContextAttribute("javax.portlet.faces.extension.my_package.foo.my_attribute", "xxx");
    }

    private void initPortlet() throws PortletException {
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init(this.portletConfig);
    }

    private void whenPortletInitParameter(String name, String value) {
        Mockito.when((Object)this.portletConfig.getInitParameter(name)).thenReturn((Object)value);
        this.portletInitParameters.add(name);
    }

    private void verifyContextAttribute(String name, Object value) {
        ((PortletContext)Mockito.verify((Object)this.portletContext, (VerificationMode)Mockito.atLeastOnce())).setAttribute(name, value);
    }
}

