/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleInstallHandler;
import org.jboss.osgi.framework.FutureServiceValue;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

abstract class AbstractBundleContext
implements BundleContext {
    private final AbstractBundleState bundleState;
    private boolean destroyed;

    AbstractBundleContext(AbstractBundleState bundleState) {
        assert (bundleState != null) : "Null bundleState";
        this.bundleState = bundleState;
    }

    static AbstractBundleContext assertBundleContext(BundleContext context) {
        assert (context != null) : "Null context";
        assert (context instanceof AbstractBundleContext) : "Not an AbstractBundleContext: " + context;
        return (AbstractBundleContext)context;
    }

    void destroy() {
        this.destroyed = true;
    }

    AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.bundleState.getBundleManager();
    }

    FrameworkState getFrameworkState() {
        return this.bundleState.getFrameworkState();
    }

    public String getProperty(String key) {
        this.checkValidBundleContext();
        this.getBundleManager().assertFrameworkCreated();
        Object value = this.getBundleManager().getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    public Bundle getBundle() {
        this.checkValidBundleContext();
        return this.bundleState;
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundleInternal(location, null);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.installBundleInternal(location, input);
    }

    private Bundle installBundleInternal(String location, InputStream input) throws BundleException {
        this.checkValidBundleContext();
        VirtualFile rootFile = null;
        FrameworkState frameworkState = this.getFrameworkState();
        try {
            if (input != null) {
                try {
                    rootFile = AbstractVFS.toVirtualFile((InputStream)input);
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.bundleCannotObtainVirtualFile(ex);
                }
            }
            if (rootFile == null) {
                try {
                    URL url = new URL(location);
                    rootFile = AbstractVFS.toVirtualFile((InputStream)url.openStream());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (rootFile == null) {
                try {
                    File file = new File(location);
                    if (file.exists()) {
                        rootFile = AbstractVFS.toVirtualFile((URI)file.toURI());
                    }
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.bundleCannotObtainVirtualFileForLocation(ex, location);
                }
            }
            if (rootFile == null) {
                throw FrameworkMessages.MESSAGES.bundleCannotObtainVirtualFileForLocation(null, location);
            }
            DeploymentFactoryPlugin deploymentPlugin = frameworkState.getDeploymentFactoryPlugin();
            Deployment dep = deploymentPlugin.createDeployment(location, rootFile);
            return this.installBundle(dep);
        }
        catch (RuntimeException rte) {
            VFSUtils.safeClose(rootFile);
            throw rte;
        }
        catch (BundleException ex) {
            VFSUtils.safeClose(rootFile);
            throw ex;
        }
    }

    Bundle installBundle(Deployment deployment) throws BundleException {
        this.checkValidBundleContext();
        FrameworkState frameworkState = this.getFrameworkState();
        BundleManagerPlugin bundleManager = frameworkState.getBundleManager();
        String location = deployment.getLocation();
        BundleInstallHandler installHandler = frameworkState.getCoreServices().getInstallHandler();
        installHandler.installBundle(deployment);
        ServiceName serviceName = (ServiceName)deployment.getAttachment(ServiceName.class);
        if (serviceName == null) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotObtainPaths(deployment);
        }
        ServiceContainer serviceContainer = bundleManager.getServiceContainer();
        ServiceController controller = serviceContainer.getService(serviceName);
        FutureServiceValue future = new FutureServiceValue(controller);
        try {
            UserBundleState userBundle = (UserBundleState)future.get(5L, TimeUnit.SECONDS);
            return userBundle;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw FrameworkMessages.MESSAGES.bundleCannotInstallBundleForLocation(ex, location);
        }
    }

    public Bundle getBundle(long id) {
        this.checkValidBundleContext();
        return this.getBundleManager().getBundleById(id);
    }

    public Bundle[] getBundles() {
        this.checkValidBundleContext();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (Bundle bundle2 : this.getBundleManager().getBundles()) {
            result.add(bundle2);
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addServiceListener(this.bundleState, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        try {
            this.getFrameworkEventsPlugin().addServiceListener(this.bundleState, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeServiceListener(this.bundleState, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addBundleListener(this.bundleState, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeBundleListener(this.bundleState, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addFrameworkListener(this.bundleState, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeFrameworkListener(this.bundleState, listener);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] classNames, Object service, Dictionary properties) {
        if (classNames == null || classNames.length == 0) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("classNames");
        }
        if (service == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("service");
        }
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.registerService(this.bundleState, classNames, service, properties);
        return serviceState.getRegistration();
    }

    public ServiceReference getServiceReference(String className) {
        if (className == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("className");
        }
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.getServiceReference(this.bundleState, className);
        return serviceState != null ? new ServiceReferenceWrapper(serviceState) : null;
    }

    public ServiceReference[] getServiceReferences(String className, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState> srefs = serviceManager.getServiceReferences(this.bundleState, className, filter, true);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public ServiceReference[] getAllServiceReferences(String className, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState> srefs = serviceManager.getServiceReferences(this.bundleState, className, filter, false);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public Object getService(ServiceReference sref) {
        if (sref == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("sref");
        }
        this.checkValidBundleContext();
        ServiceState serviceState = ServiceState.assertServiceState(sref);
        ServiceManagerPlugin serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        Object service = serviceManager.getService(this.bundleState, serviceState);
        return service;
    }

    public boolean ungetService(ServiceReference sref) {
        if (sref == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("sref");
        }
        this.checkValidBundleContext();
        ServiceState serviceState = ServiceState.assertServiceState(sref);
        return this.getServiceManager().ungetService(this.bundleState, serviceState);
    }

    public File getDataFile(String filename) {
        this.checkValidBundleContext();
        BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
        return storagePlugin.getDataFile(this.bundleState.getBundleId(), filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return FrameworkUtil.createFilter((String)filter);
    }

    void checkValidBundleContext() {
        if (this.destroyed) {
            throw FrameworkMessages.MESSAGES.illegalStateInvalidBundleContext(this.bundleState);
        }
    }

    private ServiceManagerPlugin getServiceManager() {
        return this.getFrameworkState().getServiceManagerPlugin();
    }

    private FrameworkEventsPlugin getFrameworkEventsPlugin() {
        return this.getFrameworkState().getFrameworkEventsPlugin();
    }

    public String toString() {
        return "BundleContext[" + this.bundleState + "]";
    }
}

