/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.osgi.service.resolver.ResolutionException;

public final class FrameworkActive
extends AbstractFrameworkService {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();

    static void addService(ServiceTarget serviceTarget, ServiceController.Mode initialMode) {
        FrameworkActive service = new FrameworkActive();
        ServiceBuilder builder = serviceTarget.addService(Services.FRAMEWORK_ACTIVE, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_INIT, FrameworkState.class, service.injectedFramework);
        builder.setInitialMode(initialMode);
        builder.install();
    }

    private FrameworkActive() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            ResolverPlugin resolverPlugin = this.getValue().getResolverPlugin();
            SystemBundleRevision sysrev = this.getSystemBundle().getCurrentBundleRevision();
            resolverPlugin.resolveAndApply(Collections.singleton(sysrev), null);
            this.getSystemBundle().changeState(32);
            StartLevelPlugin startLevelPlugin = this.getValue().getCoreServices().getStartLevel();
            startLevelPlugin.increaseStartLevel(this.getBeginningStartLevel());
            BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
            bundleManager.injectedFrameworkActive.inject((Object)Boolean.TRUE);
            FrameworkEventsPlugin eventsPlugin = this.getValue().getFrameworkEventsPlugin();
            eventsPlugin.fireFrameworkEvent(this.getSystemBundle(), 1, null);
            FrameworkLogger.LOGGER.infoFrameworkStarted();
        }
        catch (ResolutionException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        bundleManager.injectedFrameworkActive.uninject();
        super.stop(context);
    }

    public FrameworkState getValue() {
        return (FrameworkState)this.injectedFramework.getValue();
    }

    private int getBeginningStartLevel() {
        String levelSpec = (String)this.getBundleManager().getProperty("org.osgi.framework.startlevel.beginning");
        if (levelSpec != null) {
            try {
                return Integer.parseInt(levelSpec);
            }
            catch (NumberFormatException nfe) {
                FrameworkLogger.LOGGER.errorInvalidBeginningStartLevel(levelSpec);
            }
        }
        return 1;
    }
}

