/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DefaultAutoInstallHandler;
import org.jboss.osgi.framework.internal.DefaultBundleInstallHandler;
import org.jboss.osgi.framework.internal.DefaultEnvironmentPlugin;
import org.jboss.osgi.framework.internal.DefaultFrameworkModuleProvider;
import org.jboss.osgi.framework.internal.DefaultModuleLoaderProvider;
import org.jboss.osgi.framework.internal.DefaultPersistentBundlesHandler;
import org.jboss.osgi.framework.internal.DefaultSystemPathsProvider;
import org.jboss.osgi.framework.internal.DefaultSystemServicesProvider;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkActivator;
import org.jboss.osgi.framework.internal.FrameworkActive;
import org.jboss.osgi.framework.internal.FrameworkCoreServices;
import org.jboss.osgi.framework.internal.FrameworkCreate;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkInit;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkProxy;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.PackageAdminPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.StorageStateProviderPlugin;
import org.jboss.osgi.framework.internal.SystemBundleService;
import org.jboss.osgi.framework.internal.SystemContextService;
import org.jboss.osgi.framework.internal.URLHandlerPlugin;
import org.jboss.osgi.framework.internal.WebXMLVerifierInterceptor;
import org.osgi.framework.launch.Framework;

public final class FrameworkBuilder {
    private final Map<String, Object> initialProperties = new HashMap<String, Object>();
    private final ServiceController.Mode initialMode;
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;
    private boolean closed;

    public FrameworkBuilder(Map<String, Object> props, ServiceController.Mode initialMode) {
        if (initialMode == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("initialMode");
        }
        this.initialMode = initialMode;
        if (props != null) {
            this.initialProperties.putAll(props);
        }
    }

    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.initialProperties.get(key);
        return value != null ? value : defaultValue;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.initialProperties);
    }

    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public void setServiceContainer(ServiceContainer serviceContainer) {
        this.assertNotClosed();
        this.serviceContainer = serviceContainer;
    }

    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    public void setServiceTarget(ServiceTarget serviceTarget) {
        this.assertNotClosed();
        this.serviceTarget = serviceTarget;
    }

    public Framework createFramework() {
        this.assertNotClosed();
        return new FrameworkProxy(this);
    }

    public void createFrameworkServices(boolean firstInit) {
        this.assertNotClosed();
        this.createFrameworkServicesInternal((ServiceRegistry)this.serviceContainer, this.serviceTarget, firstInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createFrameworkServicesInternal(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, boolean firstInit) {
        try {
            URLHandlerPlugin.addService(serviceTarget);
            if (this.getProperty(ModuleLogger.class.getName()) == null) {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
            BundleManagerPlugin bundleManager = BundleManagerPlugin.addService(serviceTarget, this);
            FrameworkState frameworkState = FrameworkCreate.addService(serviceTarget, bundleManager);
            BundleStoragePlugin.addService(serviceTarget, firstInit);
            DefaultEnvironmentPlugin.addService(serviceTarget);
            DeploymentFactoryPlugin.addService(serviceTarget);
            FrameworkActivator.addService(serviceTarget);
            FrameworkActive.addService(serviceTarget, this.initialMode);
            FrameworkCoreServices.addService(serviceTarget);
            FrameworkEventsPlugin.addService(serviceTarget);
            FrameworkInit.addService(serviceTarget);
            LifecycleInterceptorPlugin.addService(serviceTarget);
            ModuleManagerPlugin.addService(serviceTarget);
            NativeCodePlugin.addService(serviceTarget);
            PackageAdminPlugin.addService(serviceTarget);
            ResolverPlugin.addService(serviceTarget);
            ServiceManagerPlugin.addService(serviceTarget);
            StartLevelPlugin.addService(serviceTarget);
            StorageStateProviderPlugin.addService(serviceTarget);
            SystemBundleService.addService(serviceTarget, frameworkState);
            SystemContextService.addService(serviceTarget);
            WebXMLVerifierInterceptor.addService(serviceTarget);
            DefaultAutoInstallHandler.addIntegrationService(serviceRegistry, serviceTarget);
            DefaultBundleInstallHandler.addIntegrationService(serviceRegistry, serviceTarget);
            DefaultFrameworkModuleProvider.addIntegrationService(serviceRegistry, serviceTarget);
            DefaultModuleLoaderProvider.addIntegrationService(serviceRegistry, serviceTarget);
            DefaultPersistentBundlesHandler.addIntegrationService(serviceRegistry, serviceTarget);
            DefaultSystemPathsProvider.addIntegrationService(serviceRegistry, serviceTarget, this);
            DefaultSystemServicesProvider.addIntegrationService(serviceRegistry, serviceTarget);
        }
        finally {
            this.closed = true;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkBuilderClosed();
        }
    }
}

