/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractExecutorService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FragmentBundleState;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.resolver.XPackageCapability;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.resolver.ResolutionException;

public final class PackageAdminPlugin
extends AbstractExecutorService<PackageAdmin>
implements PackageAdmin {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private final InjectedValue<ResolverPlugin> injectedResolver = new InjectedValue();
    private ServiceRegistration registration;

    static void addService(ServiceTarget serviceTarget) {
        PackageAdminPlugin service = new PackageAdminPlugin();
        ServiceBuilder builder = serviceTarget.addService(Services.PACKAGE_ADMIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, service.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, service.injectedFrameworkEvents);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, service.injectedModuleManager);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(InternalServices.RESOLVER_PLUGIN, ResolverPlugin.class, service.injectedResolver);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private PackageAdminPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(PackageAdmin.class.getName(), (Object)this, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
    }

    public PackageAdminPlugin getValue() {
        return this;
    }

    @Override
    ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi PackageAdmin refresh Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle2) {
        if (bundle2 == null) {
            return this.getAllExportedPackages();
        }
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        if (bundleManager.getBundleById(bundle2.getBundleId()) == null) {
            return null;
        }
        ArrayList<ExportedPackageImpl> result = new ArrayList<ExportedPackageImpl>();
        for (AbstractBundleRevision brev : bundleState.getAllBundleRevisions()) {
            if (!brev.isResolved()) continue;
            for (Capability cap : brev.getCapabilities("osgi.wiring.package")) {
                result.add(new ExportedPackageImpl((XPackageCapability)cap));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    private ExportedPackage[] getAllExportedPackages() {
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>();
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        for (Bundle bundle2 : bundleManager.getBundles()) {
            ExportedPackage[] pkgs = this.getExportedPackages(bundle2);
            if (pkgs == null) continue;
            result.addAll(Arrays.asList(pkgs));
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] pkgs = this.getExportedPackagesInternal(name);
        return pkgs.length == 0 ? null : pkgs;
    }

    private ExportedPackage[] getExportedPackagesInternal(String name) {
        assert (name != null) : "Null name";
        HashSet<ExportedPackageImpl> result = new HashSet<ExportedPackageImpl>();
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        for (Bundle bundle2 : bundleManager.getBundles(null)) {
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
            for (AbstractBundleRevision brev : bundleState.getAllBundleRevisions()) {
                if (!brev.isResolved() || brev.isFragment()) continue;
                for (Capability cap : brev.getCapabilities("osgi.wiring.package")) {
                    XPackageCapability xcap = (XPackageCapability)cap;
                    if (!xcap.getPackageName().equals(name)) continue;
                    result.add(new ExportedPackageImpl(xcap));
                }
            }
        }
        return result.toArray(new ExportedPackage[result.size()]);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] exported = this.getExportedPackagesInternal(name);
        ArrayList<ExportedPackage> wired = new ArrayList<ExportedPackage>();
        ArrayList<ExportedPackage> notWired = new ArrayList<ExportedPackage>();
        for (ExportedPackage ep : exported) {
            XPackageCapability cap = ((ExportedPackageImpl)ep).getCapability();
            if (this.isWired(cap)) {
                wired.add(ep);
                continue;
            }
            notWired.add(ep);
        }
        ExportedPackageComparator comparator = new ExportedPackageComparator();
        Collections.sort(wired, comparator);
        Collections.sort(notWired, comparator);
        if (wired.size() > 0) {
            return (ExportedPackage)wired.get(0);
        }
        if (notWired.size() > 0) {
            return (ExportedPackage)notWired.get(0);
        }
        return null;
    }

    private boolean isWired(XPackageCapability cap) {
        BundleWiring wiring = ((BundleRevision)cap.getResource()).getWiring();
        if (wiring != null) {
            for (Wire wire : wiring.getProvidedResourceWires(cap.getNamespace())) {
                if (wire.getCapability() != cap) continue;
                return true;
            }
            List requireBundleWires = wiring.getProvidedResourceWires("osgi.wiring.bundle");
            if (requireBundleWires.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public void refreshPackages(final Bundle[] bundlesToRefresh) {
        final BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)((Object)this.injectedFrameworkEvents.getValue());
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Bundle[] bundles = bundlesToRefresh;
                if (bundles == null) {
                    ArrayList<UserBundleState> bundlesToRefresh2 = new ArrayList<UserBundleState>();
                    for (Bundle bundle2 : bundleManager.getBundles(null)) {
                        UserBundleState userBundle;
                        if (bundle2.getBundleId() == 0L || (userBundle = (UserBundleState)bundle2).getAllBundleRevisions().size() <= 1 && bundle2.getState() != 1) continue;
                        bundlesToRefresh2.add(userBundle);
                    }
                    bundles = bundlesToRefresh2.toArray(new Bundle[bundlesToRefresh2.size()]);
                }
                LinkedHashSet<UserBundleState> providedBundles = new LinkedHashSet<UserBundleState>();
                for (Bundle aux : bundles) {
                    UserBundleState bundleState = UserBundleState.assertBundleState(aux);
                    providedBundles.add(bundleState);
                }
                HashSet<HostBundleState> stopBundles = new HashSet<HostBundleState>();
                HashSet<UserBundleState> refreshBundles = new HashSet<UserBundleState>();
                HashSet<UserBundleState> uninstallBundles = new HashSet<UserBundleState>();
                for (UserBundleState userBundle : providedBundles) {
                    if (userBundle.getState() == 1) {
                        uninstallBundles.add(userBundle);
                        continue;
                    }
                    if (!userBundle.isResolved()) continue;
                    refreshBundles.add(userBundle);
                }
                block9: for (Bundle bundle3 : bundleManager.getBundles()) {
                    AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle3);
                    if (!(bundleState instanceof HostBundleState) || !bundleState.isResolved()) continue;
                    HostBundleState hostBundle = HostBundleState.assertBundleState(bundle3);
                    for (UserBundleState depBundle : hostBundle.getDependentBundles()) {
                        if (!providedBundles.contains(depBundle)) continue;
                        int state = hostBundle.getState();
                        if (state == 32 || state == 8) {
                            stopBundles.add(hostBundle);
                        }
                        refreshBundles.add(hostBundle);
                        continue block9;
                    }
                }
                for (UserBundleState aux : refreshBundles) {
                    int state;
                    if (!(aux instanceof HostBundleState) || (state = aux.getState()) != 32 && state != 8) continue;
                    stopBundles.add((HostBundleState)aux);
                }
                ArrayList stopList = new ArrayList(stopBundles);
                ArrayList refreshList = new ArrayList(refreshBundles);
                BundleStartLevelComparator startLevelComparator = new BundleStartLevelComparator();
                Collections.sort(stopList, startLevelComparator);
                ListIterator it = stopList.listIterator(stopList.size());
                while (it.hasPrevious()) {
                    HostBundleState hostBundle = (HostBundleState)it.previous();
                    try {
                        hostBundle.stop(1);
                    }
                    catch (Exception th) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, th);
                    }
                }
                for (UserBundleState userBundle : uninstallBundles) {
                    bundleManager.removeBundle(userBundle, 0);
                }
                for (UserBundleState userBundle : refreshList) {
                    try {
                        userBundle.refresh();
                    }
                    catch (Exception th) {
                        eventsPlugin.fireFrameworkEvent(userBundle, 2, th);
                    }
                }
                for (HostBundleState hostBundle : stopList) {
                    try {
                        hostBundle.start(1);
                    }
                    catch (Exception th) {
                        eventsPlugin.fireFrameworkEvent(hostBundle, 2, th);
                    }
                }
                eventsPlugin.fireFrameworkEvent(bundleManager.getSystemBundle(), 4, null);
            }
        };
        runner.run();
    }

    /*
     * WARNING - void declaration
     */
    public boolean resolveBundles(Bundle[] bundles) {
        void var7_11;
        ResolverPlugin resolverPlugin = (ResolverPlugin)((Object)this.injectedResolver.getValue());
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        if (bundles == null) {
            Set<Bundle> bundleset = bundleManager.getBundles(2);
            bundles = new Bundle[bundleset.size()];
            bundleset.toArray(bundles);
        }
        LinkedHashSet<AbstractBundleRevision> resolve = new LinkedHashSet<AbstractBundleRevision>();
        Bundle[] arr$ = bundles;
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_11 < len$) {
            Bundle aux = arr$[var7_11];
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(aux);
            resolve.add(bundleState.getCurrentBundleRevision());
            ++var7_11;
        }
        boolean result = true;
        try {
            resolverPlugin.resolveAndApply(resolve, null);
            for (Resource resource : resolve) {
                if (((AbstractBundleRevision)resource).isResolved()) continue;
                result = false;
                break;
            }
        }
        catch (ResolutionException ex) {
            FrameworkLogger.LOGGER.debugf(ex, "Cannot resolve: " + resolve, new Object[0]);
            result = false;
        }
        return result;
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        ArrayList<HostBundleState> matchingHosts = new ArrayList<HostBundleState>();
        if (symbolicName != null) {
            for (Bundle aux : bundleManager.getBundles(symbolicName, null)) {
                if (!(aux instanceof HostBundleState)) continue;
                matchingHosts.add((HostBundleState)aux);
            }
        } else {
            for (Bundle aux : bundleManager.getBundles()) {
                if (!(aux instanceof HostBundleState)) continue;
                matchingHosts.add((HostBundleState)aux);
            }
        }
        if (matchingHosts.isEmpty()) {
            return null;
        }
        ArrayList<RequiredBundleImpl> result = new ArrayList<RequiredBundleImpl>();
        for (AbstractBundleState abstractBundleState : matchingHosts) {
            AbstractBundleRevision brev = abstractBundleState.getCurrentBundleRevision();
            HashSet<AbstractBundleState> requiringBundles = new HashSet<AbstractBundleState>();
            BundleWiring wiring = brev.getWiring();
            if (wiring != null) {
                List providedWires = wiring.getProvidedResourceWires("osgi.wiring.bundle");
                for (Wire wire : providedWires) {
                    Bundle bundle2 = ((BundleRevision)wire.getRequirer()).getBundle();
                    requiringBundles.add(AbstractBundleState.assertBundleState(bundle2));
                }
            }
            result.add(new RequiredBundleImpl(abstractBundleState, requiringBundles));
        }
        return result.toArray(new RequiredBundle[matchingHosts.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        TreeSet<Bundle> sortedSet = new TreeSet<Bundle>(new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                return b2.getVersion().compareTo((Object)b1.getVersion());
            }
        });
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        for (Bundle bundleState : bundleManager.getBundles(symbolicName, versionRange)) {
            if (bundleState.getState() == 1) continue;
            sortedSet.add(bundleState);
        }
        if (sortedSet.isEmpty()) {
            return null;
        }
        return sortedSet.toArray(new Bundle[sortedSet.size()]);
    }

    public Bundle[] getFragments(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        if (bundle2.getBundleId() == 0L || bundleState.isFragment() || !bundleState.isResolved()) {
            return null;
        }
        HostBundleState hostBundle = HostBundleState.assertBundleState(bundleState);
        HostBundleRevision curRevision = hostBundle.getCurrentBundleRevision();
        ArrayList<FragmentBundleState> result = new ArrayList<FragmentBundleState>();
        for (FragmentBundleRevision aux : curRevision.getAttachedFragments()) {
            result.add(aux.getBundleState());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle[] getHosts(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        if (!bundleState.isFragment()) {
            return null;
        }
        FragmentBundleState fragBundle = FragmentBundleState.assertBundleState(bundleState);
        FragmentBundleRevision curRevision = fragBundle.getCurrentBundleRevision();
        ArrayList<HostBundleState> result = new ArrayList<HostBundleState>();
        for (HostBundleRevision aux : curRevision.getAttachedHosts()) {
            result.add(aux.getBundleState());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public Bundle getBundle(Class clazz) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)((Object)this.injectedModuleManager.getValue());
        AbstractBundleState bundleState = moduleManager.getBundleState(clazz);
        return bundleState != null ? bundleState : null;
    }

    public int getBundleType(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        return bundleState.isFragment() ? 1 : 0;
    }

    private static class ExportedPackageComparator
    implements Comparator<ExportedPackage> {
        private ExportedPackageComparator() {
        }

        @Override
        public int compare(ExportedPackage ep1, ExportedPackage ep2) {
            return ep2.getVersion().compareTo((Object)ep1.getVersion());
        }
    }

    private static class BundleStartLevelComparator
    implements Comparator<HostBundleState> {
        private BundleStartLevelComparator() {
        }

        @Override
        public int compare(HostBundleState o1, HostBundleState o2) {
            int sl2;
            int sl1 = o1.getStartLevel();
            return sl1 < (sl2 = o2.getStartLevel()) ? -1 : (sl1 == sl2 ? 0 : 1);
        }
    }

    static class RequiredBundleImpl
    implements RequiredBundle {
        private final Bundle requiredBundle;
        private final Bundle[] requiringBundles;
        private final AbstractBundleRevision bundleRevision;

        RequiredBundleImpl(AbstractBundleState requiredBundle, Collection<AbstractBundleState> requiringBundles) {
            this.requiredBundle = AbstractBundleState.assertBundleState(requiredBundle);
            this.bundleRevision = requiredBundle.getCurrentBundleRevision();
            ArrayList<AbstractBundleState> bundles = new ArrayList<AbstractBundleState>(requiringBundles.size());
            for (AbstractBundleState ab : requiringBundles) {
                bundles.add(AbstractBundleState.assertBundleState(ab));
            }
            this.requiringBundles = bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSymbolicName() {
            return this.requiredBundle.getSymbolicName();
        }

        public Bundle getBundle() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiredBundle;
        }

        public Bundle[] getRequiringBundles() {
            if (this.isRemovalPending()) {
                return null;
            }
            return this.requiringBundles;
        }

        public Version getVersion() {
            return this.requiredBundle.getVersion();
        }

        public boolean isRemovalPending() {
            if (this.requiredBundle.getState() == 1) {
                return true;
            }
            return !((Object)((Object)this.bundleRevision)).equals((Object)this.bundleRevision.getBundleState().getCurrentBundleRevision());
        }

        public String toString() {
            return "RequiredBundle[" + this.requiredBundle + "]";
        }
    }

    static class ExportedPackageImpl
    implements ExportedPackage {
        private final XPackageCapability capability;

        ExportedPackageImpl(XPackageCapability cap) {
            this.capability = cap;
        }

        public String getName() {
            return this.capability.getPackageName();
        }

        public Bundle getExportingBundle() {
            return ((BundleRevision)this.capability.getResource()).getBundle();
        }

        public Bundle[] getImportingBundles() {
            AbstractBundleRevision req;
            if (this.isRemovalPending()) {
                return null;
            }
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            BundleWiring wiring = ((BundleRevision)this.capability.getResource()).getWiring();
            for (Wire wire : wiring.getProvidedResourceWires(this.capability.getNamespace())) {
                req = (AbstractBundleRevision)wire.getRequirer();
                bundles.add(req.getBundle());
            }
            for (Wire wire : wiring.getProvidedResourceWires("osgi.wiring.bundle")) {
                req = (AbstractBundleRevision)wire.getRequirer();
                bundles.add(req.getBundle());
            }
            return bundles.toArray(new Bundle[bundles.size()]);
        }

        public String getSpecificationVersion() {
            return this.capability.getVersion().toString();
        }

        public Version getVersion() {
            return this.capability.getVersion();
        }

        public boolean isRemovalPending() {
            AbstractBundleState bundleState;
            AbstractBundleRevision brev = (AbstractBundleRevision)this.capability.getResource();
            return brev != (bundleState = brev.getBundleState()).getCurrentBundleRevision() || bundleState.getState() == 1;
        }

        private XPackageCapability getCapability() {
            return this.capability;
        }

        public String toString() {
            return "ExportedPackage[" + this.capability + "]";
        }
    }
}

