/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.framework.internal.FrameworkLogger;

public class ServiceTracker<S>
extends AbstractServiceListener<S> {
    private final Set<ServiceName> addedNames = new HashSet<ServiceName>();
    private final Set<ServiceController<? extends S>> trackedController = new HashSet<ServiceController<? extends S>>();
    private final AtomicBoolean allComplete = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenerAdded(ServiceController<? extends S> controller) {
        Set<ServiceController<? extends S>> set = this.trackedController;
        synchronized (set) {
            FrameworkLogger.LOGGER.tracef("ServiceTracker controller added: %s", controller);
            this.addedNames.add(controller.getName());
            this.trackedController.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(ServiceController<? extends S> controller, ServiceController.Transition transition) {
        Set<ServiceController<? extends S>> set = this.trackedController;
        synchronized (set) {
            switch (transition) {
                case STARTING_to_UP: {
                    FrameworkLogger.LOGGER.tracef("ServiceTracker transition to UP: " + controller.getName(), new Object[0]);
                    this.serviceStarted(controller);
                    this.serviceComplete(controller);
                    break;
                }
                case STARTING_to_START_FAILED: {
                    FrameworkLogger.LOGGER.tracef("ServiceTracker transition to START_FAILED: " + controller.getName(), new Object[0]);
                    StartException ex = controller.getStartException();
                    this.serviceStartFailed(controller, ex);
                    this.serviceComplete(controller);
                }
            }
        }
    }

    private void serviceComplete(ServiceController<? extends S> controller) {
        this.trackedController.remove(controller);
        controller.removeListener((ServiceListener)this);
        this.checkAndComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndComplete() {
        Set<ServiceController<? extends S>> set = this.trackedController;
        synchronized (set) {
            if (this.trackedController.size() == 0 && this.allServicesAdded(Collections.unmodifiableSet(this.addedNames)) && this.allComplete.compareAndSet(false, true)) {
                FrameworkLogger.LOGGER.tracef("ServiceTracker complete: " + ((Object)((Object)this)).getClass().getName(), new Object[0]);
                this.complete();
            }
        }
    }

    protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
        return true;
    }

    protected void serviceStartFailed(ServiceController<? extends S> controller, StartException ex) {
    }

    protected void serviceStarted(ServiceController<? extends S> controller) {
    }

    protected void complete() {
    }
}

