/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceStatisticsListener;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDataSourceAdd
extends AbstractAddStepHandler {
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = this.createResource(context);
        this.populateModel(context, operation, resource);
        final ModelNode model = resource.getModel();
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    AbstractDataSourceAdd.this.performRuntime(context, operation, resource, model, verificationHandler, controllers);
                    if (AbstractDataSourceAdd.this.requiresRuntimeVerification()) {
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractDataSourceAdd.this.rollbackRuntime(context, operation, model, controllers);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected final void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performRuntime(OperationContext context, ModelNode operation, Resource resource, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        String jndiName = model.get(Constants.JNDINAME.getName()).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean enabled = false;
        ModelNode node = Constants.DATASOURCE_DRIVER.resolveModelAttribute(context, model);
        AbstractDataSourceService dataSourceService = this.createDataSourceService(dsName);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder dataSourceServiceBuilder = serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME);
        dataSourceServiceBuilder.addListener((ServiceListener)new DataSourceStatisticsListener(registration, resource, dsName));
        this.startConfigAndAddDependency(dataSourceServiceBuilder, dataSourceService, dsName, serviceTarget, operation, verificationHandler);
        String driverName = node.asString();
        ServiceName driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        if (!context.isBooting()) {
            ServiceRegistry registry = context.getServiceRegistry(true);
            ServiceController dataSourceController = registry.getService(driverServiceName);
            if (driverServiceName == null || dataSourceController == null) throw new OperationFailedException(ConnectorMessages.MESSAGES.driverNotPresent(driverName));
            dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        } else {
            dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        }
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.NEVER);
        controllers.add(dataSourceServiceBuilder.install());
    }

    static String cleanupJavaContext(String jndiName) {
        String bindName = jndiName.startsWith("java:/") ? jndiName.substring(6) : (jndiName.startsWith("java:") ? jndiName.substring(5) : jndiName);
        return bindName;
    }

    protected abstract void startConfigAndAddDependency(ServiceBuilder<?> var1, AbstractDataSourceService var2, String var3, ServiceTarget var4, ModelNode var5, ServiceVerificationHandler var6) throws OperationFailedException;

    protected abstract void populateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

    protected abstract AbstractDataSourceService createDataSourceService(String var1) throws OperationFailedException;

    static void populateAddModel(ModelNode operation, ModelNode modelNode, String connectionPropertiesProp, SimpleAttributeDefinition[] attributes) throws OperationFailedException {
        if (operation.hasDefined(connectionPropertiesProp)) {
            for (Property property : operation.get(connectionPropertiesProp).asPropertyList()) {
                modelNode.get(new String[]{connectionPropertiesProp, property.getName()}).set(property.getValue().asString());
            }
        }
        for (SimpleAttributeDefinition attribute : attributes) {
            attribute.validateAndSet(operation, modelNode);
        }
    }
}

