/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.util.AbstractParser;
import org.jboss.as.connector.util.ParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.v11.DataSource;
import org.jboss.jca.common.api.metadata.ds.v11.DsPool;
import org.jboss.jca.common.api.metadata.ds.v11.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.v11.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class DsParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public void parse(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws Exception {
        int iterate;
        Object dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        this.parseDataSources(reader, list, parentAddress);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void parseDataSources(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        boolean driversMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return;
                    }
                }
                case 1: {
                    switch (DataSources.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE: {
                            this.parseDataSource(reader, list, parentAddress);
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            this.parseXADataSource(reader, list, parentAddress);
                            break block0;
                        }
                        case DRIVERS: {
                            driversMatched = true;
                            break block0;
                        }
                        case DRIVER: {
                            this.parseDriver(reader, list, parentAddress);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDriver(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        ModelNode driverAddress = parentAddress.clone();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String driverName = null;
        block15: for (Driver.Attribute attribute : Driver.Attribute.values()) {
            switch (attribute) {
                case NAME: {
                    driverName = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_NAME.getXmlName());
                    Constants.DRIVER_NAME.parseAndSetParameter(driverName, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MAJOR_VERSION: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MAJOR_VERSION.getXmlName());
                    Constants.DRIVER_MAJOR_VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MINOR_VERSION: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MINOR_VERSION.getXmlName());
                    Constants.DRIVER_MINOR_VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MODULE: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.DRIVER_MODULE_NAME.getXmlName());
                    Constants.DRIVER_MODULE_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
            }
        }
        driverAddress.add("jdbc-driver", driverName);
        driverAddress.protect();
        operation.get("address").set(driverAddress);
        boolean driverClassMatched = false;
        boolean xaDatasourceClassMatched = false;
        boolean datasourceClassMatched = false;
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DRIVER) {
                        list.add(operation);
                        return;
                    }
                    if (Driver.Tag.forName((String)reader.getLocalName()) != Driver.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Driver.Tag.forName((String)reader.getLocalName())) {
                        case DATASOURCE_CLASS: {
                            if (datasourceClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_DATASOURCE_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_DATASOURCE_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            datasourceClassMatched = true;
                            break block6;
                        }
                        case XA_DATASOURCE_CLASS: {
                            if (xaDatasourceClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            xaDatasourceClassMatched = true;
                            break block6;
                        }
                        case DRIVER_CLASS: {
                            if (driverClassMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.DRIVER_CLASS_NAME.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            driverClassMatched = true;
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXADataSource(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = false;
        block28: for (DataSource.Attribute attribute : DataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block28;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block28;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    Constants.JNDINAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block28;
                }
                case USE_JAVA_CONTEXT: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block28;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case SPY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block28;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case USE_CCM: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block28;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
                case JTA: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block28;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block28;
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("xa-data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> xadatasourcePropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block9 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        list.add(operation);
                        list.addAll(xadatasourcePropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.XADATASOURCE_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.XADATASOURCE_PROPERTY_VALUE.parseAndSetParameter(value, configOperation, (XMLStreamReader)reader);
                            xadatasourcePropertiesOperations.add(configOperation);
                            break block9;
                        }
                        case XA_DATASOURCE_CLASS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XADATASOURCECLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case XA_POOL: {
                            this.parseXaPool(reader, operation);
                            break block9;
                        }
                        case NEW_CONNECTION_SQL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_DELIMITER: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case TRANSACTION_ISOLATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block9;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block9;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block9;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting(reader, operation);
                            break block9;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, operation);
                            break block9;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDsSecurity(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        boolean securityDomainMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (DsSecurity.Tag.forName((String)reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            if (securityDomainMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.SECURITY_DOMAIN.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            securityDomainMatched = true;
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), operation, Constants.REAUTHPLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseDataSource(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        String poolName = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        boolean enabled = Defaults.ENABLED;
        boolean persistEnabled = true;
        block29: for (DataSource.Attribute attribute : DataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block29;
                    enabled = Boolean.parseBoolean(value);
                    persistEnabled = true;
                    continue block29;
                }
                case JNDI_NAME: {
                    String jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    Constants.JNDINAME.parseAndSetParameter(jndiName, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block29;
                }
                case USE_JAVA_CONTEXT: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block29;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case SPY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.SPY.getXmlName());
                    if (value == null) continue block29;
                    Constants.SPY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case USE_CCM: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_CCM.getXmlName());
                    if (value == null) continue block29;
                    Constants.USE_CCM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
                case JTA: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.JTA.getXmlName());
                    if (value == null) continue block29;
                    Constants.JTA.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block29;
                }
            }
        }
        ModelNode dsAddress = parentAddress.clone();
        dsAddress.add("data-source", poolName);
        dsAddress.protect();
        operation.get("address").set(dsAddress);
        ArrayList<ModelNode> configPropertiesOperations = new ArrayList<ModelNode>(0);
        while (reader.hasNext()) {
            block9 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        list.add(operation);
                        list.addAll(configPropertiesOperations);
                        if (enabled) {
                            ModelNode enableOperation = new ModelNode();
                            enableOperation.get("operation").set("enable");
                            enableOperation.get("address").set(dsAddress);
                            enableOperation.get("persistent").set(persistEnabled);
                            list.add(enableOperation);
                        }
                        return;
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                            String value = this.rawElementText((XMLStreamReader)reader);
                            ModelNode configOperation = new ModelNode();
                            configOperation.get("operation").set("add");
                            ModelNode configAddress = dsAddress.clone();
                            configAddress.add(Constants.CONNECTION_PROPERTIES.getName(), name);
                            configAddress.protect();
                            configOperation.get("address").set(configAddress);
                            Constants.CONNECTION_PROPERTY_VALUE.parseAndSetParameter(value, configOperation, (XMLStreamReader)reader);
                            configPropertiesOperations.add(configOperation);
                            break block9;
                        }
                        case CONNECTION_URL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CONNECTION_URL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER_CLASS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DRIVER_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DATASOURCE_CLASS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case DRIVER: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.DATASOURCE_DRIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case POOL: {
                            this.parsePool(reader, operation);
                            break block9;
                        }
                        case NEW_CONNECTION_SQL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.NEW_CONNECTION_SQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_DELIMITER: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_DELIMITER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.URL_SELECTOR_STRATEGY_CLASS_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case TRANSACTION_ISOLATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_ISOLATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block9;
                        }
                        case SECURITY: {
                            this.parseDsSecurity(reader, operation);
                            break block9;
                        }
                        case STATEMENT: {
                            this.parseStatementSettings(reader, operation);
                            break block9;
                        }
                        case TIMEOUT: {
                            this.parseTimeOutSettings(reader, operation);
                            break block9;
                        }
                        case VALIDATION: {
                            this.parseValidationSetting(reader, operation);
                            break block9;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parsePool(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return;
                    }
                    if (DsPool.Tag.forName((String)reader.getLocalName()) != DsPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            Constants.ALLOW_MULTIPLE_USERS.parseAndSetParameter("true", operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case UNKNOWN: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseXaPool(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return;
                    }
                    if (DsXaPool.Tag.forName((String)reader.getLocalName()) != DsXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            Constants.ALLOW_MULTIPLE_USERS.parseAndSetParameter("true", operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.INTERLEAVING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SAME_RM_OVERRIDE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.NOTXSEPARATEPOOL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PAD_XID: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PAD_XID.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.WRAP_XA_RESOURCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseRecovery(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        block11: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.NO_RECOVERY.getXmlName());
                    Constants.NO_RECOVERY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return;
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            this.parseCredential(reader, operation);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), operation, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseCredential(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseValidationSetting(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return;
                    }
                    if (Validation.Tag.forName((String)reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName((String)reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUND_VALIDATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.CHECKVALIDCONNECTIONSQL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.EXCEPTIONSORTERCLASSNAME, Constants.EXCEPTIONSORTER_PROPERTIES);
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.STALECONNECTIONCHECKERCLASSNAME, Constants.STALECONNECTIONCHECKER_PROPERTIES);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.VALIDATEONMATCH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            this.parseExtension(reader, currTag.getLocalName(), operation, Constants.VALIDCONNECTIONCHECKERCLASSNAME, Constants.VALIDCONNECTIONCHECKER_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseTimeOutSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return;
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.ALLOCATION_RETRY_WAIT_MILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.QUERYTIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.SETTXQUERYTIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.USETRYLOCK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.XA_RESOURCE_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseStatementSettings(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return;
                    }
                    if (Statement.Tag.forName((String)reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Statement.Tag.forName((String)reader.getLocalName())) {
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PREPAREDSTATEMENTSCACHESIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRACKSTATEMENTS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.SHAREPREPAREDSTATEMENTS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

