/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ManagementModelNode
extends DefaultMutableTreeNode {
    private CommandExecutor executor = GuiMain.getExecutor();
    private boolean isLeaf = false;
    private boolean isGeneric = false;

    public ManagementModelNode() {
        this.isLeaf = false;
        this.setUserObject("/");
    }

    private ManagementModelNode(UserObject userObject) {
        this.isLeaf = userObject.isLeaf;
        this.isGeneric = userObject.isGeneric;
        if (this.isGeneric) {
            this.setAllowsChildren(false);
        }
        this.setUserObject(userObject);
    }

    public void explore() {
        if (this.isLeaf) {
            return;
        }
        if (this.isGeneric) {
            return;
        }
        this.removeAllChildren();
        try {
            String addressPath = this.addressPath();
            ModelNode response = this.executor.doCommand(addressPath + ":read-resource");
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return;
            }
            List<String> childrenTypes = this.getChildrenTypes(addressPath);
            for (ModelNode node : result.asList()) {
                Property prop = node.asProperty();
                if (childrenTypes.contains(prop.getName())) {
                    if (this.hasGenericOperations(addressPath, prop.getName())) {
                        this.add(new ManagementModelNode(new UserObject(prop.getName())));
                    }
                    if (!prop.getValue().isDefined()) continue;
                    for (ModelNode innerNode : prop.getValue().asList()) {
                        UserObject usrObj = new UserObject(prop.getName(), innerNode.asProperty().getName(), false);
                        this.add(new ManagementModelNode(usrObj));
                    }
                    continue;
                }
                UserObject usrObj = new UserObject(prop.getName(), prop.getValue().asString(), true);
                this.add(new ManagementModelNode(usrObj));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasGenericOperations(String addressPath, String resourceName) throws Exception {
        ModelNode response = this.executor.doCommand(addressPath + resourceName + "=*/:read-operation-names");
        if (response.get("outcome").asString().equals("failed")) {
            return false;
        }
        for (ModelNode node : response.get("result").asList()) {
            if (!node.asString().equals("add")) continue;
            return true;
        }
        return false;
    }

    private List<String> getChildrenTypes(String addressPath) throws Exception {
        ArrayList<String> childrenTypes = new ArrayList<String>();
        ModelNode readChildrenTypes = this.executor.doCommand(addressPath + ":read-children-types");
        for (ModelNode type : readChildrenTypes.get("result").asList()) {
            childrenTypes.add(type.asString());
        }
        return childrenTypes;
    }

    public String addressPath() {
        if (this.isLeaf) {
            ManagementModelNode parent = (ManagementModelNode)this.getParent();
            return parent.addressPath();
        }
        StringBuilder builder = new StringBuilder("/");
        for (Object pathElement : this.getUserObjectPath()) {
            String pathElementStr = pathElement.toString();
            if (pathElementStr.equals("/")) continue;
            UserObject userObj = (UserObject)pathElement;
            builder.append(userObj.getName());
            builder.append("=");
            builder.append(userObj.getEscapedValue());
            builder.append("/");
        }
        return builder.toString();
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public static String escapeAddressElement(String element) {
        element = element.replace(":", "\\:");
        element = element.replace("/", "\\/");
        element = element.replace("=", "\\=");
        return element;
    }

    class UserObject {
        private String name;
        private String value;
        private boolean isLeaf;
        private boolean isGeneric = false;
        private String separator;

        public UserObject(String name) {
            this.name = name;
            this.value = "*";
            this.isLeaf = false;
            this.isGeneric = true;
            this.separator = "=";
        }

        public UserObject(String name, String value, boolean isLeaf) {
            this.name = name;
            this.value = value;
            this.isLeaf = isLeaf;
            this.separator = isLeaf ? " => " : "=";
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getEscapedValue() {
            return ManagementModelNode.escapeAddressElement(this.value);
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public boolean isGeneric() {
            return this.isGeneric;
        }

        public String toString() {
            return this.name + this.separator + this.value;
        }
    }
}

